/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.toolbar;

import oracle.bpm.designer.DesignerStateManager;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.designer.toolbar.FlowNodeToolBarAction;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.CapabilityType;
import oracle.bpm.diagram.editor.state.AbstractDesignerState;
import oracle.bpm.diagram.editor.state.AddingState;
import oracle.bpm.draw.figure.FlowFigureType;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import org.jetbrains.annotations.NotNull;

class AddFlowNodeFromToolbarAction
extends FlowNodeToolBarAction {
    @NotNull
    private DesignerStateManager manager;
    @NotNull
    private FlowFigureType type;

    AddFlowNodeFromToolbarAction(@NotNull FlowFigureType type, @NotNull DesignerStateManager manager) {
        super(type.getLabel());
        this.type = type;
        this.manager = manager;
    }

    public void run() {
        FlowElementController controller = ControllerUtils.createFlowElementControllerFromType(this.type, this.manager.getDomain());
        this.manager.getCurrentState().cancel();
        this.manager.setCurrentState((AbstractDesignerState)new AddingState(CapabilityType.ADD_NODE, (Controller)controller));
    }

    @Override
    public void updateTheme(DefaultTheme theme) {
        this.setSmallIcon(theme.getImageFor(this.type, ImageType.ICON));
    }
}

