/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import oracle.bpm.designer.capability.drag.NoteResizeCapability;
import oracle.bpm.designer.controller.NoteController;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.draw.renderer.Renderer;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.subcontroller.ResizeSubcontroller;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.TextAnnotation;
import org.jetbrains.annotations.NotNull;

public class NoteResizeSubcontroller
extends ResizeSubcontroller<TextAnnotation> {
    private static final int CORNER_HANDLER_SIZE = 12;

    private NoteResizeSubcontroller(NoteController controller) {
        super((Controller)controller, new DrawableCornerResize<TextAnnotation>(controller));
        this.install((Capability)new NoteResizeCapability(this));
    }

    public static ResizeSubcontroller<TextAnnotation> appendTo(@NotNull NoteController controller) {
        NoteResizeSubcontroller subcontroller = new NoteResizeSubcontroller(controller);
        subcontroller.add();
        return subcontroller;
    }

    private static class DrawableCornerResize<T>
    extends DrawableImpl<T>
    implements Renderer {
        private final Controller<T> container;

        protected DrawableCornerResize(@NotNull Controller<T> container) {
            super(container.getDrawableObject(), container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
            this.attachRenderer(this);
        }

        @NotNull
        public Rectangle getBounds() {
            Rectangle result = this.container.getSelection().isPrimary() ? Rectangle.valueOf(this.getContainer().getWidth() - 12, this.getContainer().getHeight() - 12, 12, 12) : Rectangle.ZERO;
            return result;
        }

        public void render() {
            if (this.container.getSelection().isPrimary()) {
                DiagramContext context = this.getContext();
                Rectangle bounds = context.scale(this.getBounds());
                Graphics graphics = context.getGraphics();
                Point origin = bounds.getOrigin();
                Point top = bounds.getTop();
                GeneralPath path = new GeneralPath();
                path.moveTo(top.getX(), origin.getY());
                path.lineTo(top.getX(), top.getY());
                path.lineTo(origin.getX(), top.getY());
                path.closePath();
                graphics.fill((Shape)path);
            }
        }
    }
}

