/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.preferences.HighlightLevel;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.editor.Controller;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.edit.ParentContainerEditCapability;
import oracle.bpm.diagram.editor.capability.focus.FocusCapability;
import oracle.bpm.diagram.editor.capability.selection.ParentContainerSelectionCapability;
import oracle.bpm.diagram.editor.subcontroller.SubcontrollerImpl;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.ErrorSource;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Ui;
import org.jetbrains.annotations.NotNull;

public class HighlightSubcontroller<T>
extends SubcontrollerImpl<T> {
    protected HighlightSubcontroller(Controller<T> container, DrawableHighlight<T> inset) {
        super(container, inset);
        this.install((Capability)new FocusCapability((CapableController)this));
        this.install((Capability)new ParentContainerSelectionCapability((CapableController)this));
        this.install((Capability)new ParentContainerEditCapability((CapableController)this));
    }

    private HighlightSubcontroller(Controller<T> container) {
        this(container, new DrawableHighlight<T>(container));
    }

    public static <T> void appendTo(@NotNull Controller<T> controller) {
        if (HighlightSubcontroller.applies(controller)) {
            new HighlightSubcontroller<T>(controller).add();
        }
    }

    public static boolean applies(@NotNull Controller controller) {
        return controller.getModelObject() instanceof ErrorSource;
    }

    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    protected static class DrawableHighlight<T>
    extends DrawableImpl<T> {
        private Controller<T> owner;
        private static final Image WARNING_ICON = Ui.supportsSVG() ? HighlightLevel.WARNING.getSvgIcon() : HighlightLevel.WARNING.getIcon();
        private static final Image ERROR_ICON = Ui.supportsSVG() ? HighlightLevel.ERROR.getSvgIcon() : HighlightLevel.ERROR.getIcon();

        protected DrawableHighlight(@NotNull Controller<T> owner) {
            super(owner.getDrawableObject(), owner.getModelObject(), DesignerLayer.CAPABILITY);
            this.owner = owner;
        }

        @NotNull
        public Rectangle getBounds() {
            Rectangle result;
            Image image = this.getHighlightImage();
            if (image != null) {
                Point location = this.getContainerLocation(image);
                result = Rectangle.valueOf(location, image.getDimension());
            } else {
                result = Rectangle.ZERO;
            }
            return result;
        }

        public void draw() {
            Image image = this.getHighlightImage();
            if (image != null) {
                DiagramContext context = this.getContext();
                Rectangle bounds = context.scale(this.getBounds());
                context.getGraphics().drawImage(image, bounds);
            }
        }

        protected Image getHighlightImage() {
            HighlightLevel level = DesignerPreferences.getPreferences().getHighlight();
            ErrorSource source = this.getErrorSource();
            return (level.isError() || level.isWarning()) && source.hasNestedErrors() ? ERROR_ICON : (level.isWarning() && source.hasNestedWarnings() ? WARNING_ICON : null);
        }

        protected int getInset() {
            return 4;
        }

        protected Point getContainerLocation(@NotNull Image image) {
            return new Point(this.getContainer().getWidth() - image.getWidth() - this.getInset(), this.getContainer().getHeight() - image.getHeight() - this.getInset());
        }

        private ErrorSource getErrorSource() {
            return (ErrorSource)this.owner.getModelObject();
        }
    }
}

