/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.subcontroller;

import oracle.bpm.designer.capability.edit.ExpandCollapseCapability;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.diagram.draw.DesignerLayer;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.diagram.draw.Drawable;
import oracle.bpm.diagram.draw.DrawableImpl;
import oracle.bpm.diagram.editor.capability.Capability;
import oracle.bpm.diagram.editor.capability.CapableController;
import oracle.bpm.diagram.editor.capability.focus.FocusCapability;
import oracle.bpm.diagram.editor.subcontroller.SubcontrollerImpl;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Graphics;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Cursor;
import oracle.bpm.ui.Image;
import org.jetbrains.annotations.NotNull;

public class ExpandCollapseSubcontroller
extends SubcontrollerImpl<Subprocess> {
    private ExpandCollapseSubcontroller(@NotNull FlowNodeController<Subprocess> controller) {
        super(controller, (Drawable)new ExpandCollapseSubdrawable(controller));
        this.install((Capability)new FocusCapability((CapableController)this));
        this.install((Capability)new ExpandCollapseCapability(this));
    }

    public static void appendTo(@NotNull FlowNodeController container) {
        if (ExpandCollapseSubcontroller.applies(container)) {
            new ExpandCollapseSubcontroller(container).add();
        }
    }

    public static boolean applies(@NotNull FlowNodeController controller) {
        return controller.getModelObject() instanceof Subprocess;
    }

    @NotNull
    public Cursor getCursor() {
        return Cursor.HAND_CURSOR;
    }

    private static class ExpandCollapseSubdrawable
    extends DrawableImpl<Subprocess> {
        private Rectangle cache = Rectangle.ZERO;
        private final FlowNodeController<Subprocess> container;
        private static final Image EXPAND_IMAGE = Image.create((Msg)ProjectDrawMsg.EXPAND);
        private static final Image COLLAPSE_IMAGE = Image.create((Msg)ProjectDrawMsg.COLLAPSE);
        private static final int DISTANCE_GAP = 2;

        public ExpandCollapseSubdrawable(@NotNull FlowNodeController<Subprocess> container) {
            super(container.getDrawableObject(), (Object)container.getModelObject(), DesignerLayer.CAPABILITY);
            this.container = container;
        }

        public void draw() {
            DiagramContext context = this.getContext();
            Rectangle scaled = context.scale(this.getBounds());
            Graphics graphics = context.getGraphics();
            Color original = graphics.getForeground();
            graphics.setForeground(Color.TRANSLUCENT);
            graphics.drawImage(this.getCurrentImage(), scaled);
            graphics.setForeground(original);
        }

        protected Rectangle createBounds() {
            this.setupWidthHeightAndLocation();
            return super.createBounds();
        }

        protected boolean needsUpdate() {
            return super.needsUpdate() || !this.cache.equals(this.container.getDrawableObject().getBounds());
        }

        private Image getCurrentImage() {
            return ModelUtils.isCollapsed((Subprocess)this.container.getModelObject()) ? EXPAND_IMAGE : COLLAPSE_IMAGE;
        }

        private void setupWidthHeightAndLocation() {
            Rectangle parent = this.container.getDrawableObject().getBounds();
            Image image = this.getCurrentImage();
            this.locateAtCenterWithHeightDelta(parent, image);
            this.cache = parent;
        }

        private void locateAtCenterWithHeightDelta(@NotNull Rectangle parent, @NotNull Image image) {
            this.setWidth(image.getWidth());
            this.setHeight(image.getHeight());
            int dy = -this.getHeight() / 2 - 2;
            this.setLocation(new Point(parent.getWidth() / 2, parent.getHeight() + dy));
        }
    }
}

