/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation.wizard;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.wizard.NewSimulationWizard;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.action.BaseAction;
import org.jetbrains.annotations.Nullable;

public class NewSimulationWizardAction
extends BaseAction {
    private Process process;

    public NewSimulationWizardAction() {
        this(DesignerMsg.NEW_SIMULATION_FROM_WIZARD);
        this.requires(Process.class);
    }

    public NewSimulationWizardAction(Msg msg) {
        super(msg);
    }

    public NewSimulationWizardAction(Process process) {
        this();
        this.process = process;
    }

    public NewSimulationWizardAction(Msg msg, Process process) {
        this(msg);
        this.requires(Process.class);
        this.process = process;
    }

    public void run() {
        NewSimulationWizard wizard = new NewSimulationWizard(this.getProcess());
        wizard.build();
        wizard.run();
        if (!wizard.isCancelled()) {
            ProjectObject toOpen;
            Boolean openDefinition = (Boolean)wizard.getProperty("ACTION_OPEN_DEFINITION");
            Boolean openModel = (Boolean)wizard.getProperty("ACTION_OPEN_MODEL");
            Boolean runSimulation = (Boolean)wizard.getProperty("ACTION_RUN_SIMULATION");
            String simulationId = (String)wizard.getProperty("SIMULATION_DEFINITION_ID");
            if (openModel.booleanValue()) {
                toOpen = (ProjectObject)wizard.getProperty("MODEL_SIMULATION");
                AbstractStudioWorkbench.getInstance().openEditorForObject(toOpen);
            }
            if (openDefinition.booleanValue()) {
                toOpen = (ProjectObject)wizard.getProperty("SIMULATION_DEFINITION");
                AbstractStudioWorkbench.getInstance().openEditorForObject(toOpen);
            }
            if (runSimulation.booleanValue()) {
                AbstractStudioWorkbench.getInstance().activateSimulation(simulationId);
            }
        }
    }

    public boolean showsDialog() {
        return true;
    }

    @Nullable
    private Process getProcess() {
        Process projectObject = (Process)this.getSelection().as(Process.class);
        return projectObject;
    }
}

