/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation.wizard;

import fuego.simulation.ProjectSimulationBuilder;
import fuego.simulation.SimulationDefaults;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.NewModelSimulationAction;
import oracle.bpm.designer.simulation.SimulationModelNameInputValidator;
import oracle.bpm.designer.simulation.SimulationNameInputValidator;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.lang.Time;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.UserTask;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.editors.NumericFieldCellEditor;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NonScrollTextArea;
import oracle.bpm.ui.text.NumericField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.WizardStepPanel;

public class NewSimulationWizard
extends Wizard {
    private Process process;
    static final String MODEL_SIMULATION = "MODEL_SIMULATION";
    private static final String MODEL_SIMULATION_ID = "MODEL_SIMULATION_ID";
    private static final String MODEL_SIMULATION_USE_MAX_INSTANCES = "MODEL_SIMULATION_USE_MAX_INSTANCES";
    private static final String MODEL_ACTIVITIES = "MODEL_ACTIVITIES";
    private static final String MODEL_SIMULATION_MAX_INSTANCES = "MODEL_SIMULATION_MAX_INSTANCES";
    static final String SIMULATION_DEFINITION = "SIMULATION_DEFINITION";
    static final String SIMULATION_DEFINITION_ID = "SIMULATION_DEFINITION_ID";
    private static final String SIMULATION_DEFINITION_DURATION = "SIMULATION_DEFINITION_DURATION";
    private static final String SIMULATION_DEFINITION_START = "SIMULATION_DEFINITION_START";
    private static final String SIMULATION_DEFINITION_INFLIGHT = "SIMULATION_DEFINITION_INFLIGHT";
    public static final String ACTION_OPEN_MODEL = "ACTION_OPEN_MODEL";
    public static final String ACTION_OPEN_DEFINITION = "ACTION_OPEN_DEFINITION";
    public static final String ACTION_RUN_SIMULATION = "ACTION_RUN_SIMULATION";

    public NewSimulationWizard(Process process) {
        this.process = process;
        this.getSteps().add(new SimulationDefinitionStep(this, process));
        this.getSteps().add(new ActionsStep(this));
        this.setIcon(Image.create((Msg)DesignerMsg.PROCESS_BIG));
    }

    protected WizardStep getInitialStep() {
        return new SimulationModelStep(this, this.process);
    }

    private boolean createSimulation() {
        boolean success = true;
        try {
            ProjectSimulationBuilder.SimulationDefinitionData simulationDefinitionData = this.getSimulationDefinitionData();
            ProjectSimulationBuilder.SimulationModelData simulationModelData = this.getSimulationModelData();
            ProjectSimulation simulation = ProjectSimulationBuilder.createSimulationAndDefinition((Process)this.process, (ProjectSimulationBuilder.SimulationDefinitionData)simulationDefinitionData, (ProjectSimulationBuilder.SimulationModelData)simulationModelData);
            ModelSimulation modelSimulation = simulation.findModelSimulation(simulationModelData.getId());
            this.putProperty(SIMULATION_DEFINITION, simulation);
            this.putProperty(MODEL_SIMULATION, modelSimulation);
        }
        catch (ProjectException e) {
            success = false;
            MessageDialog.showError((Throwable)e);
        }
        return success;
    }

    private ProjectSimulationBuilder.SimulationModelData getSimulationModelData() {
        String modelSimulationId = (String)this.getProperty(MODEL_SIMULATION_ID);
        Boolean useMaxInstancesValue = (Boolean)this.getProperty(MODEL_SIMULATION_USE_MAX_INSTANCES);
        Integer maxCount = (Integer)this.getProperty(MODEL_SIMULATION_MAX_INSTANCES);
        List activities = (List)this.getProperty(MODEL_ACTIVITIES);
        return new ProjectSimulationBuilder.SimulationModelData(modelSimulationId, useMaxInstancesValue, maxCount, activities);
    }

    private ProjectSimulationBuilder.SimulationDefinitionData getSimulationDefinitionData() throws ProjectException {
        String simulationDefinitionId = (String)this.getProperty(SIMULATION_DEFINITION_ID);
        Interval duration = (Interval)this.getProperty(SIMULATION_DEFINITION_DURATION);
        Time startTime = (Time)this.getProperty(SIMULATION_DEFINITION_START);
        Boolean letInflightValue = (Boolean)this.getProperty(SIMULATION_DEFINITION_INFLIGHT);
        return new ProjectSimulationBuilder.SimulationDefinitionData(simulationDefinitionId, duration, startTime, letInflightValue);
    }

    private static class SimulationModelStep
    extends WizardStep {
        private ArrayList<ProjectSimulationBuilder.ActivityInfo> activityData;
        private Integer maxCount;
        private Process model;
        private String name;
        private Project project;
        private boolean useMaxInstancesValue;

        protected SimulationModelStep(Wizard owner, Process model) {
            super(owner);
            this.model = model;
            this.project = model.getProject();
        }

        public boolean doProcess() {
            this.getWizard().putProperty(NewSimulationWizard.MODEL_SIMULATION_ID, (Object)this.name);
            this.getWizard().putProperty(NewSimulationWizard.MODEL_SIMULATION_USE_MAX_INSTANCES, (Object)this.useMaxInstancesValue);
            this.getWizard().putProperty(NewSimulationWizard.MODEL_SIMULATION_MAX_INSTANCES, (Object)this.maxCount);
            this.getWizard().putProperty(NewSimulationWizard.MODEL_ACTIVITIES, this.activityData);
            return true;
        }

        public void undoProcess() {
        }

        protected WizardStepPanel getPanelFor(UiContainer parent) {
            WizardStepPanel result = new WizardStepPanel(parent, this){
                public CheckBox useMaxInstances;
                public NumericField<Integer> maxInstancesSpinner;
                NewModelSimulationAction.SimulationComponentBuilder builder;

                public boolean validateInput() {
                    boolean result;
                    String value = this.builder.getSimulationModelName();
                    SimulationModelStep.this.model = this.builder.getSelectedProcess();
                    SimulationModelNameInputValidator validator = new SimulationModelNameInputValidator(SimulationModelStep.this.model);
                    try {
                        validator.validate(value);
                        result = true;
                        SimulationModelStep.this.name = value;
                        SimulationModelStep.this.maxCount = (Integer)this.maxInstancesSpinner.getValue();
                        SimulationModelStep.this.useMaxInstancesValue = this.useMaxInstances.isSelected();
                    }
                    catch (InputValidationException ive) {
                        Msg error = ive.getKey();
                        MessageDialog.showError((Msg)error);
                        result = false;
                    }
                    return result;
                }

                protected UiComponent createCenterPage(UiContainer parent) {
                    this.builder = new NewModelSimulationAction.SimulationComponentBuilder(SimulationModelStep.this.project);
                    this.builder.build(parent);
                    FormLayout form = new FormLayout("10dlu,pref,5dlu,pref:grow,10dlu", "10dlu,pref,5dlu,pref,5dlu,pref,5dlu,top:150dlu,10dlu");
                    CellConstraints cc = form.createCellConstraints();
                    PanelBuilder panelBuilder = new PanelBuilder(parent, form);
                    int y = 0;
                    if (SimulationModelStep.this.model == null) {
                        ComboBox<Process> processComponent = this.builder.getProcessComponent();
                        panelBuilder.add((UiComponent)Label.create((UiContainer)parent, (Msg)DesignerMsg.MODEL_SIMULATION_NAME), cc.xy(2, y += 2));
                        panelBuilder.add(processComponent, cc.xy(4, y));
                    } else {
                        this.builder.setModel(SimulationModelStep.this.model);
                    }
                    TextField text = this.builder.getSimulationComponent();
                    panelBuilder.add((UiComponent)Label.create((UiContainer)parent, (Msg)DesignerMsg.MODEL_SIMULATION_NAME), cc.xy(2, y += 2));
                    panelBuilder.add((UiComponent)text, cc.xy(4, y));
                    this.useMaxInstances = CheckBox.create((UiContainer)panelBuilder.getPanel(), (Msg)DesignerMsg.ENABLE_MAX_INTANCES_LIMIT);
                    this.useMaxInstances.setSelected(((Boolean)SimulationModelStep.this.getWizard().getProperty(NewSimulationWizard.MODEL_SIMULATION_USE_MAX_INSTANCES, (Object)false)).booleanValue());
                    this.useMaxInstances.addItemListener(new ItemListener(){

                        public void itemStateChanged(ItemEvent e) {
                            this.updateMaxField();
                        }
                    });
                    panelBuilder.add((UiComponent)this.useMaxInstances, cc.xyw(2, y += 2, 3));
                    this.maxInstancesSpinner = NumericField.createIntegerNumericField((UiContainer)panelBuilder.getPanel());
                    this.maxInstancesSpinner.setValue((Number)((Integer)SimulationModelStep.this.getWizard().getProperty(NewSimulationWizard.MODEL_SIMULATION_MAX_INSTANCES, (Object)100)));
                    this.maxInstancesSpinner.setRange((Number)1, (Number)1000000000);
                    this.maxInstancesSpinner.setStepSize((Number)1);
                    this.builder.getSimulationComponent().setText((String)SimulationModelStep.this.getWizard().getProperty(NewSimulationWizard.MODEL_SIMULATION_ID, (Object)this.builder.getSimulationModelName()));
                    this.updateMaxField();
                    panelBuilder.add(this.maxInstancesSpinner, cc.xy(4, y += 2));
                    y += 2;
                    Panel titlePanel = new Panel((UiContainer)panelBuilder.getPanel(), DesignerMsg.INTERACTIVE_ACTIVITIES);
                    titlePanel.setLayout((Layout)new BorderLayout());
                    titlePanel.add((UiComponent)NonScrollTextArea.createDescriptionField((UiContainer)titlePanel, (Msg)DesignerMsg.SIMULATION_WIZARD_ACTIVITY_PROPERTIES), (Object)"North");
                    titlePanel.add(SimulationModelStep.this.buildActivitiesTable(titlePanel), (Object)"Center");
                    panelBuilder.add((UiComponent)titlePanel, cc.xyw(2, y, 3));
                    return panelBuilder.getPanel();
                }

                private void updateMaxField() {
                    this.maxInstancesSpinner.setEnabled(this.useMaxInstances.isSelected());
                }
            };
            result.setPageTitle(DesignerMsg.SIMULATION_MODEL.toString());
            result.setPageDesc(DesignerMsg.BPMN_SIMULATION_MODEL_STEP_WIZARD);
            return result;
        }

        private UiComponent buildActivitiesTable(Panel titlePanel) {
            MsgList list = ProjectSimulationBuilder.ActivityInfo.list;
            this.activityData = (ArrayList)this.getWizard().getProperty(NewSimulationWizard.MODEL_ACTIVITIES);
            if (this.activityData == null) {
                this.activityData = new ArrayList();
                Sequence sequence = this.model.getActivities(UserTask.class);
                for (UserTask userTask : sequence) {
                    this.activityData.add(new ProjectSimulationBuilder.ActivityInfo(userTask));
                }
            }
            ProviderTableModel<ProjectSimulationBuilder.ActivityInfo> tableModel = new ProviderTableModel<ProjectSimulationBuilder.ActivityInfo>(list, this.activityData){

                public Object getValueAt(int row, int column) {
                    ProjectSimulationBuilder.ActivityInfo info = (ProjectSimulationBuilder.ActivityInfo)this.getData().get(row);
                    return info.get(column);
                }

                public void setValueAt(Object value, int row, int column) {
                    ProjectSimulationBuilder.ActivityInfo info = (ProjectSimulationBuilder.ActivityInfo)this.getData().get(row);
                    info.set(column, value);
                }

                public boolean isCellEditable(int row, int column) {
                    return column != 0;
                }
            };
            Table result = new Table((UiContainer)titlePanel, (TableModel)tableModel);
            result.setDefaultEditor(Interval.class, (TableCellEditor)new IntervalEditor());
            result.setDefaultEditor(Double.class, (TableCellEditor)NumericFieldCellEditor.createDoubleCellEditor());
            result.setDefaultEditor(Integer.class, (TableCellEditor)new IntegerFieldCellEditor());
            return result;
        }

        private static class IntervalEditor
        extends AbstractCellEditor
        implements TableCellEditor {
            private IntervalField intervalField;

            private IntervalEditor() {
            }

            public Object getCellEditorValue() {
                return this.intervalField.getInterval();
            }

            public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
                return this.createEditor((UiContainer)parent, value);
            }

            public UiComponent createEditor(UiContainer parent, Object value) {
                this.intervalField = IntervalField.createPositiveIntervalField((UiContainer)parent, (IntervalUnit)IntervalUnit.DAYS, (IntervalUnit)IntervalUnit.SECONDS);
                this.intervalField.setInterval((Interval)value);
                return this.intervalField;
            }
        }

        private static class IntegerFieldCellEditor
        extends NumericFieldCellEditor {
            private IntegerFieldCellEditor() {
            }

            protected NumericField<Integer> createNumericField(UiContainer parent) {
                NumericField numericField = NumericField.createIntegerNumericField((UiContainer)parent, (boolean)true);
                numericField.setMinimum((Number)1);
                return numericField;
            }
        }
    }

    private static class SimulationDefinitionStep
    extends WizardStep {
        private IntervalField durationField;
        private CheckBox letInflightFinish;
        private Process process;
        private TimeField startTimeField;
        private TextField text;

        protected SimulationDefinitionStep(Wizard owner, Process process) {
            super(owner);
            this.process = process;
        }

        public boolean doProcess() {
            this.savePageProperties();
            return true;
        }

        public void undoProcess() {
            this.savePageProperties();
        }

        protected WizardStepPanel getPanelFor(UiContainer parent) {
            WizardStepPanel result = new WizardStepPanel(parent, this){

                public boolean validateInput() {
                    boolean result;
                    SimulationNameInputValidator validator = new SimulationNameInputValidator(SimulationDefinitionStep.this.process.getProject());
                    try {
                        validator.validate(SimulationDefinitionStep.this.text.getText());
                        result = true;
                    }
                    catch (InputValidationException ive) {
                        Msg error = ive.getKey();
                        MessageDialog.showError((Msg)error);
                        result = false;
                    }
                    return result;
                }

                protected UiComponent createCenterPage(UiContainer parent) {
                    Panel result = new Panel(parent);
                    String baseId = ProjectModelMsg.PROJECT_SIMULATION.getString();
                    String suggestedName = ModelUtils.nextNameForProjectSimulation((Project)SimulationDefinitionStep.this.process.getProject(), (String)baseId);
                    FormLayout form = new FormLayout("10dlu,pref,5dlu,pref:grow,10dlu", "10dlu,pref,5dlu,pref,5dlu,pref,5dlu,pref,10dlu");
                    result.setLayout((Layout)form);
                    CellConstraints cc = form.createCellConstraints();
                    SimulationDefinitionStep.this.text = new TextField((UiContainer)result, (String)SimulationDefinitionStep.this.getWizard().getProperty(NewSimulationWizard.SIMULATION_DEFINITION_ID, (Object)suggestedName));
                    result.add((UiComponent)Label.create((UiContainer)parent, (Msg)ProjectModelMsg.PROJECT_SIMULATION), (Object)cc.xy(2, 2));
                    result.add((UiComponent)SimulationDefinitionStep.this.text, (Object)cc.xy(4, 2));
                    SimulationDefinitionStep.this.durationField = IntervalField.createPositiveIntervalField((UiContainer)result);
                    SimulationDefinitionStep.this.durationField.setInterval((Interval)SimulationDefinitionStep.this.getWizard().getProperty(NewSimulationWizard.SIMULATION_DEFINITION_DURATION, (Object)SimulationDefaults.DURATION));
                    result.add((UiComponent)Label.create((UiContainer)result, (Msg)DesignerMsg.DURATION), (Object)cc.xy(2, 4));
                    result.add((UiComponent)SimulationDefinitionStep.this.durationField, (Object)cc.xy(4, 4));
                    SimulationDefinitionStep.this.startTimeField = new TimeField((UiContainer)result);
                    SimulationDefinitionStep.this.startTimeField.setTime((Time)SimulationDefinitionStep.this.getWizard().getProperty(NewSimulationWizard.SIMULATION_DEFINITION_START, (Object)Time.now()));
                    SimulationDefinitionStep.this.startTimeField.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            Time time = SimulationDefinitionStep.this.startTimeField.getTime();
                            if (time == null || time.getMicroSeconds() < 0L) {
                                SimulationDefinitionStep.this.startTimeField.setTime((Time)SimulationDefinitionStep.this.getWizard().getProperty(NewSimulationWizard.SIMULATION_DEFINITION_START, (Object)Time.now()));
                            }
                        }
                    });
                    result.add((UiComponent)Label.create((UiContainer)result, (Msg)DesignerMsg.START_TIME), (Object)cc.xy(2, 6));
                    result.add((UiComponent)SimulationDefinitionStep.this.startTimeField, (Object)cc.xy(4, 6));
                    SimulationDefinitionStep.this.letInflightFinish = CheckBox.create((UiContainer)result, (Msg)DesignerMsg.INFLIGHT_FINISH);
                    SimulationDefinitionStep.this.letInflightFinish.setSelected(((Boolean)SimulationDefinitionStep.this.getWizard().getProperty(NewSimulationWizard.SIMULATION_DEFINITION_INFLIGHT, (Object)false)).booleanValue());
                    result.add((UiComponent)SimulationDefinitionStep.this.letInflightFinish, (Object)cc.xyw(2, 8, 3));
                    return result;
                }
            };
            result.setPageTitle(ProjectModelMsg.PROJECT_SIMULATION.toString());
            result.setPageDesc(DesignerMsg.BPMN_SIMULATION_DEFINITION_STEP_WIZARD);
            return result;
        }

        private void savePageProperties() {
            this.getWizard().putProperty(NewSimulationWizard.SIMULATION_DEFINITION_ID, (Object)this.text.getText());
            this.getWizard().putProperty(NewSimulationWizard.SIMULATION_DEFINITION_DURATION, (Object)this.durationField.getInterval());
            this.getWizard().putProperty(NewSimulationWizard.SIMULATION_DEFINITION_START, (Object)this.startTimeField.getTime());
            this.getWizard().putProperty(NewSimulationWizard.SIMULATION_DEFINITION_INFLIGHT, (Object)this.letInflightFinish.isSelected());
        }
    }

    private static class ActionsStep
    extends WizardStep {
        public CheckBox openDefinition;
        public CheckBox openModel;
        public CheckBox runSimulation;

        protected ActionsStep(Wizard owner) {
            super(owner);
        }

        public boolean doProcess() {
            this.savePageProperties();
            return ((NewSimulationWizard)this.getWizard()).createSimulation();
        }

        public void undoProcess() {
            this.savePageProperties();
        }

        public boolean isLastStep() {
            return true;
        }

        protected WizardStepPanel getPanelFor(UiContainer parent) {
            WizardStepPanel result = new WizardStepPanel(parent, this){

                public boolean validateInput() {
                    return true;
                }

                protected UiComponent createCenterPage(UiContainer parent) {
                    Panel result = new Panel(parent);
                    FormLayout form = new FormLayout("10dlu,pref,10dlu", "10dlu,pref,5dlu,pref,5dlu,pref,10dlu");
                    CellConstraints cc = form.createCellConstraints();
                    result.setLayout((Layout)form);
                    ActionsStep.this.openModel = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.OPEN_SIMULATION_MODEL, (boolean)((Boolean)ActionsStep.this.getWizard().getProperty(NewSimulationWizard.ACTION_OPEN_MODEL, (Object)false)));
                    ActionsStep.this.openDefinition = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.OPEN_SIMULATION_DEFINITION, (boolean)((Boolean)ActionsStep.this.getWizard().getProperty(NewSimulationWizard.ACTION_OPEN_DEFINITION, (Object)false)));
                    ActionsStep.this.runSimulation = CheckBox.create((UiContainer)parent, (Msg)DesignerMsg.RUN_SIMULATION, (boolean)((Boolean)ActionsStep.this.getWizard().getProperty(NewSimulationWizard.ACTION_RUN_SIMULATION, (Object)true)));
                    result.add((UiComponent)ActionsStep.this.openModel, (Object)cc.xy(2, 2));
                    result.add((UiComponent)ActionsStep.this.openDefinition, (Object)cc.xy(2, 4));
                    result.add((UiComponent)ActionsStep.this.runSimulation, (Object)cc.xy(2, 6));
                    return result;
                }
            };
            result.setPageTitle(ProjectModelMsg.PROJECT_SIMULATION.toString());
            result.setPageDesc(DesignerMsg.BPMN_SIMULATION_DEFINITION_STEP_WIZARD);
            return result;
        }

        private void savePageProperties() {
            this.getWizard().putProperty(NewSimulationWizard.ACTION_OPEN_MODEL, (Object)this.openModel.isSelected());
            this.getWizard().putProperty(NewSimulationWizard.ACTION_OPEN_DEFINITION, (Object)this.openDefinition.isSelected());
            this.getWizard().putProperty(NewSimulationWizard.ACTION_RUN_SIMULATION, (Object)this.runSimulation.isSelected());
        }
    }
}

