/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.UniformDistribution;
import oracle.bpm.designer.simulation.DistributionPanel;
import oracle.bpm.lang.Interval;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;

class UniformDistributionPanel
extends DistributionPanel {
    private UiComponent avg;
    private UiComponent sigma;

    public UniformDistributionPanel(UiContainer parent, Distribution distribution, int meanType) {
        super(parent, distribution);
        if (meanType == 0) {
            this.beginUniformIntervalDistributionPanel();
        } else {
            this.beginUniformNumericDistributionPanel();
        }
        this.finishLayout();
    }

    @Override
    public AbstractDistribution getDistribution() {
        return this.getDistribution(0);
    }

    @Override
    public AbstractDistribution getDistribution(int meanType) {
        if (meanType == 0) {
            return this.getIntervalDistribution();
        }
        return this.getNumericDistribution();
    }

    @Override
    public void setDistribution(Distribution distribution, int meanType) {
        if (meanType == 0) {
            ((IntervalField)this.avg).setInterval(Interval.normalizedValueOf(distribution.getAvgValue()));
            ((IntervalField)this.sigma).setInterval(Interval.normalizedValueOf(distribution.getDeviation()));
        } else {
            ((NumericField)this.avg).setValue((Number)((int)distribution.getAvgValue()));
            ((NumericField)this.sigma).setValue((Number)((int)distribution.getDeviation()));
        }
    }

    private AbstractDistribution getIntervalDistribution() {
        if (((IntervalField)this.avg).getInterval() == null) {
            return UniformDistribution.create();
        }
        UniformDistribution result = (UniformDistribution)super.getDistribution();
        result.setAvg(((IntervalField)this.avg).getInterval().getTotalMicroseconds());
        result.setDeviation(((IntervalField)this.sigma).getInterval().getTotalMicroseconds());
        return result;
    }

    private AbstractDistribution getNumericDistribution() {
        NumericField numericSpinner = (NumericField)this.avg;
        if (numericSpinner.getValue().intValue() < 0) {
            return UniformDistribution.create();
        }
        UniformDistribution result = (UniformDistribution)super.getDistribution();
        result.setAvg((long)numericSpinner.getValue().intValue());
        result.setDeviation((long)((NumericField)this.sigma).getValue().intValue());
        return result;
    }

    private void beginUniformNumericDistributionPanel() {
        this.avg = UniformDistributionPanel.createNumericAvgField((UiContainer)this, this.distribution, UniformDistribution.DEFAULT_AVG);
        this.sigma = UniformDistributionPanel.createNumericDeviationField((UiContainer)this, this.distribution, UniformDistribution.DEFAULT_SIGMA);
    }

    private void beginUniformIntervalDistributionPanel() {
        this.avg = UniformDistributionPanel.createIntervalAvgField((UiContainer)this, this.distribution);
        this.sigma = UniformDistributionPanel.createIntervalDeviationField((UiContainer)this, this.distribution);
    }

    private void finishLayout() {
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectMsg.MEAN), "avgIntervalLabel");
        this.add(this.avg, "avg");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)ProjectMsg.DELTA), "sigmaIntervalLabel");
        this.add(this.sigma, "sigma");
        layout.addConstraint("avgIntervalLabel", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("avg", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("avgIntervalLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("avg", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("avg", AttributeType.LEFT, (Constraint)new AttributeConstraint("avgIntervalLabel", AttributeType.RIGHT, 5));
        layout.addConstraint("sigmaIntervalLabel", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("sigma", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("sigmaIntervalLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("sigma", AttributeType.TOP, (Constraint)new AttributeConstraint("avg", AttributeType.BOTTOM, 2));
        layout.addConstraint("sigma", AttributeType.LEFT, (Constraint)new AttributeConstraint("avg", AttributeType.LEFT));
        layout.addConstraint("sigma", AttributeType.RIGHT, (Constraint)new AttributeConstraint("avg", AttributeType.RIGHT));
    }
}

