/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.SimulationUtils;
import java.util.List;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.lang.Interval;
import oracle.bpm.lib.XPathExpression;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BoundaryEvent;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TimerEventDefinition;
import oracle.bpm.project.model.processes.TimerEventType;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.SimulationSequenceFlow;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.TableObjectModel;
import oracle.bpm.ui.table.editors.BooleanCheckBoxCellEditor;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.IntervalField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TimersIntervalEditorTablePanel
extends Panel {
    private Activity activity;
    private boolean interrupting;
    private ModelSimulation modelSimulation;
    private Table timersTable;
    private TimersIntervalTableModel timersTableModel;
    private static int REDEFINE_COLUMN = 0;
    private static int TIMER_ID_COLUMN = 1;
    private static int INTERVAL_COLUMN = 2;

    public TimersIntervalEditorTablePanel(@NotNull UiContainer parent, @NotNull ModelSimulation modelSim, @NotNull Activity activity, boolean interrupting) {
        super(parent);
        this.activity = activity;
        this.modelSimulation = modelSim;
        this.interrupting = interrupting;
    }

    public void check() throws DesignerException {
    }

    public void modelToPanel() {
        List boundaryEventList = SimulationUtils.getValidBoundaryTimerEvents((Activity)this.activity, (boolean)this.interrupting);
        for (BoundaryEvent be : boundaryEventList) {
            Interval interval;
            SimulationTimerBoundaryEvent timerBoundary = new SimulationTimerBoundaryEvent(be);
            SequenceFlow beSeqFlow = timerBoundary.getUniqueSequenceFlow();
            SimulationSequenceFlow simulationSequenceFlow = beSeqFlow != null ? this.modelSimulation.findSimulationSequenceFlow(beSeqFlow.getId()) : null;
            boolean isRedefined = false;
            if (simulationSequenceFlow != null) {
                isRedefined = simulationSequenceFlow.usesInterval();
                interval = simulationSequenceFlow.getDueInterval();
            } else if (!timerBoundary.isExpression()) {
                interval = timerBoundary.getInterval();
            } else {
                isRedefined = true;
                interval = Interval.ONE_HOUR;
            }
            this.timersTableModel.addRow(be, new Object[]{isRedefined, timerBoundary, interval});
        }
        this.initProcessTableSelection();
    }

    public void panelToModel() {
        for (int r = 0; r < this.timersTableModel.getRowCount(); ++r) {
            boolean redefined = (Boolean)this.timersTableModel.getValueAt(r, 0);
            SimulationTimerBoundaryEvent be = (SimulationTimerBoundaryEvent)this.timersTableModel.getValueAt(r, 1);
            Interval interval = (Interval)this.timersTableModel.getValueAt(r, 2);
            SequenceFlow seqFlow = be.getUniqueSequenceFlow();
            SimulationSequenceFlow t = this.modelSimulation.asSimulationSequenceFlow(seqFlow);
            String id = seqFlow.getId();
            if (!t.getId().equals(id)) {
                t.setId(id);
            }
            if (t.usesInterval() != redefined) {
                t.setUsesInterval(redefined);
            }
            if (t.getDueInterval() == null || !t.getDueInterval().equals(interval)) {
                t.setDueInterval(interval);
            }
            String relatedBoundaryId = be.getTimerBoundaryEvent().getId();
            if (t.getRelatedBoundaryId() != null && t.getRelatedBoundaryId().equals(relatedBoundaryId)) continue;
            t.setRelatedBoundaryId(relatedBoundaryId);
        }
    }

    public void init() {
        this.setLayout((Layout)new BorderLayout());
        Panel processesTablePanel = this.buildProcessSelectionPanel((UiContainer)this);
        this.modelToPanel();
        this.add((UiComponent)processesTablePanel, "Center");
    }

    private Panel buildProcessSelectionPanel(@NotNull UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new BorderLayout());
        this.timersTableModel = new TimersIntervalTableModel(Msg.QUOTE("Redefine?"), Msg.QUOTE("Timer Boundary Name"), Msg.QUOTE("Interval"));
        this.timersTable = new Table((UiContainer)panel, (TableModel)this.timersTableModel, ListSelectionMode.SINGLE_SELECTION);
        this.timersTable.setRelativeSizes(new double[]{0.15, 0.35, 0.5});
        this.timersTable.setShowHorizontalLines(true);
        this.timersTable.setShowVerticalLines(true);
        this.timersTable.setPreferredRows(5);
        this.timersTable.getColumn(REDEFINE_COLUMN).setCellEditor((TableCellEditor)new RedefineBooleanEditor());
        this.timersTable.getColumn(INTERVAL_COLUMN).setCellEditor((TableCellEditor)new IntervalEditor());
        panel.add((UiComponent)this.timersTable, (Object)"Center");
        return panel;
    }

    private void initProcessTableSelection() {
        if (this.timersTable.getRowCount() > 0) {
            this.timersTable.setSelectionInterval(0, 0);
        }
    }

    private class RedefineBooleanEditor
    extends BooleanCheckBoxCellEditor {
        private SimulationTimerBoundaryEvent be;

        private RedefineBooleanEditor() {
        }

        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            this.be = (SimulationTimerBoundaryEvent)TimersIntervalEditorTablePanel.this.timersTableModel.getValueAt(row, 1);
            return this.createEditor((UiContainer)parent, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            CheckBox editor = (CheckBox)super.createEditor(parent, value);
            this.setValue(!this.be.isCycle() || this.be.isExpression() ? Boolean.valueOf(true) : value);
            editor.setEnabled(this.be.isCycle() && !this.be.isExpression());
            editor.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    RedefineBooleanEditor.this.stopCellEditing();
                }
            });
            return editor;
        }
    }

    private static class TimersIntervalTableModel
    extends TableObjectModel {
        public TimersIntervalTableModel(Msg ... columns) {
            super(columns);
        }

        public boolean isCellEditable(int row, int col) {
            return col == 0 || col == 2;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return Interval.class;
                }
            }
            return super.getColumnClass(column);
        }
    }

    private static class SimulationTimerBoundaryEvent {
        private SequenceFlow sequenceflow;
        private BoundaryEvent timerBoundaryEvent;
        private TimerEventDefinition timerEventDefinition;

        public SimulationTimerBoundaryEvent(BoundaryEvent be) {
            this.timerBoundaryEvent = be;
            this.timerEventDefinition = (TimerEventDefinition)be.getEventDefinition().as(TimerEventDefinition.class);
            this.sequenceflow = (SequenceFlow)CollectionUtils.first(be.getOutgoingSequenceFlows());
        }

        public BoundaryEvent getTimerBoundaryEvent() {
            return this.timerBoundaryEvent;
        }

        public SequenceFlow getUniqueSequenceFlow() {
            return this.sequenceflow;
        }

        public boolean isCycle() {
            return this.timerEventDefinition.getType() == TimerEventType.TIME_CYCLE;
        }

        public boolean isExpression() {
            return this.timerEventDefinition.isExpresion();
        }

        @Nullable
        public Interval getInterval() {
            return this.isCycle() ? Interval.valueOf(XPathExpression.fromXPathLiteral(this.timerEventDefinition.getTimeCycleExpression().getExpressionValue())) : null;
        }

        public String getId() {
            return this.timerBoundaryEvent.getId();
        }

        public String toString() {
            return this.timerBoundaryEvent.getDefaultLabel();
        }
    }

    private static class IntervalEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private IntervalField intervalField;

        private IntervalEditor() {
        }

        public Object getCellEditorValue() {
            return this.intervalField.getInterval();
        }

        public UiComponent getTableCellEditor(Table parent, Object value, boolean isSelected, int row, int column) {
            return this.createEditor((UiContainer)parent, value);
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.intervalField = new IntervalField(parent);
            this.intervalField.setInterval((Interval)value);
            this.intervalField.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    IntervalEditor.this.stopCellEditing();
                }
            });
            return this.intervalField;
        }
    }
}

