/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.ModelSimulationChecker;
import fuego.simulation.Simulation;
import fuego.simulation.StudioSimulationUtils;
import java.util.Collection;
import oracle.bpm.bam.chartviewer.ChartManager;
import oracle.bpm.bam.chartviewer.ChartViewerUtils;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationAction;
import oracle.bpm.designer.simulation.SimulationControlPanel;
import oracle.bpm.designer.simulation.SimulationRunnerAction;
import oracle.bpm.lang.Any;
import oracle.bpm.project.compile.CheckOptions;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.compile.process.SimulationChecker;
import oracle.bpm.project.importer.CancelActionException;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;

class StartSimulationAction
extends SimulationAction {
    public StartSimulationAction(SimulationControlPanel panel) {
        super(DesignerMsg.START_SIMULATION, panel);
    }

    @Override
    public boolean doIt() {
        boolean isPaused;
        boolean simulating = AbstractStudioWorkbench.getInstance().isSimulating();
        Simulation simulation = this.getPanel().getSimulation();
        boolean bl = isPaused = simulation != null && simulation.isSimulationPaused();
        if (simulating && !isPaused) {
            MessageDialog.showError((Msg)DesignerMsg.SIMULATION_ALREADY_RUNNING);
            return false;
        }
        if (isPaused) {
            this.getPanel().enableButtons(SimulationRunnerAction.START);
            simulation.resume();
        } else {
            try {
                this.getPanel().simulationStarted();
                this.start();
            }
            catch (CancelActionException exc) {
                return false;
            }
        }
        return true;
    }

    private boolean checkProjectResources(ProjectSimulation simulation) {
        return false;
    }

    private void checkResources(SimulationControlPanel panel) throws CancelActionException {
        ChartManager chartManager;
        if (this.checkProjectResources(panel.getSelectedProjectSimulation()) && !ChartViewerUtils.areResourcesDefined((ChartManager)(chartManager = panel.getChartViewer().getChartManager()))) {
            MessageDialog.showError((Msg)DesignerMsg.NO_RESOURCES);
            throw new CancelActionException();
        }
    }

    private void enableAnimation(Simulation simulation, SimulationControlPanel panel) {
        if (simulation.getProjectSimulation() != null) {
            String[] processes;
            for (String process : processes = simulation.getProcesses()) {
                Process content = panel.getProjectSimulationModel().getProject().findProcess(process);
                ProcessDomain domain = Context.getDomainFor(content);
                if (content == null || domain == null) continue;
                StudioSimulationUtils.addRunningSimulation((Process)content, (Simulation)simulation);
                domain.setShowAnimation(true);
            }
        } else {
            Process process = panel.getProcessPanel().getModel();
            StudioSimulationUtils.addRunningSimulation((Process)process, (Simulation)simulation);
            panel.getProcessPanel().getProcessDomain().setShowAnimation(true);
        }
    }

    private void start() throws CancelActionException {
        SimulationControlPanel panel = this.getPanel();
        panel.reloadProjectSimulation();
        this.check();
        if (!panel.changeProcess()) {
            throw new CancelActionException();
        }
        ProjectSimulation selectedSimulationModel = panel.getSelectedProjectSimulation();
        Simulation simulation = panel.createProjectSimulation(selectedSimulationModel);
        if (simulation == null) {
            throw new CancelActionException();
        }
        this.checkResources(panel);
        this.enableAnimation(simulation, panel);
        panel.clearLog();
        simulation.setPerformingAnimation(true);
        panel.enableButtons(SimulationRunnerAction.START);
        Thread thread = new Thread((Runnable)simulation, "Simulation");
        thread.setPriority(1);
        thread.start();
        AbstractStudioWorkbench.getInstance().setSimulation(simulation);
    }

    private void check() {
        ProjectSimulation projectSimulationModel = this.getPanel().getProjectSimulationModel();
        if (projectSimulationModel != null) {
            SimulationChecker simChecker = new SimulationChecker(projectSimulationModel, new ProjectMessageListener(){

                public void reportError(ProjectObject object, ProjectException exception) {
                    MessageDialog.showError((Msg)DesignerMsg.CHECK_FAILED, (Msg)exception.getMsg());
                    throw new CancelActionException();
                }

                public void reportWarning(ProjectObject object, ProjectException exception) {
                }
            });
            simChecker.check();
            Collection simulationModels = projectSimulationModel.getModelSimulations();
            if (simulationModels != null) {
                CheckOptions checkOptions = new CheckOptions(3);
                for (ModelSimulation modelSimulation : simulationModels) {
                    ProcessChecker checker = new ProcessChecker(modelSimulation.getProcess(), checkOptions);
                    final Any.Holder firstError = new Any.Holder();
                    ProjectMessageListener errorListener = new ProjectMessageListener(){

                        public void reportError(ProjectObject object, ProjectException exception) {
                            firstError.value = exception;
                        }

                        public void reportWarning(ProjectObject object, ProjectException exception) {
                        }
                    };
                    try {
                        checker.setListener(errorListener);
                        checker.check();
                        if (firstError.value == null) {
                            ModelSimulationChecker modelSimulationChecker = new ModelSimulationChecker();
                            modelSimulationChecker.setListener(errorListener);
                            modelSimulationChecker.check(modelSimulation);
                        }
                    }
                    catch (ProjectException e) {
                        firstError.value = e;
                    }
                    if (firstError.value == null) continue;
                    MessageDialog.showError((Msg)DesignerMsg.CHECK_FAILED, (Msg)((ProjectException)((Object)firstError.value)).getMsg());
                    throw new CancelActionException();
                }
            }
        }
    }
}

