/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.util.Identifier;

public class SimulationNameInputValidator
implements InputValidator {
    private Project project;
    private static final int IDENTIFIER_MAX_LENGTH = 128;

    public SimulationNameInputValidator(Project project) {
        this.project = project;
    }

    @Override
    public void validate(String name) throws InputValidationException {
        InputValidationException.assertTrue(Identifier.isValid(name) && name.indexOf(95) == -1, DesignerMsg.INVALID_SIMULATION_IDENTIFIER);
        InputValidationException.assertTrue(name.trim().length() <= 128, DesignerMsg.IDENTIFIER_TOO_LONG(128));
        InputValidationException.assertTrue(this.project.getSimulations().findProjectSimulation(name) == null, DesignerMsg.PROJECT_SIMULATION_EXISTS);
    }
}

