/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationModelNameInputValidator;
import oracle.bpm.designer.simulation.SimulationNameInputValidator;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiWindow;
import org.jetbrains.annotations.NotNull;

public class SimulationDialogFactory {
    public static String showSimulationNameDialog(@NotNull Project project) {
        return SimulationDialogFactory.showSimulationNameDialog(project, ModelUtils.nextNameForProjectSimulation((Project)project, (String)ProjectModelMsg.PROJECT_SIMULATION.getString()));
    }

    public static String showSimulationNameDialog(@NotNull Project project, String suggestedName) {
        return MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)ProjectUiMsg.CREATE((Msg)ProjectModelMsg.PROJECT_SIMULATION), (Msg)ProjectModelMsg.PROJECT_SIMULATION, (String)suggestedName, (InputValidator)new SimulationNameInputValidator(project), (boolean)false);
    }

    public static String showCopySimulationDialog(@NotNull Project project, String suggestedName) {
        return MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)ProjectUiMsg.COPY((Msg)ProjectModelMsg.PROJECT_SIMULATION), (Msg)ProjectModelMsg.PROJECT_SIMULATION, (String)suggestedName, (InputValidator)new SimulationNameInputValidator(project), (boolean)false);
    }

    public static String showCopyModelSimulationDialog(@NotNull Process process, String suggestedName) {
        return MessageDialog.showInput((UiWindow)Ui.getRoot(), (Msg)ProjectUiMsg.COPY((Msg)DesignerMsg.SIMULATION_MODEL), (Msg)DesignerMsg.MODEL_SIMULATION_NAME, (String)suggestedName, (InputValidator)new SimulationModelNameInputValidator(process), (boolean)false);
    }
}

