/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.Event;
import fuego.simulation.ProjectSimulationRunner;
import fuego.simulation.Simulation;
import fuego.simulation.SimulationEventListener;
import fuego.simulation.StudioSimulationUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import oracle.bpm.bam.chartviewer.ChartViewer;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ProcessPanel;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.GenerateReportAction;
import oracle.bpm.designer.simulation.PauseSimulationAction;
import oracle.bpm.designer.simulation.RunToEndSimulationAction;
import oracle.bpm.designer.simulation.SimulationRunnerAction;
import oracle.bpm.designer.simulation.StartSimulationAction;
import oracle.bpm.designer.simulation.StopSimulationAction;
import oracle.bpm.designer.simulation.wizard.NewSimulationWizardAction;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryChangeEvent;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.RepositoryServiceListener;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.events.RepositoryListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Box;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.ToolBarItem;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextArea;

public class SimulationControlPanel
extends Panel
implements SimulationEventListener {
    private ComboBox<ProjectSimulation> activeSimulation;
    private ChartViewer chartViewer;
    private boolean endSimulation;
    private long lastTime;
    private TextArea log;
    private volatile StringBuffer logBuffer = new StringBuffer();
    private volatile int logLines = 0;
    private PauseSimulationAction pauseAction;
    private ProcessPanel processPanel;
    private ProjectSimulation projectSimulation;
    private GenerateReportAction reportAction;
    private RepositoryListener repositoryListener;
    private RepositoryServiceListener repositoryServiceListener;
    private RunToEndSimulationAction runToTheEndAction;
    private Simulation simulation;
    private SimulationsProjectListener simulationsProjectListener;
    private ComboBox<SpeedItem> speedCombo;
    private StartSimulationAction startAction;
    private ToolBarItem startItem;
    private StopSimulationAction stopAction;
    private TabbedPane tabbedPane;
    private ToolBar toolbar;
    private static final int CHART_REPAINT_INTERVAL = 1500;
    private static final int SIMULATION_THREAD_SLEEP = 50;

    public SimulationControlPanel(UiContainer parent, ToolBar toolbar) {
        super(parent);
        this.toolbar = toolbar;
        this.setOpaque(false);
        this.setLayout((Layout)new BorderLayout());
        this.buildPanels();
        this.refreshSimulations(RepositoryService.getInstance().getActiveRepository());
        RepositoryService.getInstance().addObserver(this.getRepositoryServiceListener());
        ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
        if (repository != null) {
            repository.addRepositoryListener(this.getRepositoryListener());
        }
    }

    public Simulation getSimulation() {
        return this.simulation;
    }

    public boolean changeProcess() {
        if (!this.hasSimulationsToRun()) {
            MessageDialog.showError((UiContainer)Ui.getRoot(), (Msg)DesignerMsg.SIMULATION_HAS_NO_MODELS);
            if (this.projectSimulation != null) {
                new OpenObjectAction(this.projectSimulation).doIt();
            }
            return false;
        }
        Collection modelSimulations = this.getSelectedProjectSimulation().getModelSimulations();
        int i = 0;
        if (modelSimulations != null) {
            for (ModelSimulation modelSimulation : modelSimulations) {
                Process fuegoProcess = modelSimulation.getProcess();
                assert (fuegoProcess != null);
                StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
                StudioEditor editor = workbench.openEditorForObject(fuegoProcess);
                if (i == modelSimulations.size() - 1) {
                    this.setProcessPanel((ProcessPanel)editor);
                    this.refreshToolBarActions();
                    this.chartViewer.refresh();
                }
                ++i;
            }
        }
        return true;
    }

    public void eventDue(List<Event> eventList) {
        for (Event event : eventList) {
            String buffer = event + "\n";
            switch (event.getType()) {
                case 2: 
                case 6: {
                    SequenceFlow t = null;
                    FlowNode from = event.getFrom();
                    FlowNode to = event.getTo();
                    if (event.getTransition() != null) {
                        t = event.getTransition();
                    } else {
                        ModelSimulation modelSimulation = event.getToken().getModel();
                        if (modelSimulation != null && from != null && to != null && modelSimulation.getProcess() != null) {
                            t = ModelUtils.findSequenceFlow((FlowNode)from, (FlowNode)to);
                        }
                    }
                    if (t == null || !event.isLastStep() && this.simulation.isPerformingAnimation() || !event.canBeLogged()) break;
                    this.addMessage(buffer);
                    break;
                }
                case 3: {
                    this.addMessage(buffer);
                    break;
                }
                case 4: {
                    this.lastTime = 0L;
                    this.addMessage(buffer);
                    break;
                }
                case 1: {
                    this.addMessage(buffer);
                    break;
                }
                case 5: {
                    this.addMessage(buffer);
                    this.lastTime = 0L;
                    this.stopAction.doIt();
                    return;
                }
            }
        }
        if (this.simulation.isPerformingAnimation()) {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!(SimulationControlPanel.this.endSimulation || SimulationControlPanel.this.lastTime != 0L && System.currentTimeMillis() - SimulationControlPanel.this.lastTime < 1500L)) {
                        SimulationControlPanel.this.redraw();
                        SimulationControlPanel.this.lastTime = System.currentTimeMillis();
                    }
                }
            });
            try {
                double timeScalePct = this.simulation.getTimeScalePct();
                int sleepTime = 50 - (int)(48.0 * timeScalePct / 100.0);
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public ProjectSimulation getProjectSimulationModel() {
        return this.projectSimulation;
    }

    public void setProjectSimulationModel(ProjectSimulation model) {
        this.projectSimulation = model;
        this.projectSimulationChanged();
    }

    public boolean isSimulating() {
        return this.simulation != null && this.simulation.isRunning();
    }

    public void simulationStarted() {
        this.loadResources(this.projectSimulation);
        this.tabbedPane.setEnabled(true);
        this.chartViewer.simulationStarted();
        this.endSimulation = false;
    }

    public void stopSimulations() {
        if (this.isSimulating()) {
            this.endSimulation = true;
            this.stopAction.doIt();
        }
    }

    public RepositoryListener getRepositoryListener() {
        if (this.repositoryListener == null) {
            this.repositoryListener = new RepositoryListener(){

                public void projectCreated(Project project) {
                    Collection projectSimulations = project.getSimulations().getProjectSimulations();
                    SimulationControlPanel.this.activeSimulation.addItems((Iterable)projectSimulations);
                    SimulationControlPanel.this.setActionsEnabled(true);
                    project.addListener((ProjectListener)SimulationControlPanel.this.getSimulationsProjectListener());
                    SimulationControlPanel.this.repaint();
                }

                public void projectOpened(Project project) {
                }

                public void projectClosed(Project project) {
                }

                public void projectDeleted(Project project) {
                    Collection projectSimulations = project.getSimulations().getProjectSimulations();
                    boolean selected = false;
                    for (ProjectSimulation projectSimulation1 : projectSimulations) {
                        if (projectSimulation1.equals(SimulationControlPanel.this.activeSimulation.getSelectedItem())) {
                            selected = true;
                        }
                        SimulationControlPanel.this.activeSimulation.removeItem((Object)projectSimulation1);
                    }
                    project.removeListener((ProjectListener)SimulationControlPanel.this.getSimulationsProjectListener());
                    if (selected && SimulationControlPanel.this.activeSimulation.getItemCount() > 0) {
                        SimulationControlPanel.this.activeSimulation.setSelectedIndex(SimulationControlPanel.this.activeSimulation.getItemCount() - 1);
                    }
                    if (SimulationControlPanel.this.activeSimulation.getItemCount() == 0) {
                        SimulationControlPanel.this.activeSimulation.setSelectedIndex(-1);
                        SimulationControlPanel.this.setProjectSimulationModel(null);
                        SimulationControlPanel.this.setActionsEnabled(false);
                    }
                    SimulationControlPanel.this.repaint();
                }

                public void projectDisposed(Project project) {
                }

                public void preProjectClose(Project project) {
                }

                public void projectReload(Project project) {
                }
            };
        }
        return this.repositoryListener;
    }

    public SimulationsProjectListener getSimulationsProjectListener() {
        if (this.simulationsProjectListener == null) {
            this.simulationsProjectListener = new SimulationsProjectListener();
        }
        return this.simulationsProjectListener;
    }

    public void reloadProjectSimulation() {
        this.reloadProjectSimulation(this.projectSimulation);
    }

    public boolean selectSimulation(String simulationId) {
        ComboBoxModel model = this.activeSimulation.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ProjectSimulation simModel = (ProjectSimulation)model.getElementAt(i);
            if (!simulationId.equals(simModel.getId())) continue;
            this.activeSimulation.setSelectedItem((Object)simModel);
            this.startAction.doIt();
            return true;
        }
        return false;
    }

    void setAnimation(boolean b) {
        this.simulation.setPerformingAnimation(b);
    }

    ChartViewer getChartViewer() {
        return this.chartViewer;
    }

    ProcessPanel getProcessPanel() {
        return this.processPanel;
    }

    void clearLog() {
        this.log.setText("");
        this.logBuffer = new StringBuffer();
        this.logLines = 0;
    }

    Simulation createProjectSimulation(ProjectSimulation selectedSimulationModel2) {
        this.simulation = new ProjectSimulationRunner(selectedSimulationModel2);
        this.updateTimeScale();
        ProjectSimulationRunner studioProjectSimulation = (ProjectSimulationRunner)this.simulation;
        Collection modelSimulations = studioProjectSimulation.getProcessModelMap().values();
        for (ModelSimulation modelSimulation : modelSimulations) {
            StudioSimulationUtils.addRunningSimulation((Process)modelSimulation.getProcess(), (Simulation)this.simulation);
            modelSimulation.setProjectSimulation(this.getSelectedProjectSimulation());
        }
        studioProjectSimulation.syncResources();
        this.simulation.addEventListener((SimulationEventListener)this);
        this.chartViewer.setPhotoModel(studioProjectSimulation.getSimulationPhotoModel());
        this.chartViewer.refresh();
        return this.simulation;
    }

    void enableButtons(final SimulationRunnerAction action) {
        if (!UiUtilities.isEventDispatchThread()) {
            UiUtilities.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    SimulationControlPanel.this.enableFor(action);
                }
            });
        } else {
            this.enableFor(action);
        }
    }

    void redraw() {
        if (!this.endSimulation && this.processPanel != null && !this.processPanel.isDisposed()) {
            this.chartViewer.refresh();
        }
    }

    ProjectSimulation getSelectedProjectSimulation() {
        return this.projectSimulation;
    }

    void flushLogBuffer(final String msg) {
        UiUtilities.invokeAndWait((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!SimulationControlPanel.this.endSimulation) {
                    StringBuffer stringBuffer = SimulationControlPanel.this.logBuffer;
                    synchronized (stringBuffer) {
                        if (msg != null) {
                            SimulationControlPanel.this.logBuffer.append(msg);
                        }
                        SimulationControlPanel.this.log.append(SimulationControlPanel.this.logBuffer.toString());
                        SimulationControlPanel.this.logBuffer = new StringBuffer();
                    }
                }
            }
        });
    }

    private void reloadProjectSimulation(ProjectSimulation projectSimulation) {
        try {
            this.setProjectSimulationModel(StudioSimulationUtils.reload((ProjectSimulation)projectSimulation));
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
    }

    private RepositoryServiceListener getRepositoryServiceListener() {
        if (this.repositoryServiceListener == null) {
            this.repositoryServiceListener = new RepositoryServiceListener(){

                public void repositoryChanged(RepositoryChangeEvent event) {
                    ProjectRepository repository = event.getNewProjectRepository();
                    if (repository != null) {
                        repository.addRepositoryListener(SimulationControlPanel.this.getRepositoryListener());
                    }
                    SimulationControlPanel.this.refreshSimulations(repository);
                    SimulationControlPanel.this.repaint();
                }
            };
        }
        return this.repositoryServiceListener;
    }

    private void refreshSimulations(ProjectRepository newProjectRepository) {
        this.activeSimulation.removeAllItems();
        if (newProjectRepository != null) {
            Collection projects = newProjectRepository.getAllProjects();
            SimulationsProjectListener listener = this.getSimulationsProjectListener();
            for (Project project : projects) {
                SimulationsContainer simulationsContainer = project.getSimulations();
                if (simulationsContainer != null) {
                    Collection projectSimulations = simulationsContainer.getProjectSimulations();
                    this.activeSimulation.addItems((Iterable)projectSimulations);
                }
                project.addListener((ProjectListener)listener);
            }
            this.activeSimulation.setSelectedIndex(this.activeSimulation.getItemCount() - 1);
        }
        this.setActionsEnabled(this.activeSimulation.getItemCount() > 0);
    }

    private void setActionsEnabled(boolean isEnabled) {
        this.startAction.setEnabled(isEnabled);
        this.activeSimulation.setEnabled(isEnabled);
        this.runToTheEndAction.setEnabled(isEnabled);
        this.speedCombo.setEnabled(isEnabled);
        this.tabbedPane.setEnabled(isEnabled);
        this.chartViewer.setEnabled(isEnabled);
        if (!isEnabled) {
            this.reportAction.setEnabled(false);
        }
    }

    private void enableFor(SimulationRunnerAction action) {
        if (!this.endSimulation) {
            switch (action) {
                case RUN: {
                    this.startAction.setEnabled(false);
                    this.runToTheEndAction.setEnabled(false);
                    this.stopAction.setEnabled(false);
                    this.pauseAction.setEnabled(false);
                    this.reportAction.setEnabled(false);
                    break;
                }
                case START: 
                case RESUME: {
                    this.startAction.setEnabled(false);
                    this.startItem.setToolTipText(DesignerMsg.START_SIMULATION);
                    this.runToTheEndAction.setEnabled(true);
                    this.stopAction.setEnabled(true);
                    this.pauseAction.setEnabled(true);
                    this.reportAction.setEnabled(false);
                    break;
                }
                case INIT: {
                    this.startAction.setEnabled(true);
                    this.startItem.setToolTipText(DesignerMsg.START_SIMULATION);
                    this.runToTheEndAction.setEnabled(true);
                    this.stopAction.setEnabled(false);
                    this.pauseAction.setEnabled(false);
                    this.reportAction.setEnabled(false);
                    break;
                }
                case CANCEL: 
                case STOP: {
                    this.startAction.setEnabled(true);
                    this.startItem.setToolTipText(DesignerMsg.START_SIMULATION);
                    this.runToTheEndAction.setEnabled(true);
                    this.stopAction.setEnabled(false);
                    this.pauseAction.setEnabled(false);
                    this.reportAction.setEnabled(true);
                    break;
                }
                case PAUSE: {
                    this.startAction.setEnabled(true);
                    this.startItem.setToolTipText(DesignerMsg.RESUME_SIMULATION);
                    this.runToTheEndAction.setEnabled(true);
                    this.stopAction.setEnabled(true);
                    this.pauseAction.setEnabled(false);
                    this.reportAction.setEnabled(true);
                }
            }
            this.repaint();
        }
    }

    private void projectSimulationChanged() {
        this.loadResources(this.projectSimulation);
    }

    private void buildPanels() {
        this.tabbedPane = this.buildTabbedPane((UiContainer)this);
        this.buildToolBar(this.toolbar);
        this.add((UiComponent)this.tabbedPane, "Center");
        this.add((UiComponent)this.toolbar, "North");
    }

    private TabbedPane buildTabbedPane(UiContainer parent) {
        TabbedPane pane = new TabbedPane(parent);
        this.log = new TextArea((UiContainer)pane);
        this.log.setRows(12);
        this.log.setColumns(60);
        this.log.setEditable(false);
        this.chartViewer = new ChartViewer((UiContainer)pane);
        pane.addTab(DesignerMsg.CHART, (UiComponent)this.chartViewer);
        pane.addTab(LibMsg.LOG, Image.create((Msg)DesignerMsg.SIMULATION_LOG), (UiComponent)this.log);
        return pane;
    }

    private ComboBox<SpeedItem> getSpeedCombo() {
        return this.speedCombo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMessage(String msg) {
        this.trimLogLines();
        if (this.logBuffer.length() > 1024) {
            this.flushLogBuffer(msg);
        } else {
            StringBuffer stringBuffer = this.logBuffer;
            synchronized (stringBuffer) {
                this.logBuffer.append(msg);
                ++this.logLines;
            }
        }
    }

    private void trimLogLines() {
        if (this.logLines > 20000) {
            UiUtilities.invokeAndWait((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    TextArea textArea = SimulationControlPanel.this.log;
                    synchronized (textArea) {
                        SimulationControlPanel.this.log.setText(SimulationControlPanel.this.log.getText().substring(SimulationControlPanel.this.log.getTextLength() - 64536));
                        SimulationControlPanel.this.logLines = 0;
                    }
                }
            });
        }
    }

    private void setInitialActionState() {
        if (this.isSimulating()) {
            this.stopAction.setEnabled(true);
            this.pauseAction.setEnabled(true);
            this.startAction.setEnabled(false);
            this.runToTheEndAction.setEnabled(false);
            this.reportAction.setEnabled(false);
        } else {
            this.stopAction.setEnabled(false);
            this.pauseAction.setEnabled(false);
            this.startAction.setEnabled(true);
            this.runToTheEndAction.setEnabled(true);
            this.reportAction.setEnabled(false);
        }
    }

    private void setProcessPanel(ProcessPanel processPanel) {
        this.processPanel = processPanel;
    }

    private void buildToolBar(ToolBar toolbar) {
        this.activeSimulation = UiFactory.createComboBox((UiContainer)toolbar);
        this.activeSimulation.setToolTipMsg(DesignerMsg.CHOOSE_SIMULATION);
        this.activeSimulation.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent modificationEvent) {
                SimulationControlPanel.this.setProjectSimulationModel((ProjectSimulation)modificationEvent.getNewValue());
            }
        });
        this.activeSimulation.setLabelProvider((LabelProvider)new LabelProvider<ProjectSimulation>(){

            public Image getIcon(ProjectSimulation element) {
                return null;
            }

            public String getText(ProjectSimulation element) {
                return element != null ? element.getProject().getId() + " - " + element.getId() : "";
            }
        });
        toolbar.add(this.activeSimulation);
        BaseAction editSimulationAction = new BaseAction(DesignerMsg.EDIT_SIMULATION_DEFINITION){

            public void run() {
                ProjectSimulation toOpen = (ProjectSimulation)SimulationControlPanel.this.activeSimulation.getSelectedItem();
                AbstractStudioWorkbench.getInstance().openEditorForObject(toOpen);
            }
        };
        NewSimulationWizardAction newSimulationAction = new NewSimulationWizardAction(DesignerMsg.NEW_SIMULATION_DEFINITION);
        toolbar.add(editSimulationAction);
        toolbar.addSeparator();
        this.startAction = new StartSimulationAction(this);
        this.stopAction = new StopSimulationAction(this);
        this.pauseAction = new PauseSimulationAction(this);
        this.runToTheEndAction = new RunToEndSimulationAction(this, this.startAction, this.stopAction);
        this.reportAction = new GenerateReportAction(this);
        this.startItem = toolbar.add((BaseAction)this.startAction);
        toolbar.add((BaseAction)this.stopAction);
        toolbar.add((BaseAction)this.pauseAction);
        toolbar.add((BaseAction)this.runToTheEndAction);
        this.setInitialActionState();
        toolbar.addSeparator();
        this.speedCombo = UiFactory.createComboBox((UiContainer)toolbar, (boolean)false);
        this.speedCombo.addItem((Object)new SpeedItem(1, DesignerMsg.SIMULATION_SPEED_SLOWEST));
        this.speedCombo.addItem((Object)new SpeedItem(5, DesignerMsg.SIMULATION_SPEED_SLOWER));
        this.speedCombo.addItem((Object)new SpeedItem(20, DesignerMsg.SIMULATION_SPEED_NORMAL));
        this.speedCombo.addItem((Object)new SpeedItem(60, DesignerMsg.SIMULATION_SPEED_FASTER));
        this.speedCombo.addItem((Object)new SpeedItem(100, DesignerMsg.SIMULATION_SPEED_FASTEST));
        this.speedCombo.setSelectedIndex(2);
        this.speedCombo.setToolTipMsg(DesignerMsg.CHOOSE_SIMULATION_SPEED);
        this.speedCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (SimulationControlPanel.this.getSimulation() != null) {
                    SimulationControlPanel.this.getSimulation().setTimeScalePct(((SpeedItem)SimulationControlPanel.this.speedCombo.getSelectedItem()).getValue());
                }
            }
        });
        toolbar.add(this.speedCombo);
        toolbar.addSeparator();
        toolbar.add((BaseAction)this.reportAction);
        toolbar.add(Box.createGlue((UiContainer)toolbar));
    }

    private boolean hasSimulationsToRun() {
        Collection modelSimulations;
        ProjectSimulation selectedProjectSimulation = this.getSelectedProjectSimulation();
        boolean result = selectedProjectSimulation == null ? false : (modelSimulations = selectedProjectSimulation.getModelSimulations()) != null && !modelSimulations.isEmpty();
        return result;
    }

    private void loadResources(ProjectSimulation projectSimulationModel) {
        ArrayList<SimulationResource> activeResources = new ArrayList<SimulationResource>();
        if (projectSimulationModel != null) {
            for (SimulationResource resource : projectSimulationModel.getResources()) {
                if (!resource.getSelected()) continue;
                activeResources.add(resource);
            }
        }
        this.chartViewer.setResources(activeResources);
    }

    private void refreshToolBarActions() {
        this.startAction.setPanel(this);
        this.stopAction.setPanel(this);
        this.pauseAction.setPanel(this);
        this.runToTheEndAction.setPanel(this);
        this.reportAction.setPanel(this);
    }

    private void updateTimeScale() {
        this.simulation.setTimeScalePct(((SpeedItem)this.getSpeedCombo().getSelectedItem()).getValue());
    }

    private class SimulationsProjectListener
    extends ProjectListenerAdapter {
        public SimulationsProjectListener() {
            super(ProjectSimulation.class);
        }

        public Class getSupportedTypes() {
            return ProjectSimulation.class;
        }

        public void postObjectAdded(ProjectObject object, ProjectObject parent) {
            SimulationControlPanel.this.activeSimulation.addItem((Object)((ProjectSimulation)object));
            SimulationControlPanel.this.activeSimulation.setEnabled(true);
            if (SimulationControlPanel.this.activeSimulation.getItemCount() == 1) {
                SimulationControlPanel.this.activeSimulation.setSelectedItem((Object)object);
                SimulationControlPanel.this.enableButtons(SimulationRunnerAction.INIT);
            }
        }

        public void postObjectRemoved(ProjectObject object, ProjectObject parent) {
            ProjectSimulation simulation1 = (ProjectSimulation)SimulationControlPanel.this.activeSimulation.getSelectedItem();
            if (simulation1 != null && SimulationControlPanel.this.isSimulating()) {
                SimulationControlPanel.this.stopAction.doIt();
            }
            SimulationControlPanel.this.activeSimulation.removeItem((Object)object);
            if (SimulationControlPanel.this.activeSimulation.getItemCount() == 0) {
                SimulationControlPanel.this.enableButtons(SimulationRunnerAction.RUN);
                SimulationControlPanel.this.activeSimulation.setSelectedIndex(-1);
            } else {
                SimulationControlPanel.this.activeSimulation.setSelectedIndex(0);
            }
        }
    }

    private static class SpeedItem {
        private String itemText;
        private int value;

        public SpeedItem(int value, Msg msg) {
            this.value = value;
            this.itemText = msg.getString(Locale.getDefault());
        }

        public String getText() {
            return this.itemText;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.getText();
        }
    }
}

