/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.ModelSimulationImpl;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.SimulationResourceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.Organization;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.organization.Group;
import oracle.bpm.project.model.organization.GroupAssignment;
import oracle.bpm.project.model.organization.Participant;
import oracle.bpm.project.model.organization.RoleAssignment;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.project.model.util.ModelUtils;

class ResourceUtils {
    private ResourceUtils() {
    }

    public static void syncModelResources(ProjectSimulation model) {
        ArrayList<String> rolesList = new ArrayList<String>();
        Map<String, SimulationResource> orgMap = ResourceUtils.getOrgResourceList(model.getProject().getOrganization(), model, rolesList);
        Collection simCollection = model.getResources();
        ArrayList<SimulationResource> invalidEntries = new ArrayList<SimulationResource>();
        for (SimulationResource simulationResource : simCollection) {
            if (ResourceUtils.checkRoles(simulationResource, rolesList)) continue;
            invalidEntries.add(simulationResource);
        }
        for (SimulationResource simulationResource : invalidEntries) {
            simCollection.remove(simulationResource);
        }
        for (Map.Entry entry : orgMap.entrySet()) {
            String key = (String)entry.getKey();
            SimulationResource orgResource = (SimulationResource)entry.getValue();
            if (model.findResource(key) == null) {
                try {
                    model.addResource(orgResource);
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
                continue;
            }
            SimulationResource simResource = model.findResource(orgResource.getId());
            simResource.setRoles(orgResource.getRoles());
        }
    }

    private static Map<String, SimulationResource> getOrgResourceList(Organization organization, ProjectSimulation projectSimulation, List<String> rolesList) {
        HashMap<String, SimulationResource> resultMap = new HashMap<String, SimulationResource>();
        Collection modelSimulations = projectSimulation.getModelSimulations();
        if (modelSimulations != null) {
            for (ModelSimulation modelSimulation : modelSimulations) {
                ModelSimulationImpl modelSimulationImpl = (ModelSimulationImpl)modelSimulation;
                modelSimulationImpl.createInfo();
                ResourceUtils.loadResources(organization, rolesList, resultMap, (ModelSimulation)modelSimulationImpl);
            }
        }
        return resultMap;
    }

    private static void getRoles(Collection<GroupAssignment> assignedGroups, List<String> roleList) {
        if (roleList == null) {
            roleList = new ArrayList<String>();
        }
        for (GroupAssignment groupAssignment : assignedGroups) {
            Group group = groupAssignment.getGroup();
            Collection roleAssignment = group.getRoleAssignments();
            for (RoleAssignment assignment : roleAssignment) {
                roleList.add(assignment.getRole().getId());
            }
            ResourceUtils.getRoles(group.getGroupAssignments(), roleList);
        }
    }

    private static boolean checkRoles(SimulationResource resource, List<String> rolesList) {
        String[] roles;
        for (String role : roles = resource.getRoles()) {
            if (rolesList.contains(role)) continue;
            return false;
        }
        return true;
    }

    private static void loadResources(Organization organization, List<String> rolesList, Map<String, SimulationResource> resultMap, ModelSimulation simulationModel) {
        Collection activities = simulationModel.getSimulationFlowNodes();
        for (SimulationFlowNode simActivity : activities) {
            FlowNode procNode = simActivity.getFlowNode();
            if (!ModelUtils.isAnyInteractive((FlowNode)procNode) || !(simActivity instanceof SimulationFlowNodeImpl)) continue;
            LaneImpl role = (LaneImpl)procNode.getLane();
            Sequence participants = CollectionUtils.emptySequence();
            try {
                participants = organization.getParticipants();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            for (Participant participant : participants) {
                ArrayList<String> participantRoleList = new ArrayList<String>();
                Collection assignments = participant.getRoleAssignments();
                for (RoleAssignment roleAssignment : assignments) {
                    participantRoleList.add(roleAssignment.getRole().getId());
                }
                ResourceUtils.getRoles(participant.getGroupAssignments(), participantRoleList);
                if (participantRoleList.contains(role.getId())) {
                    String[] roles = participantRoleList.toArray(new String[0]);
                    SimulationResourceImpl resource = new SimulationResourceImpl(simulationModel.getProject());
                    resource.setId(participant.getId());
                    resource.setCost(participant.getCost());
                    resource.setEfficiency((double)participant.getEfficiency());
                    resource.setAvailability(100);
                    resource.setRoles(roles);
                    resultMap.put(resource.getId(), (SimulationResource)resource);
                }
                rolesList.addAll(participantRoleList);
            }
        }
    }
}

