/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import oracle.bpm.bam.chartviewer.ActivityCheckTree;
import oracle.bpm.bam.chartviewer.ActivityTreeToolBar;
import oracle.bpm.bam.chartviewer.Chart;
import oracle.bpm.bam.chartviewer.ChartInterface;
import oracle.bpm.bam.chartviewer.ChartManager;
import oracle.bpm.bam.chartviewer.ChartViewer;
import oracle.bpm.bam.chartviewer.ChartViewerUtils;
import oracle.bpm.bam.chartviewer.CheckTreePanel;
import oracle.bpm.bam.chartviewer.IndicatorSelections;
import oracle.bpm.bam.chartviewer.IndicatorsCheckTree;
import oracle.bpm.bam.chartviewer.ResourceCheckTree;
import oracle.bpm.bam.msg.BamMsg;
import oracle.bpm.bam.report.ReportGenerator;
import oracle.bpm.bamdata.Indicator;
import oracle.bpm.chart.ChartTypeLabelProvider;
import oracle.bpm.chart.resources.appearance.ColorAppearance;
import oracle.bpm.chart.shared.styles.ChartType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.project.Priority;
import oracle.bpm.project.model.simulation.SimulationResource;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.CustomLineBorder;
import oracle.bpm.ui.border.LineTitledBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.CheckSelectionChangedEvent;
import oracle.bpm.ui.event.CheckSelectionListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.CheckTree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.utils.Layout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReportPanel
extends Panel {
    private ActivitiesPage activitiesPage;
    private ButtonTuple activitiesTuple;
    private ChartManager chartManager;
    @NotNull
    private final IndicatorSelections indicatorSelections;
    private IndicatorsPage indicatorsPage;
    private ButtonTuple indicatorsTuple;
    private String name;
    private int options;
    @NotNull
    private final ChartManager originalChartManager;
    private ResourcesPage resourcesPage;
    private ButtonTuple resourcesTuple;
    private final CheckSelectionListener treeListener = new CheckSelectionListener(){

        public void checkedSelectionChanged(CheckSelectionChangedEvent event) {
            ReportPanel.this.chartManager.draw();
        }
    };
    public static final int INDICATORS = 1;
    public static final int ACTIVITIES = 2;
    public static final int RESOURCES = 8;

    public ReportPanel(UiContainer parent, ChartViewer chartViewer, String name) {
        super(parent);
        this.name = name;
        this.indicatorSelections = chartViewer.getCurrentIndicatorProvider().clone();
        this.originalChartManager = chartViewer.getChartManager();
        this.loadOptions();
        this.build();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ReportGenerator.ReportGenerationInfo getReportInfo() {
        ReportGenerator.Info activityInfo = new ReportGenerator.Info();
        ReportGenerator.Info categoryInfo = new ReportGenerator.Info();
        ReportGenerator.Info indicatorInfo = new ReportGenerator.Info();
        ReportGenerator.Info resourceInfo = new ReportGenerator.Info();
        this.buildIndicatorInfo((ReportGenerator.Info<Indicator>)indicatorInfo);
        this.buildActivityInfo((ReportGenerator.Info<String>)activityInfo);
        if (this.chartManager.isResourceView()) {
            this.buildResourceInfo((ReportGenerator.Info<SimulationResource>)resourceInfo);
        }
        categoryInfo.setData(Arrays.asList(Priority.values()));
        return new ReportGenerator.ReportGenerationInfo(this.name, this.chartManager, indicatorInfo, activityInfo, resourceInfo, categoryInfo);
    }

    public boolean getOption(int option) {
        return (this.options & option) != 0;
    }

    public IndicatorSelections getIndicatorSelections() {
        return this.indicatorSelections;
    }

    private Panel getContentPane() {
        return this;
    }

    private void build() {
        this.getContentPane().setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
        Panel containerPanel = new Panel((UiContainer)this.getContentPane());
        this.getContentPane().add((UiComponent)containerPanel, (Object)"Center");
        containerPanel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
        containerPanel.setBorder((Border)new LineTitledBorder(LibMsg.OPTIONS.getString()));
        SplitPane splitPane = new SplitPane((UiContainer)containerPanel);
        TabbedPane tabbedPane = new TabbedPane((UiContainer)splitPane);
        ChartTypePanel chartTypePanel = new ChartTypePanel((UiContainer)splitPane);
        tabbedPane.setBorder((Border)new CustomLineBorder(1));
        this.resourcesPage = new ResourcesPage((UiContainer)tabbedPane);
        this.activitiesPage = new ActivitiesPage((UiContainer)tabbedPane);
        this.indicatorsPage = new IndicatorsPage((UiContainer)tabbedPane);
        this.resourcesPage.setEnabled(true);
        this.activitiesPage.setEnabled(true);
        this.indicatorsPage.setEnabled(true);
        if (this.chartManager.isResourceView()) {
            tabbedPane.addTab(BamMsg.RESOURCES, (UiComponent)this.resourcesPage);
        }
        tabbedPane.addTab(BamMsg.ACTIVITIES, (UiComponent)this.activitiesPage);
        tabbedPane.addTab(BamMsg.INDICATORS, (UiComponent)this.indicatorsPage);
        splitPane.setLeftComponent((UiComponent)tabbedPane);
        splitPane.setRightComponent((UiComponent)chartTypePanel);
        splitPane.setResizeWeight(0.4);
        containerPanel.add((UiComponent)splitPane, (Object)"Center");
    }

    private void buildActivityInfo(@NotNull ReportGenerator.Info<String> activityInfo) {
        activityInfo.setFree(true);
        activityInfo.setType(this.activitiesPage.getDetailOption());
        ActivityCheckTree activityTree = this.activitiesPage.getTree();
        for (Map.Entry activitiesByProcess : activityTree.getSelectedActivitiesByProcess().entrySet()) {
            List activities = (List)activitiesByProcess.getValue();
            for (String activity : activities) {
                activityInfo.getData().add(activity);
            }
        }
    }

    private void loadOptions() {
        this.options |= 1;
        if (this.isFreeDimension(2) && this.isFreeDimension(3)) {
            this.options |= 2;
        }
        if (this.isFreeDimension(1)) {
            this.options |= 8;
        }
    }

    private void buildIndicatorInfo(@NotNull ReportGenerator.Info<Indicator> indicatorInfo) {
        indicatorInfo.setFree(true);
        indicatorInfo.setType(this.indicatorsPage.getDetailOption());
        IndicatorsCheckTree indicatorsTree = this.indicatorsPage.getTree();
        for (Indicator indicator : indicatorsTree.getSelectedIndicators()) {
            indicatorInfo.getData().add(indicator);
        }
    }

    private void buildResourceInfo(@NotNull ReportGenerator.Info<SimulationResource> resourceInfo) {
        if (this.chartManager.isResourceView()) {
            resourceInfo.setFree(true);
            resourceInfo.setType(this.resourcesPage.getDetailOption());
            ResourceCheckTree resourcesTree = this.resourcesPage.getTree();
            for (SimulationResource resource : resourcesTree.getSelectedResources()) {
                resourceInfo.getData().add(resource);
            }
        }
    }

    private void checkNonRepeatedDetails() {
        ButtonTuple selectedDetailsTuple = null;
        selectedDetailsTuple = this.checkNonRepeatedDetailRadioButton(selectedDetailsTuple, this.resourcesTuple);
        selectedDetailsTuple = this.checkNonRepeatedDetailRadioButton(selectedDetailsTuple, this.activitiesTuple);
        this.checkNonRepeatedDetailRadioButton(selectedDetailsTuple, this.indicatorsTuple);
    }

    @Nullable
    private ButtonTuple checkNonRepeatedDetailRadioButton(@Nullable ButtonTuple selectedDetails, @NotNull ButtonTuple tupleToBeChecked) {
        if (tupleToBeChecked.isDetails()) {
            if (selectedDetails == null) {
                selectedDetails = tupleToBeChecked;
            } else {
                MessageDialog.showError((Msg)DesignerMsg.DIMENSION_NOT_ALLOWED);
                tupleToBeChecked.setDetails(false);
            }
        }
        return selectedDetails;
    }

    private ButtonTuple createButtons(@NotNull Panel parent) {
        ButtonTuple tuple = new ButtonTuple((UiContainer)parent);
        parent.add((UiComponent)tuple.summary);
        parent.add((UiComponent)tuple.details);
        return tuple;
    }

    private boolean isFreeDimension(int dimension) {
        int xAxisDim = this.originalChartManager.getViewForAxis(0);
        int zAxisDim = this.originalChartManager.getViewForAxis(2);
        return xAxisDim != dimension && zAxisDim != dimension;
    }

    private class ResourcesPage
    extends OptionPage {
        private CheckTreePanel treePanel;

        public ResourcesPage(UiContainer parent) {
            super(parent, 8);
        }

        @Override
        protected Msg createLabel() {
            return DesignerMsg.REPORT_RESOURCES_DESC;
        }

        @Override
        protected CheckTreePanel createTreePanel(@NotNull UiContainer parent) {
            this.treePanel = ChartViewerUtils.createResourcesCheckTreePanel((UiContainer)parent, (ChartManager)ReportPanel.this.chartManager, (CheckSelectionListener)ReportPanel.this.treeListener);
            return this.treePanel;
        }

        protected ResourceCheckTree getTree() {
            return (ResourceCheckTree)this.treePanel.getTree();
        }
    }

    private class IndicatorsPage
    extends OptionPage {
        private CheckTreePanel treePanel;

        public IndicatorsPage(UiContainer parent) {
            super(parent, 1);
        }

        @Override
        protected Msg createLabel() {
            return DesignerMsg.REPORT_INDICATORS_DESC;
        }

        @Override
        protected CheckTreePanel createTreePanel(@NotNull UiContainer parent) {
            this.treePanel = ChartViewerUtils.createIndicatorsCheckTreePanel((UiContainer)parent, (IndicatorSelections)ReportPanel.this.indicatorSelections, (boolean)ReportPanel.this.chartManager.isResourceView(), (CheckSelectionListener)ReportPanel.this.treeListener);
            return this.treePanel;
        }

        protected IndicatorsCheckTree getTree() {
            return (IndicatorsCheckTree)this.treePanel.getTree();
        }
    }

    private class ChartTypePanel
    extends Panel {
        private Panel chartPanel;
        private ComboBox<ChartType> drawingTypeCombo;

        public ChartTypePanel(UiContainer parent) {
            super(parent);
            this.initComponents();
        }

        public void initComponents() {
            this.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            this.add((UiComponent)this.createTypePanel(), "Center");
        }

        protected void charTypeChanged() {
            ChartType displayingChartType = ReportPanel.this.chartManager.getChartType();
            ChartType selectedChartType = (ChartType)this.drawingTypeCombo.getSelectedItem();
            if (selectedChartType != displayingChartType) {
                ReportPanel.this.chartManager.setChartType(selectedChartType);
                ReportPanel.this.chartManager.draw();
            }
        }

        private Panel createTypePanel() {
            RelativeLayout layout = new RelativeLayout();
            Panel contentPane = new Panel((UiContainer)this);
            contentPane.setLayout((oracle.bpm.ui.layout.Layout)layout);
            this.chartPanel = this.createChartPanel(contentPane);
            this.drawingTypeCombo = UiFactory.createComboBox((UiContainer)contentPane);
            this.drawingTypeCombo.setToolTipText(BamMsg.CHOOSE_CHART_TYPE);
            this.drawingTypeCombo.setLabelProvider((LabelProvider)new ChartTypeLabelProvider(Image.create((Msg)BamMsg.CHART)));
            this.drawingTypeCombo.addItems((Iterable)ChartViewer.CHART_TYPES);
            this.drawingTypeCombo.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    ChartTypePanel.this.charTypeChanged();
                }
            });
            this.drawingTypeCombo.setSelectedIndex(0);
            contentPane.add((UiComponent)new LabelMultiline((UiContainer)contentPane, DesignerMsg.REPORT_CHART_DESC), (Object)"typeLabel");
            contentPane.add(this.drawingTypeCombo, (Object)"typeCombo");
            contentPane.add((UiComponent)this.chartPanel, (Object)"chart");
            this.layoutComponents(layout);
            return contentPane;
        }

        private void layoutComponents(RelativeLayout layout) {
            Layout.fixToRoot((RelativeLayout)layout, (String)"typeLabel", (AttributeType)AttributeType.TOP, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"typeLabel", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"typeLabel", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToComp((RelativeLayout)layout, (String)"typeCombo", (AttributeType)AttributeType.TOP, (String)"typeLabel", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"typeCombo", (AttributeType)AttributeType.LEFT, (String)"typeLabel");
            Layout.fixToComp((RelativeLayout)layout, (String)"typeCombo", (AttributeType)AttributeType.RIGHT, (String)"typeLabel");
            Layout.fixToComp((RelativeLayout)layout, (String)"chart", (AttributeType)AttributeType.TOP, (String)"typeCombo", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"chart", (AttributeType)AttributeType.LEFT, (String)"typeCombo");
            Layout.fixToComp((RelativeLayout)layout, (String)"chart", (AttributeType)AttributeType.RIGHT, (String)"typeCombo");
            Layout.fixToRoot((RelativeLayout)layout, (String)"chart", (AttributeType)AttributeType.BOTTOM, (int)-5);
        }

        private Panel createChartPanel(Panel contentPane) {
            Panel chartVisualizationPanel = new Panel((UiContainer)contentPane);
            chartVisualizationPanel.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            ScrollPane scrollPane = new ScrollPane((UiContainer)chartVisualizationPanel);
            Chart chart = new Chart((UiContainer)scrollPane);
            chart.setColorAppearance((ColorAppearance)new ChartViewer.DefaultColorAppearance());
            chart.setVisible(true);
            ReportPanel.this.chartManager = ChartManager.createForSimulation((ChartInterface)chart);
            scrollPane.setView((UiComponent)chart);
            ReportPanel.this.chartManager.setIndicatorProvider(ReportPanel.this.indicatorSelections);
            ReportPanel.this.chartManager.initAxes();
            ReportPanel.this.chartManager.setUpAxesFrom(ReportPanel.this.originalChartManager);
            ReportPanel.this.chartManager.initResourcesFrom(ReportPanel.this.originalChartManager);
            ReportPanel.this.chartManager.initSelections(ReportPanel.this.originalChartManager.getDataModel());
            ReportPanel.this.chartManager.setUpSelectionsFrom(ReportPanel.this.originalChartManager);
            ReportPanel.this.chartManager.draw();
            chartVisualizationPanel.add((UiComponent)scrollPane, (Object)"Center");
            return chartVisualizationPanel;
        }
    }

    private class ActivitiesPage
    extends OptionPage {
        private ActivityTreeToolBar toolbar;
        private CheckTreePanel treePanel;

        public ActivitiesPage(UiContainer parent) {
            super(parent, 2);
        }

        @Override
        protected Msg createLabel() {
            return DesignerMsg.REPORT_ACTIVITIES_DESC;
        }

        @Override
        protected CheckTreePanel createTreePanel(@NotNull UiContainer parent) {
            this.treePanel = ChartViewerUtils.createActivityCheckTreePanel((UiContainer)parent, (ChartManager)ReportPanel.this.chartManager, (CheckSelectionListener)ReportPanel.this.treeListener);
            if (this.toolbar != null) {
                this.toolbar.setTree(this.getTree());
            }
            return this.treePanel;
        }

        protected ActivityCheckTree getTree() {
            return (ActivityCheckTree)this.treePanel.getTree();
        }

        @Override
        protected Panel getToolbar(Panel contentPane) {
            this.toolbar = new ActivityTreeToolBar((UiContainer)contentPane);
            if (this.treePanel != null) {
                this.toolbar.setTree(this.getTree());
            }
            return this.toolbar;
        }
    }

    private abstract class OptionPage
    extends Panel {
        private UiComponent mainPanel;
        private Panel optionsPanel;
        private final int type;

        protected OptionPage(UiContainer parent, int type) {
            super(parent);
            this.type = type;
            this.initComponents();
        }

        public UiComponent getMainPanel(Panel parent) {
            if (this.mainPanel == null) {
                this.mainPanel = this.createTreePanel((UiContainer)parent);
            }
            return this.mainPanel;
        }

        public void initComponents() {
            this.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            this.add((UiComponent)this.createPagePanel((UiContainer)this), "Center");
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            if (this.mainPanel != null) {
                this.mainPanel.setEnabled(enabled);
            }
            if (this.optionsPanel != null) {
                this.optionsPanel.setEnabled(enabled);
            }
            this.getButtonTuple().setEnabled(enabled);
        }

        protected abstract CheckTreePanel createTreePanel(@NotNull UiContainer var1);

        protected abstract CheckTree getTree();

        protected Msg createLabel() {
            return UIMsg.TO_MSG((String)"A title must be specified here for the default panel");
        }

        @NotNull
        protected ReportGenerator.DetailOption getDetailOption() {
            ButtonTuple buttonTuple = this.getButtonTuple();
            ReportGenerator.DetailOption result = buttonTuple.isDetails() ? ReportGenerator.DetailOption.DETAILS : (this.getTree().getRoot().getSelected() == TreeNode.Selection.ALL ? ReportGenerator.DetailOption.SUMMARY_ALL : ReportGenerator.DetailOption.SUMMARY);
            return result;
        }

        @NotNull
        protected Panel createOptionsPanel(@NotNull UiContainer parent) {
            BorderPanel panel = new BorderPanel(parent);
            panel.setLayout((oracle.bpm.ui.layout.Layout)new FlowLayout(0));
            switch (this.type) {
                case 1: {
                    ReportPanel.this.indicatorsTuple = ReportPanel.this.createButtons((Panel)panel);
                    break;
                }
                case 2: {
                    ReportPanel.this.activitiesTuple = ReportPanel.this.createButtons((Panel)panel);
                    break;
                }
                case 8: {
                    ReportPanel.this.resourcesTuple = ReportPanel.this.createButtons((Panel)panel);
                }
            }
            return panel;
        }

        protected Panel getToolbar(Panel contentPane) {
            return null;
        }

        private ButtonTuple getButtonTuple() {
            ButtonTuple result = null;
            switch (this.type) {
                case 1: {
                    result = ReportPanel.this.indicatorsTuple;
                    break;
                }
                case 2: {
                    result = ReportPanel.this.activitiesTuple;
                    break;
                }
                case 8: {
                    result = ReportPanel.this.resourcesTuple;
                }
            }
            return result;
        }

        private Panel createPagePanel(UiContainer parent) {
            RelativeLayout layout = new RelativeLayout();
            Panel contentPane = new Panel(parent);
            contentPane.setLayout((oracle.bpm.ui.layout.Layout)layout);
            this.optionsPanel = this.createOptionsPanel((UiContainer)contentPane);
            LabelMultiline msgArea = new LabelMultiline((UiContainer)contentPane, this.createLabel());
            contentPane.add((UiComponent)this.optionsPanel, (Object)"optionsPanel");
            contentPane.add((UiComponent)msgArea, (Object)"label");
            contentPane.add(this.getMainPanel(contentPane), (Object)"mainPanel");
            Layout.fixToRoot((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.TOP, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToRoot((RelativeLayout)layout, (String)"optionsPanel", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.TOP, (String)"optionsPanel", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.LEFT, (String)"optionsPanel");
            Layout.fixToComp((RelativeLayout)layout, (String)"label", (AttributeType)AttributeType.RIGHT, (String)"optionsPanel");
            String fixMainPanelTo = "label";
            Panel toolbar = this.getToolbar(contentPane);
            if (toolbar != null) {
                contentPane.add((UiComponent)toolbar, (Object)"toolbar");
                fixMainPanelTo = "toolbar";
                Layout.fixToComp((RelativeLayout)layout, (String)"toolbar", (AttributeType)AttributeType.TOP, (String)"label", (AttributeType)AttributeType.BOTTOM, (int)5);
                Layout.fixToComp((RelativeLayout)layout, (String)"toolbar", (AttributeType)AttributeType.LEFT, (String)"label");
                Layout.fixToComp((RelativeLayout)layout, (String)"toolbar", (AttributeType)AttributeType.RIGHT, (String)"label");
            }
            Layout.fixToComp((RelativeLayout)layout, (String)"mainPanel", (AttributeType)AttributeType.TOP, (String)fixMainPanelTo, (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)layout, (String)"mainPanel", (AttributeType)AttributeType.LEFT, (String)fixMainPanelTo);
            Layout.fixToComp((RelativeLayout)layout, (String)"mainPanel", (AttributeType)AttributeType.RIGHT, (String)fixMainPanelTo);
            Layout.fixToRoot((RelativeLayout)layout, (String)"mainPanel", (AttributeType)AttributeType.BOTTOM, (int)-5);
            return contentPane;
        }
    }

    public class ButtonTuple {
        private final RadioButton<ReportGenerator.DetailOption> details;
        private final ActionListener detailsListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportPanel.this.checkNonRepeatedDetails();
            }
        };
        private final RadioButton<ReportGenerator.DetailOption> summary;

        public ButtonTuple(UiContainer parent) {
            this.summary = new RadioButton(parent, DesignerMsg.SUMMARY);
            this.details = new RadioButton(parent, DesignerMsg.DETAILS);
            this.groupTupleButtons();
        }

        public void setDetails(boolean bool) {
            this.details.setSelected(bool);
            this.summary.setSelected(!bool);
        }

        public void setEnabled(boolean enabled) {
            this.summary.setEnabled(enabled);
            this.details.setEnabled(enabled);
        }

        public boolean isDetails() {
            return this.details.isSelected();
        }

        private void groupTupleButtons() {
            ButtonGroup btnGroup = new ButtonGroup();
            btnGroup.add(this.summary);
            btnGroup.add(this.details);
            this.summary.setSelected(true);
            this.details.setSelected(false);
            this.details.addActionListener(this.detailsListener);
        }
    }
}

