/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.bam.chartviewer.ChartViewer;
import oracle.bpm.bam.report.ReportGenerator;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ReportPanel;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.LineTitledBorder;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.ProviderTableModel;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.utils.Layout;
import org.jetbrains.annotations.NotNull;

class ReportDialog
extends OkCancelDialog {
    private ChartViewer chartViewer;
    private MultipleComponentContainer container;
    private UiWindow owner;
    private ProjectSimulation projectSimulationModel;
    private File targetDataDir;
    private File targetDir;
    private TextField targetFileFld;
    private static final String DATA_DIR = "_DataDir";

    public ReportDialog(@NotNull UiWindow owner, @NotNull ProjectSimulation simulation, @NotNull ChartViewer chartViewer) {
        super(owner, DesignerMsg.SIMULATION_REPORT, true);
        this.owner = owner;
        this.projectSimulationModel = simulation;
        this.chartViewer = chartViewer;
        this.buildPages();
        this.setSize(800, 550);
        this.setLocationRelativeTo((UiComponent)owner);
    }

    public void ok() {
        if (!this.createTargetFiles()) {
            return;
        }
        this.beginWait();
        this.okButton.setEnabled(false);
        List<ReportGenerator.ReportGenerationInfo> reports = this.container.getReportInfos();
        final ReportGenerator generator = new ReportGenerator(this.chartViewer.getChartManager().getDataModel(), reports);
        generator.setBaseFileName(this.projectSimulationModel.getId());
        generator.setOutputDir(this.targetDir);
        generator.setDataDir(this.targetDataDir);
        try {
            FuegoWorker.post((FuegoWorker.Procedure)new FuegoWorker.Procedure(){

                public void run() throws IOException {
                    generator.doIt();
                }
            });
        }
        catch (Exception e) {
            MessageDialog.showError((Throwable)e);
        }
        this.endWait();
        this.setUserAccepted(false);
        this.close();
    }

    private void browse() {
        FileChooser fileChooser = new FileChooser();
        int returnVal = fileChooser.showOpenDialog((UiComponent)this.owner, UIMsg.CHOOSE_DIRECTORY, 4);
        if (returnVal != 0) {
            return;
        }
        try {
            File selectedFile = fileChooser.getSelectedFile();
            String fileChosen = selectedFile.getCanonicalFile().getCanonicalPath();
            this.targetFileFld.setText(fileChosen);
        }
        catch (IOException e1) {
            MessageDialog.showError((Throwable)e1);
        }
    }

    private void buildPages() {
        Panel topPanel = this.createTopPanel(this.getContentPane());
        this.container = new CardMultipleComponentContainer(this.getContentPane(), this.chartViewer);
        ReportPanel panel = new ReportPanel(this.container.getComponentContainer(), this.chartViewer, DesignerMsg.DEFAULT_MSG.toString());
        this.container.addEditor(DesignerMsg.DEFAULT_MSG, panel);
        this.getContentPane().add((UiComponent)topPanel, (Object)"North");
        this.getContentPane().add(this.container.getComponent(), (Object)"Center");
    }

    private boolean createTargetFiles() {
        String targetFileName = this.targetFileFld.getText();
        if (targetFileName == null || targetFileName.length() == 0) {
            MessageDialog.showError((Msg)DesignerMsg.INVALID_REPORT_FILE);
            return false;
        }
        this.targetDir = new File(targetFileName);
        String fileName = this.targetDir.getName();
        this.targetDataDir = new File(this.targetDir, fileName + DATA_DIR);
        if (this.targetDataDir.exists()) {
            File[] files;
            for (File dirFile : files = this.targetDataDir.listFiles()) {
                if (dirFile.delete()) continue;
                MessageDialog.showError((Msg)DesignerMsg.COULD_NOT_DELETE_DATA_DIR_FILE(dirFile.getName()));
                return false;
            }
            if (!this.targetDataDir.delete()) {
                MessageDialog.showError((Msg)DesignerMsg.COULD_NOT_DELETE_DATA_DIR(this.targetDataDir.getName()));
                return false;
            }
        } else {
            this.targetDataDir.mkdirs();
        }
        return true;
    }

    private Panel createTopPanel(UiContainer parent) {
        Panel container = new Panel(parent);
        container.setBorder((Border)new LineTitledBorder(DesignerMsg.REPORT_DIRECTORY.getString()));
        String targetName = System.getProperty("user.home") + File.separator + this.projectSimulationModel.getId();
        this.targetFileFld = new TextField((UiContainer)container, targetName);
        Dimension fldSize = this.targetFileFld.getPreferredSize();
        container.setBorder((Border)new LineTitledBorder(DesignerMsg.REPORT_DIRECTORY.getString()));
        Button targetFileBtn = new Button((UiContainer)container, UIMsg.TO_MSG((String)"..."));
        targetFileBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportDialog.this.browse();
            }
        });
        targetFileBtn.setExactSize(Dimension.valueOf(fldSize.getHeight(), fldSize.getHeight()));
        FormLayout layout = new FormLayout("2dlu, pref, 2dlu, pref:grow, 2dlu, min, 2dlu", "2dlu, pref, 2dlu");
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        builder.add((UiComponent)Label.create((UiContainer)container, (Msg)DesignerMsg.DIRECTORY_LOCATION), cc.xy(2, 2));
        builder.add((UiComponent)this.targetFileFld, cc.xy(4, 2));
        builder.add((UiComponent)targetFileBtn, cc.xy(6, 2));
        return container;
    }

    private static class TabbedMultipleComponentContainer
    extends MultipleComponentContainer {
        private Panel container;
        private TabbedPane tabbedPanel;

        public TabbedMultipleComponentContainer(UiContainer parent) {
            this.container = new Panel(parent);
            this.container.setLayout((oracle.bpm.ui.layout.Layout)new BorderLayout());
            this.tabbedPanel = new TabbedPane((UiContainer)this.container);
            this.container.add((UiComponent)this.tabbedPanel, (Object)"North");
        }

        @Override
        public UiContainer getComponentContainer() {
            return this.tabbedPanel;
        }

        @Override
        public void addEditor(Msg msg, ReportPanel panel) {
            super.addEditor(msg, panel);
            this.tabbedPanel.addTab(msg, (UiComponent)panel);
        }

        @Override
        public UiComponent getComponent() {
            return this.container;
        }
    }

    private static class EditorId {
        public int id;
        public Msg name;
        private final ReportPanel panel;

        public EditorId(Msg msg, int editorId, ReportPanel panel) {
            this.name = msg;
            this.id = editorId;
            this.panel = panel;
        }

        public void changeName(Msg newName) {
            this.name = newName;
        }

        public String toString() {
            return this.name.toString();
        }

        public ReportPanel getPanel() {
            return this.panel;
        }
    }

    private static class CardTablePanel
    extends BaseTablePanel {
        private Runnable addAction;

        public CardTablePanel(UiContainer parent, Runnable addAction) {
            super(parent, DesignerMsg.REPORT_PARTS);
            this.addAction = addAction;
            this.setModel(new CardTableModel());
            this.setPreferredSize(Dimension.valueOf(10, 200));
        }

        public void addListSelectionListener(ListSelectionListener listSelectionListener) {
            this.getTable().addListSelectionListener(listSelectionListener);
        }

        public EditorId getSelection() {
            int selectedRow = this.getTable().getSelectedRow();
            EditorId result = selectedRow >= 0 ? (EditorId)this.getModel().getData().get(selectedRow) : null;
            return result;
        }

        public void refreshSelection() {
            int selectedRow = this.getTable().getSelectedRow();
            if (selectedRow < 0) {
                selectedRow = 0;
            }
            this.getTable().setSelectionInterval(selectedRow, selectedRow);
        }

        public CardTableModel getModel() {
            return (CardTableModel)super.getModel();
        }

        public void addEditor(EditorId editorId) {
            this.getModel().addRow(editorId);
            this.getModel().fireTableDataChanged();
        }

        protected void addAction() {
            this.addAction.run();
        }
    }

    private static class CardMultipleComponentContainer
    extends MultipleComponentContainer {
        private Panel container;
        private Panel content;
        private int editorId = 0;
        private CardLayout layout;
        private final CardTablePanel tablePanel;

        public CardMultipleComponentContainer(UiContainer parent, final ChartViewer chartViewer) {
            this.container = new Panel(parent);
            RelativeLayout relativelayout = new RelativeLayout();
            this.container.setLayout((oracle.bpm.ui.layout.Layout)relativelayout);
            Runnable addAction = new Runnable(){

                @Override
                public void run() {
                    String reportName = MessageDialog.showInput((UiWindow)CardMultipleComponentContainer.this.container.getOwnerWindow(), (Msg)DesignerMsg.NEW_REPORT_PART, (Msg)DesignerMsg.NEW_REPORT_ID);
                    if (reportName != null) {
                        ReportPanel panel = new ReportPanel(CardMultipleComponentContainer.this.getComponentContainer(), chartViewer, reportName);
                        CardMultipleComponentContainer.this.addEditor(Msg.QUOTE(reportName), panel);
                        CardMultipleComponentContainer.this.tablePanel.refreshSelection();
                    }
                }
            };
            this.tablePanel = new CardTablePanel((UiContainer)this.container, addAction);
            this.tablePanel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    EditorId selection = CardMultipleComponentContainer.this.tablePanel.getSelection();
                    int toShow = 0;
                    if (selection != null) {
                        toShow = selection.id;
                    }
                    CardMultipleComponentContainer.this.layout.show((UiContainer)CardMultipleComponentContainer.this.content, toShow + "");
                }
            });
            this.container.add((UiComponent)this.tablePanel, (Object)"tablePanel");
            this.layout = new CardLayout();
            this.content = new Panel((UiContainer)this.container);
            this.content.setLayout((oracle.bpm.ui.layout.Layout)this.layout);
            this.container.add((UiComponent)this.content, (Object)"mainPanel");
            Layout.fixToRoot((RelativeLayout)relativelayout, (String)"tablePanel", (AttributeType)AttributeType.TOP, (int)5);
            Layout.fixToRoot((RelativeLayout)relativelayout, (String)"tablePanel", (AttributeType)AttributeType.LEFT, (int)5);
            Layout.fixToRoot((RelativeLayout)relativelayout, (String)"tablePanel", (AttributeType)AttributeType.RIGHT, (int)-5);
            Layout.fixToComp((RelativeLayout)relativelayout, (String)"mainPanel", (AttributeType)AttributeType.TOP, (String)"tablePanel", (AttributeType)AttributeType.BOTTOM, (int)5);
            Layout.fixToComp((RelativeLayout)relativelayout, (String)"mainPanel", (AttributeType)AttributeType.LEFT, (String)"tablePanel");
            Layout.fixToComp((RelativeLayout)relativelayout, (String)"mainPanel", (AttributeType)AttributeType.RIGHT, (String)"tablePanel");
            Layout.fixToRoot((RelativeLayout)relativelayout, (String)"mainPanel", (AttributeType)AttributeType.BOTTOM, (int)-5);
            this.addEmpty();
        }

        @Override
        public UiContainer getComponentContainer() {
            return this.content;
        }

        @Override
        public void addEditor(Msg msg, ReportPanel panel) {
            super.addEditor(msg, panel);
            ++this.editorId;
            this.content.add((UiComponent)panel, (Object)(this.editorId + ""));
            this.layout.addLayoutComponent(this.editorId + "", (UiComponent)panel);
            this.layout.show((UiContainer)this.content, "" + this.editorId);
            this.tablePanel.addEditor(new EditorId(msg, this.editorId, panel));
        }

        public void addEmpty() {
            Panel panel = new Panel((UiContainer)this.content);
            this.content.add((UiComponent)panel, (Object)(this.editorId + ""));
            this.layout.addLayoutComponent(this.editorId + "", (UiComponent)panel);
            this.layout.show((UiContainer)this.content, "" + this.editorId);
        }

        @Override
        public UiComponent getComponent() {
            return this.container;
        }
    }

    private static abstract class MultipleComponentContainer {
        private List<ReportPanel> reportList = new ArrayList<ReportPanel>();

        protected MultipleComponentContainer() {
        }

        public abstract UiContainer getComponentContainer();

        public void addEditor(Msg msg, ReportPanel panel) {
            this.reportList.add(panel);
        }

        public List<ReportPanel> getReportList() {
            return this.reportList;
        }

        public List<ReportGenerator.ReportGenerationInfo> getReportInfos() {
            ArrayList<ReportGenerator.ReportGenerationInfo> result = new ArrayList<ReportGenerator.ReportGenerationInfo>();
            for (ReportPanel reportPanel : this.reportList) {
                result.add(reportPanel.getReportInfo());
            }
            return result;
        }

        abstract UiComponent getComponent();
    }

    public static class CardTableModel
    extends ProviderTableModel<EditorId> {
        public CardTableModel() {
            super(MsgList.create(DesignerMsg.NAME));
        }

        public boolean isCellEditable(int row, int column) {
            return true;
        }

        public void setValueAt(Object value, int row, int column) {
            EditorId editorId = (EditorId)this.getData().get(row);
            editorId.changeName(Msg.QUOTE((String)value));
            editorId.getPanel().setName((String)value);
            this.fireTableDataChanged();
        }

        public Object getValueAt(int row, int column) {
            return this.getData().get(row);
        }
    }
}

