/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.RealDistribution;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.DistributionPanel;
import oracle.bpm.designer.simulation.RealDistributionCriteriaPanel;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.RealDistributionCriteria;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

class RealDistributionPanel
extends DistributionPanel {
    private UiComponent avg;
    private CardLayout criteriaCardLayout;
    private ComboBox<RealDistributionCriteria> criteriaCombo;
    private Panel criteriaContainerPanel;
    private RealDistributionCriteriaPanel criteriaPanel;
    private Panel realDistributionsPanel;

    public RealDistributionPanel(UiContainer parent, Distribution distrib, int meanType) {
        super(parent, distrib);
        BorderLayout layout = new BorderLayout(5, 5);
        this.setLayout((Layout)layout);
        this.realDistributionsPanel = this.buildCriteriaPanel((UiContainer)this, meanType);
        this.add((UiComponent)this.realDistributionsPanel, "Center");
    }

    @Override
    public AbstractDistribution getDistribution() {
        return this.getDistribution(0);
    }

    @Override
    public AbstractDistribution getDistribution(int meanType) {
        RealDistributionCriteria selectedCriteria = (RealDistributionCriteria)this.criteriaCombo.getSelectedItem();
        if (selectedCriteria != null) {
            this.criteriaPanel = (RealDistributionCriteriaPanel)this.criteriaCardLayout.getComponent(selectedCriteria.getString());
        }
        return this.criteriaPanel.getRealDistribution(meanType);
    }

    @Override
    public void setDistribution(Distribution distribution, int meanType) {
        RealDistributionCriteria savedCriteria = ((RealDistribution)distribution).getRealDistributionCriteria();
        this.criteriaCombo.setSelectedItem((Object)savedCriteria);
    }

    protected Panel buildCriteriaPanel(UiContainer parent, int meanType) {
        Panel realDistributionsPanel = new Panel(parent);
        realDistributionsPanel.setLayout((Layout)new BorderLayout());
        this.criteriaContainerPanel = new Panel((UiContainer)realDistributionsPanel);
        this.criteriaCardLayout = new CardLayout();
        this.criteriaContainerPanel.setLayout((Layout)this.criteriaCardLayout);
        Panel criteriaTypePanel = new Panel((UiContainer)realDistributionsPanel);
        criteriaTypePanel.setLayout((Layout)new FlowLayout(0));
        criteriaTypePanel.add((UiComponent)Label.create((UiContainer)criteriaTypePanel, (Msg)DesignerMsg.REAL_DISTRIBUTION_CRITERIA));
        this.criteriaCombo = UiFactory.createComboBox((UiContainer)criteriaTypePanel);
        RealDistributionCriteria[] distributionCriterias = RealDistributionCriteria.values();
        RealDistribution realDistribution = (RealDistribution)super.getDistribution();
        RealDistributionCriteria savedCriteria = realDistribution.getRealDistributionCriteria();
        for (RealDistributionCriteria realDistributionCriteria : distributionCriterias) {
            this.criteriaCombo.addItem((Object)realDistributionCriteria);
            RealDistributionCriteriaPanel panel = savedCriteria.equals((Object)realDistributionCriteria) ? RealDistributionCriteriaPanel.create((UiContainer)this.criteriaContainerPanel, realDistribution, meanType) : RealDistributionCriteriaPanel.create((UiContainer)this.criteriaContainerPanel, RealDistribution.create((RealDistributionCriteria)realDistributionCriteria), meanType);
            this.criteriaContainerPanel.add((UiComponent)panel, (Object)realDistributionCriteria.getString());
        }
        this.criteriaCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                RealDistributionPanel.this.changeCriteriaPanel();
            }
        });
        criteriaTypePanel.add(this.criteriaCombo);
        realDistributionsPanel.add((UiComponent)criteriaTypePanel, (Object)"North");
        realDistributionsPanel.add((UiComponent)this.criteriaContainerPanel, (Object)"Center");
        this.criteriaCombo.setSelectedItem((Object)savedCriteria);
        this.criteriaCardLayout.show((UiContainer)this.criteriaContainerPanel, savedCriteria.getString());
        this.criteriaPanel = (RealDistributionCriteriaPanel)this.criteriaCardLayout.getComponent(savedCriteria.getString());
        return realDistributionsPanel;
    }

    private void changeCriteriaPanel() {
        RealDistributionCriteria selectedCriteria = (RealDistributionCriteria)this.criteriaCombo.getSelectedItem();
        if (selectedCriteria != null) {
            this.criteriaPanel = (RealDistributionCriteriaPanel)this.criteriaCardLayout.getComponent(selectedCriteria.getString());
            this.criteriaCardLayout.show((UiContainer)this.criteriaContainerPanel, selectedCriteria.getString());
            this.criteriaContainerPanel.revalidate();
        }
    }
}

