/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.NewModelSimulationAction;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.SimulationsContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.editors.AbstractCellEditor;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;
import oracle.bpm.ui.table.TableObjectModel;
import oracle.bpm.ui.table.editors.TableCellEditor;

class ProjectSimulationProcessesPanel
extends Panel
implements ActionListener {
    private Table processesTable;
    private ProcessesTableModel processesTableModel;
    private ProcessTablePanel processTablePanel;
    private FuegoProject project;
    private ProjectSimulation projectSimulationModel;
    private static int MODEL_COLUMN = 0;
    private static int SIMULATION_MODEL_COLUMN = 1;

    public ProjectSimulationProcessesPanel(FuegoProject project, UiContainer parent, ProjectSimulation projectSimulationModel) {
        super(parent);
        this.project = project;
        this.projectSimulationModel = projectSimulationModel;
        this.init();
    }

    public ProjectSimulation getModel() {
        return this.projectSimulationModel;
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void check() throws DesignerException {
        for (int r = 0; r < this.processesTableModel.getRowCount(); ++r) {
            String process = ((SimulationProcessContent)this.processesTableModel.getValueAt(r, 0)).getId();
            String model = (String)this.processesTableModel.getValueAt(r, 1);
            Boolean selected = (Boolean)this.processesTableModel.getValueAt(r, 2);
            if (!selected.booleanValue() || model != null && !"".equals(model)) continue;
            throw new DesignerException(DesignerMsg.NO_MODEL_SELECTED_FOR_SIMULATION(process));
        }
    }

    public void modelToPanel() {
        this.loadTableModel();
    }

    public void panelToModel(ProjectSimulation projectObject) {
        this.projectSimulationModel = projectObject;
        try {
            this.projectSimulationModel.removeModelSimulations(this.projectSimulationModel.getModelSimulations());
        }
        catch (ProjectException e) {
            e.printStackTrace();
        }
        for (int r = 0; r < this.processesTableModel.getRowCount(); ++r) {
            String modelId = ((SimulationProcessContent)this.processesTableModel.getValueAt(r, 0)).getId();
            String modelSimulationId = (String)this.processesTableModel.getValueAt(r, 1);
            Boolean selected = (Boolean)this.processesTableModel.getValueAt(r, 2);
            if (!selected.booleanValue()) continue;
            Process process = this.project.findProcess(modelId);
            SimulationsContainer simulationsContainer = this.project.getSimulations();
            try {
                ModelSimulation modelSimulation = simulationsContainer.findModelSimulation(process, modelSimulationId);
                if (modelSimulation == null) continue;
                this.projectSimulationModel.addModelSimulation(modelSimulation);
                continue;
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
    }

    public void modelSimulationAddedToProject(ModelSimulation modelSimulation) {
        boolean processAlreadyExistInTable;
        boolean bl = processAlreadyExistInTable = this.processesTableModel.getRow(modelSimulation.getProcess()) != -1;
        if (!processAlreadyExistInTable) {
            this.addModelToTableIfApplicable(modelSimulation.getProcess());
        }
    }

    public void modelSimulationRemovedFromProject(ModelSimulation modelSimulation) {
        Process process = modelSimulation.getProcess();
        SimulationsContainer simulationsContainer = process.getProject().getSimulations();
        if (simulationsContainer.getModelSimulationsByProcess(process).isEmpty()) {
            this.deleteRowForModel(process);
        } else {
            String simulationName;
            int row = this.processesTableModel.getRow(process);
            if (row != -1 && (simulationName = (String)this.processesTableModel.getValueAt(row, SIMULATION_MODEL_COLUMN)).equals(modelSimulation.getName())) {
                Sequence modelSimulations = this.project.getSimulations().getModelSimulationsByProcess(process);
                this.processesTableModel.setValueAt(((ModelSimulation)modelSimulations.iterator().next()).getName(), row, SIMULATION_MODEL_COLUMN);
            }
        }
    }

    public void modelRemovedFromProject(Process process) {
        SimulationsContainer simulationsContainer = process.getProject().getSimulations();
        if (!simulationsContainer.getModelSimulationsByProcess(process).isEmpty()) {
            this.deleteRowForModel(process);
        }
    }

    private Panel buildProcessSelectionPanel(UiContainer parent) {
        Panel panel = new Panel(parent);
        panel.setLayout((Layout)new BorderLayout());
        this.processesTableModel = new ProcessesTableModel(DesignerMsg.PROCESS, DesignerMsg.MODEL, DesignerMsg.INCLUDE);
        this.processTablePanel = new ProcessTablePanel(parent, this.processesTableModel, this.project);
        this.processesTable = this.processTablePanel.getTable();
        this.processesTable.getColumn(SIMULATION_MODEL_COLUMN).setCellEditor((TableCellEditor)new SimulationModelsComboCellEditor());
        TableCellEditor cellEditor = this.processesTable.getColumn(SIMULATION_MODEL_COLUMN).getCellEditor();
        panel.add((UiComponent)this.processTablePanel, (Object)"Center");
        return panel;
    }

    private void init() {
        this.setLayout((Layout)new BorderLayout());
        Panel processesTablePanel = this.buildProcessSelectionPanel((UiContainer)this);
        this.modelToPanel();
        this.add((UiComponent)processesTablePanel, "Center");
    }

    private void initProcessTableSelection() {
        if (this.processesTable.getRowCount() > 0) {
            this.processesTable.setSelectionInterval(0, 0);
        }
    }

    private void loadTableModel() {
        Collection processes = this.project.getModels(SchemaType.PROCESS);
        for (Process process : processes) {
            this.addModelToTableIfApplicable(process);
        }
        this.initProcessTableSelection();
    }

    private void addModelToTableIfApplicable(Process process) {
        SimulationsContainer simulationsContainer = process.getProject().getSimulations();
        Sequence simulationsByProcess = simulationsContainer.getModelSimulationsByProcess(process.getId());
        if (!simulationsByProcess.isEmpty()) {
            String name = this.projectSimulationModel.findModelSimulationIdByProcessId(process.getId());
            if (name == null) {
                Sequence sims = simulationsContainer.getModelSimulationsByProcess(process.getId());
                name = ((ModelSimulation)sims.iterator().next()).getId();
            }
            boolean projectSimulationProcess = this.projectSimulationModel.containsModel(process.getId());
            this.processesTableModel.addRow(process, new Object[]{new SimulationProcessContent(process), name, projectSimulationProcess});
        }
    }

    private void deleteRowForModel(Process model) {
        int row = this.processesTableModel.getRow(model);
        if (row != -1) {
            this.processesTableModel.removeRow(row);
        }
    }

    private class SimulationModelsComboCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private ComboBox combo;
        private List<String> modelSimulationNames = new ArrayList<String>();

        private SimulationModelsComboCellEditor() {
        }

        public UiComponent getTableCellEditor(Table parentTable, Object value, boolean isSelected, int row, int column) {
            SimulationProcessContent simulationProcessContent = (SimulationProcessContent)parentTable.getModel().getValueAt(row, MODEL_COLUMN);
            Process process = ProjectSimulationProcessesPanel.this.project.findProcess(simulationProcessContent.getId());
            Sequence modelSimulations = ProjectSimulationProcessesPanel.this.project.getSimulations().getModelSimulationsByProcess(process);
            this.modelSimulationNames.clear();
            for (ModelSimulation modelSimulation : modelSimulations) {
                this.modelSimulationNames.add(modelSimulation.getId());
            }
            return this.createEditor((UiContainer)parentTable, value);
        }

        public Object getCellEditorValue() {
            return this.combo.getSelectedItem();
        }

        public UiComponent createEditor(UiContainer parent, Object value) {
            this.combo = UiFactory.createMutableComboBox((UiContainer)parent, this.modelSimulationNames);
            this.combo.setSelectedItem(value);
            return this.combo;
        }

        public int getClickCountToStart() {
            return 1;
        }
    }

    private static class ProcessTablePanel
    extends BaseTablePanel {
        private BaseAction editProcess;
        private BaseAction editSimulationModel;
        private BaseAction newSimulationModel;
        private FuegoProject project;

        public ProcessTablePanel(UiContainer parent, ProcessesTableModel processesTableModel, FuegoProject project) {
            super(parent, null, null, (TableModel)processesTableModel, BaseTablePanel.Style.TOOLBAR_RIGHT);
            this.project = project;
        }

        protected boolean showAddAction() {
            return false;
        }

        protected BaseAction[] getUserActions() {
            if (this.editProcess == null) {
                this.buildActions();
            }
            return new BaseAction[]{this.editProcess, this.editSimulationModel, this.newSimulationModel};
        }

        protected void addAction() {
        }

        protected Table getTable() {
            return super.getTable();
        }

        protected boolean showRemoveAction() {
            return false;
        }

        protected void enableEditActions(boolean enabled) {
            this.editProcess.setEnabled(enabled);
            this.editSimulationModel.setEnabled(enabled);
            this.newSimulationModel.setEnabled(enabled);
        }

        private void buildActions() {
            this.editProcess = new BaseAction(DesignerMsg.EDIT_PROCESS){

                public void run() {
                    ProcessTablePanel.this.stopCellEditor();
                    int row = ProcessTablePanel.this.getTable().getSelectedRow();
                    SimulationProcessContent processInfo = (SimulationProcessContent)ProcessTablePanel.this.getTable().getValueAt(row, 0);
                    AbstractStudioWorkbench.getInstance().openEditorForObject(processInfo.process);
                }
            };
            this.editSimulationModel = new BaseAction(DesignerMsg.EDIT_SIMULATION_MODEL){

                public void run() {
                    ProcessTablePanel.this.stopCellEditor();
                    int row = ProcessTablePanel.this.getTable().getSelectedRow();
                    SimulationProcessContent processInfo = (SimulationProcessContent)ProcessTablePanel.this.getTable().getValueAt(row, 0);
                    String simulationId = (String)ProcessTablePanel.this.getTable().getValueAt(row, 1);
                    Process process = processInfo.process;
                    Sequence simulations = process.getProject().getSimulations().getModelSimulationsByProcess(process);
                    for (ModelSimulation simulation : simulations) {
                        if (!simulation.getId().equals(simulationId)) continue;
                        AbstractStudioWorkbench.getInstance().openEditorForObject(simulation);
                        break;
                    }
                }
            };
            this.newSimulationModel = new BaseAction(DesignerMsg.NEW_SIMULATION_MODEL){

                public void run() {
                    ProcessTablePanel.this.stopCellEditor();
                    NewModelSimulationAction action = new NewModelSimulationAction(null, (Project)ProcessTablePanel.this.project);
                    action.doIt();
                }
            };
            this.editProcess.setEnabled(false);
            this.editSimulationModel.setEnabled(false);
            this.newSimulationModel.setEnabled(false);
        }
    }

    private static class ProcessesTableModel
    extends TableObjectModel {
        public ProcessesTableModel(Msg ... columns) {
            super(columns);
        }

        public boolean isCellEditable(int row, int col) {
            return col >= 1;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 1: {
                    return ComboBox.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(column);
        }
    }

    static class SimulationProcessContent {
        private Process process;

        public SimulationProcessContent(Process process) {
            this.process = process;
        }

        public String getId() {
            return this.process.getId();
        }

        public String toString() {
            return this.process.getDefaultLabel();
        }
    }
}

