/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ProjectSimulationProcessesPanel;
import oracle.bpm.designer.simulation.ResourcesTable;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.event.TableModelListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.TimeField;
import org.jetbrains.annotations.NotNull;

@Editor(objectClass=ProjectSimulation.class)
public class ProjectSimulationEditor
extends AbstractEditor<ProjectSimulation> {
    private IntervalField durationField;
    private TimeField endTimeField;
    private CheckBox letInflightFinish;
    private TableModelListener modelListener;
    private ProjectListener projectListenerForModel;
    private ProjectListener projectListenerForModelSimulation;
    private ProjectSimulationProcessesPanel projectSimulationProcessesPanel;
    private ButtonGroup<RadioButton> radioGroup = new ButtonGroup();
    private RadioButton rbDuration;
    private RadioButton rbEndTime;
    private ResourcesTable resourcesTable;
    private TimeField startTimeField;
    private Panel timePanel;
    private static final String ID_SIMULATION = "fuego.eclipse.studio.views.SimulationView";

    public ProjectSimulationEditor(UiContainer parent, ProjectSimulation model) {
        super(parent, model, ProjectSimulation.class);
    }

    public static void main(String[] args) {
        Frame f = new Frame("wwww");
        Panel panel = new ProjectSimulationEditor(null, null).buildTimeRelatedPanel((UiContainer)f);
        f.getContentPane().add((UiComponent)panel);
        f.setSize(800, 800);
        f.setVisible(true);
    }

    public ProjectSimulationProcessesPanel getProjectSimulationProcessesPanel() {
        return this.projectSimulationProcessesPanel;
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.SIMULATION_CONFIGURATION;
    }

    @Override
    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.SIMULATION);
    }

    @Override
    public void disposeEditor() {
        this.getProject().removeListener(this.projectListenerForModelSimulation);
        this.projectListenerForModelSimulation = null;
        this.getProject().removeListener(this.projectListenerForModel);
        this.projectListenerForModel = null;
        super.disposeEditor();
    }

    @Override
    protected void objectToEditor() {
        if (this.getProjectObject() != null) {
            this.durationField.setInterval(((ProjectSimulation)this.getProjectObject()).getDuration());
            this.startTimeField.setTime(Time.valueOf(((ProjectSimulation)this.getProjectObject()).getStartTime()));
            this.letInflightFinish.setSelected(((ProjectSimulation)this.getProjectObject()).getInflightFinish());
            this.updateEndTimeFields();
        }
    }

    @Override
    protected void editorToObject() {
        this.getMutableProjectSimulation().setStartTime(this.startTimeField.getTime());
        this.getMutableProjectSimulation().setDuration(this.durationField.getInterval());
        this.getMutableProjectSimulation().setInflightFinish(this.letInflightFinish.isSelected());
        this.updateModelResources(this.getMutableProjectSimulation());
        this.projectSimulationProcessesPanel.panelToModel((ProjectSimulation)this.getProjectObject());
    }

    @Override
    protected void buildUI(UiContainer parent) {
        RelativeLayout relativeLayout = new RelativeLayout();
        parent.setLayout((Layout)relativeLayout);
        TabbedPane tabbedPane = new TabbedPane(parent);
        Panel timeRelatedPanel = this.buildTimeRelatedPanel(parent);
        Panel resourcesPanel = this.buildResourcesPanel((UiContainer)tabbedPane);
        this.projectSimulationProcessesPanel = new ProjectSimulationProcessesPanel((FuegoProject)this.getProject(), (UiContainer)tabbedPane, (ProjectSimulation)this.getProjectObject());
        parent.add((UiComponent)timeRelatedPanel, (Object)"generationPanel");
        parent.add((UiComponent)tabbedPane, (Object)"tabbedPane");
        tabbedPane.addTab(DesignerMsg.PROJECT, (UiComponent)this.projectSimulationProcessesPanel);
        tabbedPane.addTab(DesignerMsg.RESOURCES, (UiComponent)resourcesPanel);
        relativeLayout.addConstraint("generationPanel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        relativeLayout.addConstraint("generationPanel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        relativeLayout.addConstraint("generationPanel", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        relativeLayout.addConstraint("tabbedPane", AttributeType.TOP, (Constraint)new AttributeConstraint("generationPanel", AttributeType.BOTTOM));
        relativeLayout.addConstraint("tabbedPane", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        relativeLayout.addConstraint("tabbedPane", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        relativeLayout.addConstraint("tabbedPane", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM));
        this.initProjectListener();
        AbstractStudioWorkbench.getInstance().showView(ID_SIMULATION);
    }

    private ProjectSimulation getMutableProjectSimulation() {
        return (ProjectSimulation)this.getProjectObject();
    }

    private Panel buildResourcesPanel(UiContainer parent) {
        ResourcesTable.ViewPanel panel = new ResourcesTable.ViewPanel(parent, (ProjectSimulation)this.getProjectObject());
        this.resourcesTable = panel.getResourcesTable();
        return panel;
    }

    private Panel buildTimeRelatedPanel(UiContainer parent) {
        MigLayout layout = new MigLayout();
        this.timePanel = new Panel(parent, DesignerMsg.SIMULATION_DEFINITION);
        this.timePanel.setLayout((Layout)layout);
        this.startTimeField = new TimeField((UiContainer)this.timePanel);
        this.startTimeField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ProjectSimulationEditor.this.updateEndTimeFields();
            }
        });
        this.durationField = IntervalField.createPositiveIntervalField((UiContainer)this.timePanel);
        this.durationField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                ProjectSimulationEditor.this.updateEndTimeFields();
            }
        });
        this.endTimeField = new TimeField((UiContainer)this.timePanel);
        this.endTimeField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                ProjectSimulationEditor.this.updateEndTimeFields();
            }
        });
        this.letInflightFinish = CheckBox.create((UiContainer)this.timePanel, (Msg)DesignerMsg.INFLIGHT_FINISH);
        this.rbDuration = this.createNewRadioButton((UiContainer)this.timePanel, DesignerMsg.DURATION);
        this.rbEndTime = this.createNewRadioButton((UiContainer)this.timePanel, DesignerMsg.DATE);
        this.radioGroup.add((AbstractButton)this.rbDuration);
        this.radioGroup.add((AbstractButton)this.rbEndTime);
        this.timePanel.add((UiComponent)Label.create((UiContainer)this.timePanel, (Msg)DesignerMsg.START_TIME), (Object)"width 120,gapleft 2");
        this.timePanel.add((UiComponent)this.startTimeField, (Object)"span,wrap");
        this.timePanel.add((UiComponent)Label.create((UiContainer)this.timePanel, (Msg)DesignerMsg.END_TIME), (Object)"gapleft 2");
        this.timePanel.add((UiComponent)this.rbDuration);
        this.timePanel.add((UiComponent)this.rbEndTime, (Object)"wrap");
        this.timePanel.add((UiComponent)this.letInflightFinish, (Object)"span,cell 0 3");
        this.rbDuration.setSelected(true);
        return this.timePanel;
    }

    private RadioButton createNewRadioButton(@NotNull UiContainer container, Msg msg) {
        RadioButton result = new RadioButton(container, msg);
        result.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (ProjectSimulationEditor.this.rbDuration.isSelected()) {
                    ProjectSimulationEditor.this.timePanel.add((UiComponent)ProjectSimulationEditor.this.durationField, (Object)"span,cell 1 2,wrap");
                    ProjectSimulationEditor.this.timePanel.remove((UiComponent)ProjectSimulationEditor.this.endTimeField);
                    ProjectSimulationEditor.this.endTimeField.setVisible(false);
                    ProjectSimulationEditor.this.durationField.setVisible(true);
                } else {
                    ProjectSimulationEditor.this.timePanel.add((UiComponent)ProjectSimulationEditor.this.endTimeField, (Object)"span,cell 1 2,wrap");
                    ProjectSimulationEditor.this.timePanel.remove((UiComponent)ProjectSimulationEditor.this.durationField);
                    ProjectSimulationEditor.this.durationField.setVisible(false);
                    ProjectSimulationEditor.this.endTimeField.setVisible(true);
                }
                ProjectSimulationEditor.this.timePanel.repaint();
            }
        });
        return result;
    }

    private void updateEndTimeFields() {
        Time startTime = this.startTimeField.getTime();
        if (this.rbDuration.isSelected()) {
            Interval interval = this.durationField.getInterval();
            startTime = startTime.add(interval);
            this.endTimeField.setTime(startTime);
        } else {
            Time endTime = this.endTimeField.getTime();
            long duration = endTime.getMicroSeconds() - startTime.getMicroSeconds();
            if (duration < 0L) {
                this.endTimeField.setTime(startTime.toTime());
                endTime = startTime;
            }
            Interval newTime = endTime.sub(startTime);
            this.durationField.setInterval(newTime);
        }
    }

    private void checkResources() throws DesignerException {
        this.resourcesTable.checkResources();
    }

    private void updateModelResources(ProjectSimulation model) {
        this.resourcesTable.updateModelResources(model);
    }

    private void initProjectListener() {
        if (this.projectListenerForModelSimulation == null) {
            this.projectListenerForModelSimulation = new ProjectListenerAdapter<ModelSimulation>(ModelSimulation.class){

                public void postObjectAdded(ModelSimulation object, ProjectObject parent) {
                    ProjectSimulationEditor.this.projectSimulationProcessesPanel.modelSimulationAddedToProject(object);
                }

                public void postObjectRemoved(ModelSimulation object, ProjectObject parent) {
                    ProjectSimulationEditor.this.projectSimulationProcessesPanel.modelSimulationRemovedFromProject(object);
                }
            };
            this.getProject().addListener(this.projectListenerForModelSimulation);
        }
        if (this.projectListenerForModel == null) {
            this.projectListenerForModel = new ProjectListenerAdapter<Process>(Process.class){

                public void postObjectRemoved(Process object, ProjectObject parent) {
                    ProjectSimulationEditor.this.projectSimulationProcessesPanel.modelRemovedFromProject(object);
                }
            };
            this.getProject().addListener(this.projectListenerForModel);
        }
    }
}

