/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.ArrayList;
import java.util.List;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.table.AbstractTableModel;

class PriorityTableModel
extends AbstractTableModel {
    private StringList names = StringList.create();
    private List<Integer> values = new ArrayList<Integer>();
    private static final int NAME_COLUMN = 0;
    static final int VALUE_COLUMN = 1;

    public boolean isCellEditable(int row, int column) {
        return column == 1 && row != this.getRowCount() - 1;
    }

    public String getColumnName(int column) {
        Msg msg = column == 0 ? ProjectDrawMsg.NAME : DesignerMsg.VALUE;
        return msg.getString();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? String.class : Integer.class;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.names.size();
    }

    public Object getValueAt(int row, int column) {
        return column == 0 ? this.getName(row) : this.getValue(row);
    }

    public void setValueAt(Object value, int row, int column) {
        if (column == 1 && this.getValue(row) != value) {
            this.setValue(row, (Integer)value);
            this.fireTableCellUpdated(row, column);
        }
    }

    public void clear() {
        int rows = this.names.size();
        if (rows > 0) {
            this.names.clear();
            this.names.clear();
            this.fireTableRowsDeleted(0, rows - 1);
        }
    }

    public void addRow(String name, int value) {
        int row = this.names.size();
        this.names.add(name);
        this.values.add(value);
        this.fireTableRowsInserted(row, row);
    }

    public void setValue(int row, Integer value) {
        this.values.set(row, value);
    }

    Integer getValue(int row) {
        return this.values.get(row);
    }

    private String getName(int row) {
        return (String)this.names.get(row);
    }
}

