/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.NormalDistribution;
import oracle.bpm.designer.simulation.DistributionPanel;
import oracle.bpm.lang.Interval;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;

class NormalDistributionPanel
extends DistributionPanel {
    private UiComponent avg;
    private UiComponent sigma;

    public NormalDistributionPanel(UiContainer parent, Distribution distribution, int meanType) {
        super(parent, distribution);
        this.buildPanel(meanType);
    }

    @Override
    public AbstractDistribution getDistribution() {
        return this.getDistribution(0);
    }

    @Override
    public AbstractDistribution getDistribution(int meanType) {
        if (meanType == 0) {
            return this.getIntervalDistribution();
        }
        return this.getNumericDistribution();
    }

    @Override
    public void setDistribution(Distribution distribution, int meanType) {
        if (meanType == 0) {
            ((IntervalField)this.avg).setInterval(Interval.normalizedValueOf(distribution.getAvgValue()));
            ((IntervalField)this.sigma).setInterval(Interval.normalizedValueOf(distribution.getDeviation()));
        } else {
            ((NumericField)this.avg).setValue((Number)(distribution.getAvgValue() == NormalDistribution.DEFAULT_MEAN ? 1 : (int)distribution.getAvgValue()));
            ((NumericField)this.sigma).setValue((Number)(distribution.getDeviation() == NormalDistribution.DEFAULT_DEVIATION ? 0 : (int)distribution.getDeviation()));
        }
    }

    private AbstractDistribution getIntervalDistribution() {
        if (((IntervalField)this.avg).getInterval() == null) {
            return NormalDistribution.create();
        }
        NormalDistribution distribution = (NormalDistribution)super.getDistribution();
        distribution.setMean(((IntervalField)this.avg).getInterval().getTotalMicroseconds());
        distribution.setDeviation(((IntervalField)this.sigma).getInterval().getTotalMicroseconds());
        return distribution;
    }

    private AbstractDistribution getNumericDistribution() {
        NumericField numericSpinner = (NumericField)this.avg;
        if (numericSpinner.getValue().intValue() < 0) {
            return NormalDistribution.create();
        }
        NormalDistribution distribution = (NormalDistribution)super.getDistribution();
        distribution.setMean((long)numericSpinner.getValue().intValue());
        distribution.setDeviation((long)((NumericField)this.sigma).getValue().intValue());
        return distribution;
    }

    private void buildPanel(int meanType) {
        if (meanType == 0) {
            this.avg = NormalDistributionPanel.createIntervalAvgField((UiContainer)this, this.distribution);
            this.sigma = NormalDistributionPanel.createIntervalDeviationField((UiContainer)this, this.distribution);
        } else {
            this.avg = NormalDistributionPanel.createNumericAvgField((UiContainer)this, this.distribution, NormalDistribution.DEFAULT_MEAN);
            this.sigma = NormalDistributionPanel.createNumericDeviationField((UiContainer)this, this.distribution, NormalDistribution.DEFAULT_DEVIATION);
        }
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        Label avgIntervalLabel = Label.create((UiContainer)this, (Msg)ProjectMsg.MEAN);
        Label sigmaIntervalLabel = Label.create((UiContainer)this, (Msg)ProjectMsg.STDDEVIATION);
        this.add((UiComponent)avgIntervalLabel, "avgIntervalLabel");
        this.add(this.avg, "avgInterval");
        this.add((UiComponent)sigmaIntervalLabel, "sigmaIntervalLabel");
        this.add(this.sigma, "sigmaInterval");
        layout.addConstraint("avgIntervalLabel", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("avgInterval", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("avgIntervalLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("avgInterval", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("avgInterval", AttributeType.LEFT, (Constraint)new AttributeConstraint("sigmaIntervalLabel", AttributeType.RIGHT, 5));
        layout.addConstraint("sigmaIntervalLabel", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("sigmaInterval", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("sigmaIntervalLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("sigmaInterval", AttributeType.TOP, (Constraint)new AttributeConstraint("avgInterval", AttributeType.BOTTOM, 2));
        layout.addConstraint("sigmaInterval", AttributeType.LEFT, (Constraint)new AttributeConstraint("avgInterval", AttributeType.LEFT));
        layout.addConstraint("sigmaInterval", AttributeType.RIGHT, (Constraint)new AttributeConstraint("avgInterval", AttributeType.RIGHT));
    }
}

