/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationDialogFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.ui.MessageDialog;

class NewSimulationAction
extends DesignerAction {
    private Project project;

    public NewSimulationAction(Project project) {
        super(DesignerMsg.NEW_SIMULATION);
        this.requires(ProjectObject.class);
        this.project = project;
    }

    @Override
    public boolean doIt() {
        boolean result;
        try {
            result = this.newSimulation();
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
            result = false;
        }
        return result;
    }

    public void unDoIt() {
    }

    private boolean newSimulation() throws ProjectException {
        String name = this.getNewSimulationName();
        return name != null && new OpenObjectAction(this.project.getSimulations().createAndAddProjectSimulation(name)).doIt();
    }

    private Project getProject() {
        return this.project;
    }

    private String getNewSimulationName() {
        return SimulationDialogFactory.showSimulationNameDialog(this.getProject());
    }
}

