/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import java.util.Collection;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationModelNameInputValidator;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.msg.ProjectModelMsg;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.text.TextField;

public class NewModelSimulationAction
extends DesignerAction {
    private Process model;
    private Project project;

    public NewModelSimulationAction(Process model, Project project) {
        this(DesignerMsg.NEW_PROCESS_SIMULATION, model, project);
    }

    public NewModelSimulationAction(Msg msg, Process model, Project project) {
        super(msg);
        this.requires(Object.class);
        this.model = model;
        this.project = project;
    }

    @Override
    public boolean doIt() {
        boolean result;
        try {
            result = this.newModelSimulation();
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
            result = false;
        }
        return result;
    }

    protected void updateEnableStatus(Selection selection) {
        ProjectObject projectObject = (ProjectObject)selection.as(ProjectObject.class);
        Project project = projectObject.getProject();
        boolean b = project.getRepository().isOpen(project);
        if (!b) {
            this.setEnabled(false);
        }
    }

    private boolean newModelSimulation() throws ProjectException {
        String name = null;
        if (this.model != null) {
            name = this.getNewModelSimulationName();
        } else {
            NewModelSimulationDialog dialog = new NewModelSimulationDialog(Ui.getRoot());
            dialog.setVisible(true);
            if (dialog.userAccepted()) {
                name = dialog.getModelSimulationName();
                this.model = dialog.getProcess();
            }
        }
        if (name != null && this.model != null) {
            Process mutableModel = this.model;
            String modelId = this.model.getId();
            ModelSimulation modelSimulation = mutableModel.getProject().createModelSimulation(modelId, name);
            mutableModel.getProject().getSimulations().addModelSimulation(modelId, modelSimulation);
            OpenObjectAction open = new OpenObjectAction(modelSimulation);
            return open.doIt();
        }
        return false;
    }

    private String getNewModelSimulationName() {
        return MessageDialog.showInputDialog((UiWindow)Ui.getRoot(), (Msg)ProjectDrawMsg.CREATE((String)DesignerMsg.SIMULATION_MODEL.toString()), (Msg)DesignerMsg.MODEL_SIMULATION_NAME, (InputValidator)new SimulationModelNameInputValidator(this.model), (String)ModelUtils.nextNameForModelSimulation((Process)this.model, (String)ProjectModelMsg.PROCESS_SIMULATION.getString()), (boolean)true);
    }

    private class NewModelSimulationDialog
    extends OkCancelDialog {
        private NewModelSimulationPanel simulationPanel;

        public NewModelSimulationDialog(UiWindow owner) {
            super(owner, ProjectUiMsg.CREATE((Msg)ProjectModelMsg.PROCESS_SIMULATION));
            this.simulationPanel = new NewModelSimulationPanel(this.getContentPane(), ProjectDrawMsg.NAME);
            this.buildDialog();
        }

        public void ok() {
            if (this.simulationPanel.ok()) {
                this.close();
            }
        }

        public String getModelSimulationName() {
            return this.simulationPanel.getSimulationModelName();
        }

        public Process getProcess() {
            return this.simulationPanel.getSelectedProcess();
        }

        private void buildDialog() {
            this.getContentPane().add((UiComponent)this.simulationPanel, (Object)"Center");
            this.pack();
            this.setLocationRelativeTo((UiComponent)this.getParent());
            this.setResizable(false);
        }

        private class NewModelSimulationPanel
        extends Panel {
            private SimulationComponentBuilder simulationComponentBuilder;

            public NewModelSimulationPanel(UiContainer parent, Msg title) {
                super(parent, title);
                Panel pane = new Panel(parent);
                this.buildMainPanel(pane);
                this.add((UiComponent)pane);
            }

            public boolean ok() {
                String name = this.getSimulationModelName();
                if (name == null || "".equals(name)) {
                    MessageDialog.showError((Msg)DesignerMsg.INVALID_SIMULATION_MODEL_IDENTIFIER);
                    return false;
                }
                if (NewModelSimulationAction.this.project.getSimulations().findModelSimulation(this.getSelectedProcess(), name) != null) {
                    MessageDialog.showError((Msg)DesignerMsg.MODEL_SIMULATION_EXISTS);
                    return false;
                }
                return true;
            }

            public Process getSelectedProcess() {
                return this.simulationComponentBuilder.getSelectedProcess();
            }

            public String getSimulationModelName() {
                return this.simulationComponentBuilder.getSimulationModelName();
            }

            private void buildMainPanel(Panel parent) {
                this.simulationComponentBuilder = new SimulationComponentBuilder(NewModelSimulationAction.this.project){

                    @Override
                    public void doRevalidate() {
                        NewModelSimulationPanel.this.revalidate();
                    }

                    private void enableOk(boolean okEnable) {
                        NewModelSimulationDialog.this.enableOk(okEnable);
                    }
                };
                this.simulationComponentBuilder.build((UiContainer)parent);
                ComboBox<Process> processes = this.simulationComponentBuilder.getProcessComponent();
                TextField simulationModelName = this.simulationComponentBuilder.getSimulationComponent();
                LabelMultiline errorLabel = this.simulationComponentBuilder.getErrorLabel();
                String cols = "5dlu, pref, 5dlu, pref:grow, pref, 5dlu";
                String innerGap = "3dlu";
                String outterGap = "6dlu";
                String prefered = ",p,";
                String rows = "p," + innerGap + prefered + innerGap + prefered + outterGap + prefered + innerGap + prefered + outterGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered;
                FormLayout layout = new FormLayout(cols, rows);
                PanelBuilder builder = layout.createBuilder(parent);
                CellConstraints constraints = layout.createCellConstraints();
                builder.addSeparator(ProjectDrawMsg.PROCESS.getString(), constraints.xywh(2, 1, 4, 1));
                builder.add(processes, constraints.xywh(2, 3, 3, 1));
                builder.addSeparator(DesignerMsg.MODEL_SIMULATION_NAME.getString(), constraints.xywh(2, 7, 4, 1));
                builder.add((UiComponent)simulationModelName, constraints.xywh(2, 9, 3, 1));
                builder.add((UiComponent)errorLabel, constraints.xywh(2, 11, 3, 1));
            }
        }
    }

    public static class SimulationComponentBuilder {
        private LabelMultiline errorLabel;
        private Process fixedProcess;
        private ComboBox<Process> processes;
        private Project project;
        private TextField simulationModelName;
        private SimulationModelNameInputValidator validator;

        public SimulationComponentBuilder(Project project) {
            this.project = project;
        }

        public void build(UiContainer parent) {
            Collection processCollection = this.project.getProcesses();
            this.processes = UiFactory.createComboBox((UiContainer)parent, (boolean)false, (Object[])processCollection.toArray(new Process[processCollection.size()]));
            this.simulationModelName = new TextField(parent, 30);
            this.simulationModelName.setText(ModelUtils.nextNameForModelSimulation((Process)this.getSelectedProcess(), (String)ProjectModelMsg.PROCESS_SIMULATION.getString()));
            this.errorLabel = new LabelMultiline(parent, DesignerMsg.EMPTY_MSG(""));
            this.errorLabel.setForeground(Color.RED);
            this.validator = new SimulationModelNameInputValidator(this.getSelectedProcess());
            this.processes.setLabelProvider((LabelProvider)new LabelProvider<Process>(){

                public Image getIcon(Process process) {
                    return null;
                }

                public String getText(Process process) {
                    return process.getName();
                }
            });
            this.processes.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.isStateSelected()) {
                        SimulationComponentBuilder.this.validator = new SimulationModelNameInputValidator(SimulationComponentBuilder.this.getSelectedProcess());
                        SimulationComponentBuilder.this.simulationModelName.setText(ModelUtils.nextNameForModelSimulation((Process)SimulationComponentBuilder.this.getSelectedProcess(), (String)ProjectModelMsg.PROCESS_SIMULATION.getString()));
                    }
                }
            });
            this.simulationModelName.addDocumentListener((DocumentListener)new DocumentListener.Default(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void anyUpdate(DocumentEvent e) {
                    Msg error = UIMsg.TO_MSG((String)"");
                    boolean okEnable = true;
                    try {
                        if (SimulationComponentBuilder.this.validator != null) {
                            SimulationComponentBuilder.this.validator.validate(SimulationComponentBuilder.this.simulationModelName.getText());
                        }
                    }
                    catch (InputValidationException ive) {
                        error = ive.getKey();
                        okEnable = false;
                    }
                    finally {
                        Msg previousMsg = SimulationComponentBuilder.this.errorLabel.getMsg();
                        SimulationComponentBuilder.this.errorLabel.setMsg(error);
                        SimulationComponentBuilder.this.enableOk(okEnable);
                        if (error != null && !error.equals(previousMsg)) {
                            SimulationComponentBuilder.this.doRevalidate();
                        }
                    }
                }
            });
        }

        public void doRevalidate() {
        }

        public ComboBox<Process> getProcessComponent() {
            return this.processes;
        }

        public TextField getSimulationComponent() {
            return this.simulationModelName;
        }

        public LabelMultiline getErrorLabel() {
            return this.errorLabel;
        }

        public Process getSelectedProcess() {
            if (this.fixedProcess != null) {
                return this.fixedProcess;
            }
            return (Process)this.processes.getSelectedItem();
        }

        public String getSimulationModelName() {
            return this.simulationModelName.getText();
        }

        public void setModel(Process model) {
            this.fixedProcess = model;
        }

        private void enableOk(boolean okEnable) {
        }
    }
}

