/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.panels.builder.EditableComponent;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.NumericField;
import org.jetbrains.annotations.Nullable;

public class ModelSimulationInstancePanel
extends Panel
implements EditableComponent<ModelSimulation> {
    private ModelSimulation element;
    private NumericField<Integer> maxInstancesSpinner;
    private CheckBox useMaxInstances;

    public ModelSimulationInstancePanel(UiContainer parent, @Nullable ModelSimulation element) {
        super(parent);
        this.element = element;
        this.makeRecyclable();
        this.buildUi();
    }

    @Override
    public void validateEditor() throws ProjectException {
    }

    @Override
    public void applyChanges() {
        ModelSimulation simulation = this.getElement();
        simulation.setUseMaxInstances(this.useMaxInstances.isSelected());
        simulation.setMaxInstances(((Integer)this.maxInstancesSpinner.getValue()).intValue());
    }

    @Override
    public boolean isDirty() {
        return this.useMaxInstances.isSelected() != this.getElement().getUseMaxInstances() || !((Integer)this.maxInstancesSpinner.getValue()).equals(this.getElement().getMaxInstances());
    }

    @Override
    public void populateValues() {
        this.loadValues();
    }

    @Override
    public void loadValues() {
        boolean useMaxInstances = this.getElement().getUseMaxInstances();
        this.useMaxInstances.setSelected(useMaxInstances);
        this.maxInstancesSpinner.setEnabled(useMaxInstances);
        int maxInstances = this.getElement().getMaxInstances();
        if (useMaxInstances || maxInstances != 0) {
            this.maxInstancesSpinner.setValue((Number)maxInstances, true);
        }
    }

    @Override
    public UiComponent getUiComponent() {
        return this;
    }

    @Override
    public ModelSimulation getElement() {
        return this.element;
    }

    @Override
    public void setElement(ModelSimulation element) {
        this.element = element;
    }

    private void buildUi() {
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        Panel maximumPanel = this.buildMaximumPanel((UiContainer)this);
        this.add((UiComponent)maximumPanel, "maximum");
        layout.addConstraint("maximum", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("maximum", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("maximum", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT));
        this.setPreferredSize(Dimension.valueOf(450, 50));
    }

    private Panel buildMaximumPanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel instanceGenerationPanel = new Panel(parent, DesignerMsg.INSTANCE_GENERATION_INFO);
        instanceGenerationPanel.setLayout((Layout)layout);
        this.useMaxInstances = CheckBox.create((UiContainer)instanceGenerationPanel, (Msg)DesignerMsg.ENABLE_MAX_INTANCES_LIMIT);
        this.useMaxInstances.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ModelSimulationInstancePanel.this.updateMaxField();
            }
        });
        this.maxInstancesSpinner = NumericField.createIntegerNumericField((UiContainer)instanceGenerationPanel);
        this.maxInstancesSpinner.setValue((Number)100);
        this.maxInstancesSpinner.setRange((Number)1, (Number)1000000000);
        this.maxInstancesSpinner.setStepSize((Number)1);
        this.updateMaxField();
        instanceGenerationPanel.add(this.maxInstancesSpinner, (Object)"maxInstancesSpinner");
        instanceGenerationPanel.add((UiComponent)this.useMaxInstances, (Object)"useMaxInstances");
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"useMaxInstances", (AttributeType)AttributeType.VERTICAL_CENTER, (String)"maxInstancesSpinner");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"useMaxInstances", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"maxInstancesSpinner", (AttributeType)AttributeType.TOP, (int)2);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"maxInstancesSpinner", (AttributeType)AttributeType.LEFT, (String)"useMaxInstances", (AttributeType)AttributeType.RIGHT, (int)5);
        return instanceGenerationPanel;
    }

    private void updateMaxField() {
        this.maxInstancesSpinner.setEnabled(this.useMaxInstances.isSelected());
    }
}

