/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.AbstractEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.ErrorList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ActivitiesPanel;
import oracle.bpm.designer.simulation.ModelSimulationInstancePanel;
import oracle.bpm.extensionpoint.metadata.Editor;
import oracle.bpm.log.Log;
import oracle.bpm.project.compile.process.ProcessChecker;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectMessageListener;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;

@Editor(objectClass=ModelSimulation.class)
public class ModelSimulationEditor
extends AbstractEditor<ModelSimulation> {
    private ActivitiesPanel activitiesPanel;
    private ModelSimulationInstancePanel instancePanel;
    private ProjectListener<ModelSimulation> modelSimulationReplaceListener;
    private UiContainer uiParent;

    public ModelSimulationEditor(UiContainer parent, ModelSimulation model) {
        super(parent, model, ModelSimulation.class);
    }

    @Override
    public void check() throws ProjectException {
    }

    public ModelSimulation getModelSimulation() {
        return (ModelSimulation)this.getProjectObject();
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.MODEL_SIMULATION_CONFIGURATION;
    }

    @Override
    public Image getIcon() {
        return Image.create((Msg)DesignerMsg.SIMULATION);
    }

    @Override
    public void disposeEditor() {
        this.removeModelListeners();
        super.disposeEditor();
    }

    @Override
    protected void objectToEditor() {
        if (this.objectReplaced) {
            this.instancePanel.dispose();
            this.activitiesPanel.dispose();
            this.uiParent.removeAll();
            this.buildUI(this.uiParent);
            this.uiParent.revalidate();
        }
        this.instancePanel.populateValues();
        this.activitiesPanel.populateValues();
    }

    @Override
    protected void editorToObject() {
        this.activitiesPanel.editorToObject();
        this.instancePanel.applyChanges();
    }

    @Override
    protected void buildUI(UiContainer parent) {
        this.uiParent = parent;
        parent.setLayout((Layout)new BorderLayout());
        this.checkModel();
        Panel instances = this.buildInstanceGenerationPanel(parent);
        Panel activities = this.buildActivitiesPanel(parent);
        parent.add((UiComponent)instances, (Object)"North");
        parent.add((UiComponent)activities, (Object)"Center");
        this.revalidate();
    }

    @Override
    protected void setProjectObject(ModelSimulation projectObject) {
        super.setProjectObject(projectObject);
        this.revalidate();
    }

    private void checkModel() {
        ProcessChecker checker = new ProcessChecker(((ModelSimulation)this.getProjectObject()).getProcess());
        checker.setListener((ProjectMessageListener)new ErrorList());
        try {
            checker.check();
        }
        catch (Throwable e) {
            Log.logWarning(e);
        }
    }

    private Panel buildActivitiesPanel(UiContainer parent) {
        Panel borderPanel = new Panel(parent, DesignerMsg.FLOW_NODES);
        borderPanel.setLayout((Layout)new BorderLayout());
        this.activitiesPanel = new ActivitiesPanel(parent, this.getModelSimulation(), this);
        borderPanel.add((UiComponent)this.activitiesPanel, (Object)"Center");
        return borderPanel;
    }

    private Panel buildInstanceGenerationPanel(UiContainer parent) {
        this.instancePanel = new ModelSimulationInstancePanel(parent, this.getModelSimulation());
        return this.instancePanel;
    }

    private void removeModelListeners() {
        Project project = this.getProject();
        this.activitiesPanel.unregisterListeners();
    }
}

