/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.NormalDistribution;
import fuego.simulation.RealDistribution;
import java.text.DateFormat;
import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.lang.Day;
import oracle.bpm.lang.Month;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.Week;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.RealDistributionCriteria;
import oracle.bpm.ui.table.ProviderTableModel;

public class GenericDistributionDataTableModel
extends ProviderTableModel<Distribution> {
    protected final RealDistributionCriteria realDistributionCriteria;

    public GenericDistributionDataTableModel(RealDistribution realDistribution, MsgList columnIdentifiers) {
        super(columnIdentifiers, realDistribution.getDistributions());
        this.realDistributionCriteria = realDistribution.getRealDistributionCriteria();
    }

    public boolean isCellEditable(int row, int col) {
        return col >= 1;
    }

    public Object getValueAt(int row, int column) {
        NormalDistribution distribution = (NormalDistribution)this.getRow(row);
        switch (column) {
            case 0: {
                return this.getIntervalLabel(row);
            }
            case 1: {
                return NormalDistribution.hasNoSample((NormalDistribution)distribution) ? null : Long.valueOf(distribution.getMean());
            }
            case 2: {
                return NormalDistribution.hasNoSample((NormalDistribution)distribution) ? null : Long.valueOf(distribution.getDeviation());
            }
        }
        return null;
    }

    public String getIntervalLabel(int interval) {
        String intervalLabel;
        switch (this.realDistributionCriteria) {
            case DAILY: {
                intervalLabel = Day.values()[interval].getString();
                break;
            }
            case HOURLY: {
                intervalLabel = Time.valueOf(interval, 0).format(DateFormat.getTimeInstance());
                break;
            }
            case MONTHLY: {
                intervalLabel = Month.valueOf(interval + 1).getString();
                break;
            }
            case WEEKLY: {
                intervalLabel = Week.values()[interval].getString();
                break;
            }
            default: {
                intervalLabel = "<" + interval + ">";
            }
        }
        return intervalLabel;
    }

    public void setValueAt(Object value, int row, int column) {
        NormalDistribution distribution = (NormalDistribution)this.getRow(row);
        boolean updated = false;
        switch (column) {
            case 1: {
                if (distribution.getMean() == ((Long)value).longValue()) break;
                distribution.setMean(((Long)value).longValue());
                updated = true;
                break;
            }
            case 2: {
                if (distribution.getDeviation() == ((Long)value).longValue()) break;
                distribution.setDeviation(((Long)value).longValue());
                updated = true;
            }
        }
        if (updated) {
            this.fireTableRowsUpdated(row, row);
        }
    }

    public void createDefaultDistributionIfEmpty(int row) {
    }

    public Class getColumnClass(int column) {
        return super.getColumnClass(column);
    }
}

