/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.AbstractDistribution;
import oracle.bpm.designer.simulation.ConstantDistributionPanel;
import oracle.bpm.designer.simulation.ExponentialDistributionPanel;
import oracle.bpm.designer.simulation.NormalDistributionPanel;
import oracle.bpm.designer.simulation.RealDistributionPanel;
import oracle.bpm.designer.simulation.UniformDistributionPanel;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.model.simulation.DistributionType;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;

abstract class DistributionPanel
extends Panel {
    Distribution distribution;
    public static final int INTERVAL = 0;
    public static final int NUMERIC = 1;

    public DistributionPanel(UiContainer parent, Distribution distribution) {
        super(parent);
        this.distribution = distribution;
    }

    public abstract void setDistribution(Distribution var1, int var2);

    public static DistributionPanel create(UiContainer parent, DistributionType distributionType) {
        return DistributionPanel.create(parent, (Distribution)AbstractDistribution.create((DistributionType)distributionType));
    }

    public static DistributionPanel create(UiContainer parent, DistributionType distributionType, int meanType) {
        return DistributionPanel.create(parent, (Distribution)AbstractDistribution.create((DistributionType)distributionType), meanType);
    }

    public static DistributionPanel create(UiContainer parent, Distribution distribution, int meanType) {
        DistributionType type = distribution.getType();
        if (type == DistributionType.CONSTANT) {
            return new ConstantDistributionPanel(parent, distribution, meanType);
        }
        if (type == DistributionType.UNIFORM) {
            return new UniformDistributionPanel(parent, distribution, meanType);
        }
        if (type == DistributionType.EXPONENTIAL && meanType == 0) {
            return new ExponentialDistributionPanel(parent, distribution);
        }
        if (type == DistributionType.NORMAL) {
            return new NormalDistributionPanel(parent, distribution, meanType);
        }
        if (type == DistributionType.REAL) {
            return new RealDistributionPanel(parent, distribution, meanType);
        }
        return null;
    }

    public static DistributionPanel create(UiContainer parent, Distribution distribution) {
        return DistributionPanel.create(parent, distribution, 0);
    }

    public static NumericField<Integer> createNumericAvgField(UiContainer parent, final Distribution distribution, Long defaultAvg) {
        final NumericField meanSpinner = NumericField.createIntegerNumericField((UiContainer)parent);
        meanSpinner.setRange((Number)1, (Number)1000);
        meanSpinner.setStepSize((Number)1);
        meanSpinner.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if ((Integer)meanSpinner.getValue() < 0) {
                    meanSpinner.setValue((Number)((int)distribution.getAvgValue()));
                }
            }
        });
        meanSpinner.setValue((Number)(distribution.getAvgValue() == defaultAvg.longValue() ? 1 : (int)distribution.getAvgValue()));
        return meanSpinner;
    }

    public static NumericField<Integer> createNumericDeviationField(UiContainer parent, final Distribution distribution, Long defaultDeviation) {
        final NumericField deviationSpinner = NumericField.createIntegerNumericField((UiContainer)parent);
        deviationSpinner.setRange((Number)0, (Number)1000);
        deviationSpinner.setStepSize((Number)1);
        deviationSpinner.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if ((Integer)deviationSpinner.getValue() < 0) {
                    deviationSpinner.setValue((Number)((int)distribution.getDeviation()));
                }
            }
        });
        deviationSpinner.setValue((Number)(distribution.getDeviation() == defaultDeviation.longValue() ? 0 : (int)distribution.getDeviation()));
        return deviationSpinner;
    }

    public static IntervalField createIntervalAvgField(UiContainer parent, final Distribution distribution) {
        final IntervalField intervalField = IntervalField.createPositiveIntervalField((UiContainer)parent, (IntervalUnit)IntervalUnit.DAYS, (IntervalUnit)IntervalUnit.SECONDS);
        intervalField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (intervalField.getInterval() == null) {
                    intervalField.setInterval(Interval.valueOf(distribution.getAvgValue()));
                }
            }
        });
        intervalField.setInterval(Interval.normalizedValueOf(distribution.getAvgValue()));
        return intervalField;
    }

    public static IntervalField createIntervalDeviationField(UiContainer parent, final Distribution distribution) {
        final IntervalField intervalField = IntervalField.createPositiveIntervalField((UiContainer)parent, (IntervalUnit)IntervalUnit.DAYS, (IntervalUnit)IntervalUnit.SECONDS);
        intervalField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (intervalField.getInterval() == null) {
                    intervalField.setInterval(Interval.valueOf(distribution.getDeviation()));
                }
            }
        });
        intervalField.setInterval(Interval.normalizedValueOf(distribution.getDeviation()));
        return intervalField;
    }

    public AbstractDistribution getDistribution() {
        return (AbstractDistribution)this.distribution;
    }

    public DistributionType getDistributionType() {
        return this.distribution.getType();
    }

    public AbstractDistribution getDistribution(int meanType) {
        return null;
    }
}

