/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.lang.exception.CouldNotDeleteResourceException;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectWriter;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.msg.UIMsg;

public class DeleteSimulationAction
extends DesignerAction {
    private ProjectSimulation projectSimulation;

    public DeleteSimulationAction(ProjectSimulation model) {
        super(UIMsg.MENU_DELETE);
        this.requires(ProjectSimulation.class);
        this.projectSimulation = model;
    }

    @Override
    public boolean doIt() {
        return this.deleteSimulation();
    }

    public void unDoIt() {
    }

    private void closeEditor(ProjectSimulation model) {
        this.getWorkbench().closeEditorForInput(model);
    }

    private boolean deleteSimulation() {
        boolean result = true;
        try {
            Project project = this.projectSimulation.getProject();
            ProjectWriter projectWriter = project.getWriter();
            this.closeEditor(this.projectSimulation);
            project.getSimulations().removeProjectSimulation(this.projectSimulation);
            projectWriter.delete(new ProjectObject[]{this.projectSimulation});
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
        }
        catch (CouldNotDeleteResourceException e) {
            MessageDialog.showError((Msg)e.getMsg());
        }
        return result;
    }
}

