/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.SimulationFlowNodeImpl;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ActivityTabPanel;
import oracle.bpm.designer.simulation.ActivityTabType;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.simulation.CostType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.NumericField;

public class CostTabPanel
extends ActivityTabPanel {
    private ComboBox<CostType> actCostTypeCombo;
    private NumericField<Double> costValueField;
    private boolean isInteractive;
    private Label laneField;

    public CostTabPanel(UiContainer parent, boolean isInteractive) {
        super(parent, ActivityTabType.COST, ActivityTabType.COST.getMessage(), false);
        this.isInteractive = isInteractive;
        this.buildTab();
    }

    @Override
    protected void buildTab() {
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        this.actCostTypeCombo = UiFactory.createComboBox((UiContainer)this, (Object[])CostType.values());
        this.laneField = Label.createWithNoColon((UiContainer)this, (Msg)Msg.QUOTE(""));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.ROLE), "laneLabel");
        this.add((UiComponent)this.laneField, "laneField");
        if (this.isInteractive) {
            this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.ACTIVITY_COST_TYPE), "costTypeLabel");
            this.add((UiComponent)this.actCostTypeCombo, "cost");
        }
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.FIXED_BASE_COST_VALUE), "costLabel");
        this.costValueField = NumericField.createDoubleNumericField((UiContainer)this);
        this.costValueField.setColumns(10);
        this.costValueField.setValue((Number)0.0);
        this.costValueField.setMinimum((Number)0.0);
        this.add((UiComponent)this.costValueField, "costValue");
        layout.addConstraint("laneLabel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("laneLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("laneField", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        layout.addConstraint("laneField", AttributeType.LEFT, (Constraint)new AttributeConstraint("costValue", AttributeType.LEFT));
        String lastComponent = "laneField";
        if (this.isInteractive) {
            layout.addConstraint("costTypeLabel", AttributeType.TOP, (Constraint)new AttributeConstraint(lastComponent, AttributeType.BOTTOM, 5));
            layout.addConstraint("costTypeLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
            layout.addConstraint("cost", AttributeType.TOP, (Constraint)new AttributeConstraint(lastComponent, AttributeType.BOTTOM, 5));
            layout.addConstraint("cost", AttributeType.LEFT, (Constraint)new AttributeConstraint("costValue", AttributeType.LEFT));
            lastComponent = "cost";
        }
        layout.addConstraint("costLabel", AttributeType.TOP, (Constraint)new AttributeConstraint(lastComponent, AttributeType.BOTTOM, 5));
        layout.addConstraint("costLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("costValue", AttributeType.TOP, (Constraint)new AttributeConstraint(lastComponent, AttributeType.BOTTOM, 5));
        layout.addConstraint("costValue", AttributeType.LEFT, (Constraint)new AttributeConstraint("costLabel", AttributeType.RIGHT, 5));
    }

    @Override
    protected void tabToObject(SimulationFlowNodeImpl activity) {
        if (this.isInteractive) {
            activity.setCostType((CostType)this.actCostTypeCombo.getSelectedItem());
        } else {
            activity.setCostType(CostType.FIXED_BASE_COST);
        }
        activity.setCost(((Double)this.costValueField.getValue()).doubleValue());
    }

    @Override
    protected void objectToTab(SimulationFlowNodeImpl activity) {
        this.actCostTypeCombo.setSelectedItem((Object)activity.getActivityCostType());
        this.costValueField.setValue((Number)activity.getCost());
        Lane lane = activity.getFlowNode().getLane();
        this.laneField.setText(lane.getDefaultLabel());
    }
}

