/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.command.CopyProjectSimulationCommand;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationDialogFactory;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.simulation.ProjectSimulation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.action.BaseAction;

public class CopyProjectSimulationAction
extends BaseAction {
    private ProjectSimulation fromSimulation;

    public CopyProjectSimulationAction(ProjectSimulation projectSimulation) {
        super(DesignerMsg.COPY_TO);
        this.requires(ProjectSimulation.class);
        this.fromSimulation = projectSimulation;
    }

    public void run() {
        this.copyProjectSimulation();
    }

    private void copyProjectSimulation() {
        String newSimName = SimulationDialogFactory.showCopySimulationDialog(this.fromSimulation.getProject(), this.getSuggestedName());
        if (newSimName != null) {
            Object projectSimulationCopy = new CopyProjectSimulationCommand(this.fromSimulation, newSimName).execute();
            OpenObjectAction open = new OpenObjectAction(projectSimulationCopy);
            open.doIt();
        }
    }

    private String getSuggestedName() {
        return ModelUtils.nextNameForProjectSimulation((Project)this.fromSimulation.getProject(), (String)(DesignerMsg.COPY_OF + this.fromSimulation.getName()));
    }
}

