/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.command.CopyModelSimulationCommand;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.SimulationDialogFactory;
import oracle.bpm.lang.Str;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.action.BaseAction;

public class CopyModelSimulationAction
extends BaseAction {
    private ModelSimulation modelSimulation;

    public CopyModelSimulationAction(ModelSimulation modelSimulation) {
        super(DesignerMsg.COPY_TO);
        this.requires(ModelSimulation.class);
        this.modelSimulation = modelSimulation;
    }

    public void run() {
        this.copyModelSimulation();
    }

    private void copyModelSimulation() {
        String newSimulationName = SimulationDialogFactory.showCopyModelSimulationDialog(this.modelSimulation.getProcess(), this.getSuggestedName());
        if (!Str.isEmpty(newSimulationName)) {
            Object modelSimulationCopy = new CopyModelSimulationCommand(this.modelSimulation, newSimulationName).execute();
            OpenObjectAction open = new OpenObjectAction(modelSimulationCopy);
            open.doIt();
        }
    }

    private String getSuggestedName() {
        return ModelUtils.nextNameForModelSimulation((Process)this.modelSimulation.getProcess(), (String)(DesignerMsg.COPY_OF.getString() + this.modelSimulation.getName()));
    }
}

