/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.AbstractDistribution;
import fuego.simulation.ConstantDistribution;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.DistributionPanel;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.IntervalUnit;
import oracle.bpm.project.model.simulation.Distribution;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.FocusAdapter;
import oracle.bpm.ui.event.FocusEvent;
import oracle.bpm.ui.event.FocusListener;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.NumericField;

class ConstantDistributionPanel
extends DistributionPanel {
    private UiComponent avg;

    public ConstantDistributionPanel(UiContainer parent, Distribution distrib, int meanType) {
        super(parent, distrib);
        Label avgLabel;
        ConstantDistribution distribution = (ConstantDistribution)distrib;
        RelativeLayout layout = new RelativeLayout();
        this.setLayout((Layout)layout);
        if (meanType == 0) {
            avgLabel = Label.create((UiContainer)this, (Msg)ProjectMsg.PERIOD);
            this.initInterval((UiContainer)this, distribution);
        } else {
            avgLabel = Label.create((UiContainer)this, (Msg)DesignerMsg.VALUE);
            this.initNumeric((UiContainer)this, distribution);
        }
        this.add((UiComponent)avgLabel, "avgIntervalLabel");
        this.add(this.avg, "avg");
        layout.addConstraint("avgIntervalLabel", AttributeType.VERTICAL_CENTER, (Constraint)new AttributeConstraint("avg", AttributeType.VERTICAL_CENTER));
        layout.addConstraint("avgIntervalLabel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT));
        layout.addConstraint("avg", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP));
        layout.addConstraint("avg", AttributeType.LEFT, (Constraint)new AttributeConstraint("avgIntervalLabel", AttributeType.RIGHT, 5));
    }

    @Override
    public AbstractDistribution getDistribution() {
        return this.getDistribution(0);
    }

    @Override
    public AbstractDistribution getDistribution(int meanType) {
        if (meanType == 0) {
            return this.getDistributionFromInterval();
        }
        return this.getDistributionFromNumber();
    }

    @Override
    public void setDistribution(Distribution distribution, int meanType) {
        if (meanType == 0) {
            ((IntervalField)this.avg).setInterval(Interval.normalizedValueOf(distribution.getAvgValue()));
        } else {
            ((NumericField)this.avg).setValue((Number)((int)distribution.getAvgValue()));
        }
    }

    private AbstractDistribution getDistributionFromInterval() {
        if (((IntervalField)this.avg).getInterval() == null) {
            return ConstantDistribution.create();
        }
        return ConstantDistribution.create((long)((IntervalField)this.avg).getInterval().getTotalMicroseconds());
    }

    private AbstractDistribution getDistributionFromNumber() {
        NumericField numericSpinner = (NumericField)this.avg;
        if ((Integer)numericSpinner.getValue() < 0) {
            return ConstantDistribution.create();
        }
        return ConstantDistribution.create((long)((Integer)numericSpinner.getValue()).intValue());
    }

    private void initInterval(UiContainer parent, final ConstantDistribution distribution) {
        final IntervalField intervalField = IntervalField.createPositiveIntervalField((UiContainer)parent, (IntervalUnit)IntervalUnit.DAYS, (IntervalUnit)IntervalUnit.SECONDS);
        this.avg = intervalField;
        intervalField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (intervalField.getInterval() == null) {
                    intervalField.setInterval(Interval.normalizedValueOf(distribution.getAvgValue()));
                }
            }
        });
        intervalField.setInterval(Interval.normalizedValueOf(distribution.getAvgValue()));
    }

    private void initNumeric(UiContainer parent, final ConstantDistribution distribution) {
        final NumericField numericSpinner = NumericField.createIntegerNumericField((UiContainer)parent);
        this.avg = numericSpinner;
        numericSpinner.setRange((Number)1, (Number)1000);
        numericSpinner.setStepSize((Number)1);
        numericSpinner.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if ((Integer)numericSpinner.getValue() < 0) {
                    numericSpinner.setValue((Number)((int)distribution.getAvgValue()));
                }
            }
        });
        numericSpinner.setValue((Number)(distribution.getAvgValue() == 30000000L ? 1 : (int)distribution.getAvgValue()));
    }
}

