/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.StudioSimulationUtils;
import oracle.bpm.designer.Context;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.ActivityController;
import oracle.bpm.designer.controller.ControllerUtils;
import oracle.bpm.designer.controller.NodeContainerController;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.simulation.ActivitySimulationPropertiesPanel;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TreePanel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.AttributeConstraint;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Constraint;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;

public class ActivitySimulationInfoDialog
extends OkCancelDialog {
    private FlowNode node_d;
    private ActivitySimulationPropertiesPanel simPanel;
    public static ActivitySimulationInfoDialog instance;

    public ActivitySimulationInfoDialog(UiWindow parent, FlowNode act) {
        super(parent);
        this.node_d = act;
        this.setTitle(ProjectMsg.ACTIVITY.getString() + ": " + act.getLabelMap());
        this.build();
    }

    public void cancel() {
        super.cancel();
    }

    public void ok() {
        this.simPanel.panelToObject();
        Process content = this.node_d.getProcess();
        this.close();
    }

    private void build() {
        TreePanel treePanel = this.createTreePanel(this.getContentPane());
        final TreePanel.Sheet root = treePanel.getRoot();
        RelativeLayout containerLayout = new RelativeLayout();
        Panel container = new Panel(treePanel.createParent());
        container.setLayout((Layout)containerLayout);
        this.simPanel = new ActivitySimulationPropertiesPanel((UiContainer)container, this, this.node_d, (SimulationFlowNode)this.getActivityController(this.node_d).getSimulationInfo(), null, StudioSimulationUtils.getRunningSimulation((Process)this.node_d.getProcess()).getProcessModel(this.node_d.getProcess()));
        this.simPanel.objectToPanel();
        container.add((UiComponent)this.simPanel, (Object)"simPanel");
        this.layoutComponents(containerLayout);
        TreePanel.Sheet generalSheet = new TreePanel.Sheet(root, DesignerMsg.SIMULATION, (UiComponent)container);
        root.addSheet(generalSheet);
        this.getContentPane().add((UiComponent)treePanel, (Object)"Center");
        this.setSize(500, 400);
        this.setLocationRelativeTo((UiComponent)Ui.getRoot());
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                root.getFirstChild().select();
            }
        };
        UiUtilities.invokeLater((Runnable)runnable);
    }

    private TreePanel createTreePanel(UiContainer parent) {
        return new TreePanel(parent);
    }

    private void layoutComponents(RelativeLayout containerLayout) {
        containerLayout.addConstraint("simPanel", AttributeType.TOP, (Constraint)new AttributeConstraint("_container", AttributeType.TOP, 5));
        containerLayout.addConstraint("simPanel", AttributeType.LEFT, (Constraint)new AttributeConstraint("_container", AttributeType.LEFT, 5));
        containerLayout.addConstraint("simPanel", AttributeType.RIGHT, (Constraint)new AttributeConstraint("_container", AttributeType.RIGHT, -5));
        containerLayout.addConstraint("simPanel", AttributeType.BOTTOM, (Constraint)new AttributeConstraint("_container", AttributeType.BOTTOM, -5));
    }

    private ActivityController getActivityController(FlowNode node) {
        ProcessDomain domain = Context.getDomainFor(node.getProcess());
        NodeContainerController<?> container = ControllerUtils.getNodeContainerControllerFor(domain.getCanvas().getProcessController(), (FlowElement)node);
        return (ActivityController)container.asController((FlowElement)node);
    }
}

