/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.simulation;

import fuego.simulation.Simulation;
import fuego.simulation.SimulationFlowNodeImpl;
import fuego.simulation.StudioSimulationUtils;
import java.io.Serializable;
import oracle.bpm.bamdata.ActivityInfo;
import oracle.bpm.bamdata.ProcessInfo;
import oracle.bpm.designer.ActivitySimulationInterface;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.FlowNodeController;
import oracle.bpm.designer.simulation.SimulationRunTimeResourcePanel;
import oracle.bpm.diagram.draw.DiagramContext;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Point;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.Subprocess;
import oracle.bpm.project.model.simulation.ModelSimulation;
import oracle.bpm.project.model.simulation.SimulationFlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class ActivitySimulationDelegated
implements ActivitySimulationInterface,
Serializable {
    private FlowNodeController controller;
    private Button lessCapacityButton;
    private int maxQueue = 0;
    private Button moreCapacityButton;
    private int numberInProcess;
    private int queueSize;
    private Button resourcePanelButton;
    private transient SimulationRunTimeResourcePanel simulationRunTimeResourcePanel;
    private int totalNumberProcessed;
    private static final long serialVersionUID = 7129733331833624258L;
    private static Image PLUS_IMAGE = Image.create((Msg)UIMsg.TREE_PLUS);

    public ActivitySimulationDelegated(FlowNodeController controller) {
        this.controller = controller;
    }

    @Override
    public FlowNode getActivity() {
        return this.getFlowNode();
    }

    @Override
    public SimulationFlowNodeImpl getSimulationInfo() {
        String activityId = this.controller.getModelObject().getId();
        SimulationFlowNode simulationActivity = this.getSimulationModel().findSimulationFlowNode(activityId);
        if (simulationActivity == null) {
            simulationActivity = this.getSimulationModel().createSimulationFlowNode(activityId);
            try {
                this.getSimulationModel().addSimulationFlowNode(simulationActivity);
            }
            catch (ProjectException e) {
                e.printStackTrace();
            }
        }
        return (SimulationFlowNodeImpl)simulationActivity;
    }

    @Override
    public void drawSimulation(Graphics g) {
        DrawContext context = this.getDomain().getContext();
        Point location = this.getLocation();
        DrawableFlowElement drawable = this.controller.getDrawableObject();
        Point offset = drawable.getContainer().getAbsoluteOffset();
        int x = location.getX() + offset.getX();
        int y = location.getY() + offset.getY();
        int xPos = context.scale(x);
        int yPos = context.scale(y - drawable.getHeight() / 2);
        this.drawSimulation(g, xPos, yPos);
    }

    @Override
    public void resetSimulation() {
        this.numberInProcess = 0;
        this.queueSize = 0;
        this.maxQueue = 0;
        this.totalNumberProcessed = 0;
        this.removeFromSimulation((UiComponent)this.moreCapacityButton);
        this.removeFromSimulation((UiComponent)this.lessCapacityButton);
        if (this.resourcePanelButton != null) {
            this.resourcePanelButton.setVisible(false);
            this.resourcePanelButton = null;
        }
        if (this.simulationRunTimeResourcePanel != null) {
            this.simulationRunTimeResourcePanel.setVisible(false);
            this.simulationRunTimeResourcePanel = null;
        }
    }

    @Override
    public void updateSimulationValues() {
        if (this.getSimulation() != null) {
            this.numberInProcess = this.getRuntimeInfo().getRunningInfo().getCurrentWorkCount();
            this.queueSize = this.getRuntimeInfo().getRunningInfo().getQueueCount();
            this.totalNumberProcessed = this.getRuntimeInfo().getRunningInfo().getOperationsCompletedCount();
            if (this.simulationRunTimeResourcePanel != null && !this.simulationRunTimeResourcePanel.isDisposed() && this.simulationRunTimeResourcePanel.isVisible()) {
                this.simulationRunTimeResourcePanel.update();
            }
        }
    }

    protected void drawSimulation(Graphics g, int inProcessRectX, int inProcessRectY) {
        DrawContext context = this.getDomain().getContext();
        int rectWidth = context.scale(18);
        int rectHeight = context.scale(25);
        Rectangle bounds = this.getScaledBounds((DiagramContext)context);
        int distance = context.scale(2);
        inProcessRectY -= rectHeight + context.scale(2);
        Point position = bounds.getOrigin().translate(bounds.getWidth() / 2 + distance, -distance);
        if (!this.getDomain().isShowAnimation()) {
            if (this.moreCapacityButton != null) {
                this.moreCapacityButton.setVisible(false);
            }
            if (this.lessCapacityButton != null) {
                this.lessCapacityButton.setVisible(false);
            }
            if (this.resourcePanelButton != null) {
                this.resourcePanelButton.setVisible(false);
            }
            if (this.simulationRunTimeResourcePanel != null) {
                this.simulationRunTimeResourcePanel.setVisible(false);
            }
            return;
        }
        if (this.getSimulationModel() == null) {
            return;
        }
        if (ModelUtils.isStartEvent((FlowNode)this.getFlowNode())) {
            if (this.getSimulationModel().getUseMaxInstances() && this.totalNumberProcessed > 0) {
                g.drawString(String.valueOf(this.getSimulationModel().getMaxInstances() - this.totalNumberProcessed + "/" + this.getSimulationModel().getMaxInstances()), position.getX(), position.getY());
            }
            return;
        }
        if (ModelUtils.isEndEvent((FlowNode)this.getFlowNode()) && this.getSimulationModel().getUseMaxInstances()) {
            g.drawString(String.valueOf(this.totalNumberProcessed + this.numberInProcess) + "/" + this.getSimulationModel().getMaxInstances(), position.getX(), position.getY());
            return;
        }
        if (!this.drawSimulationBar()) {
            return;
        }
        int iconHeight = PLUS_IMAGE.getIconHeight();
        Font f = g.getFont();
        g.setFont(f.scale(0.8f * context.getScale()));
        int capacity = this.getSimulationInfo().getCapacity();
        int ocupationPerc = this.numberInProcess >= capacity ? 100 : this.numberInProcess * 100 / capacity;
        Rectangle numberInProcessRectangle = new Rectangle(inProcessRectX, inProcessRectY, rectWidth, rectHeight);
        g.draw(numberInProcessRectangle);
        int fillHeight = ocupationPerc * rectHeight / 100;
        Rectangle numberInProcessFillRectangle = new Rectangle(inProcessRectX + 1, inProcessRectY + 1 + rectHeight - fillHeight, rectWidth - 2, fillHeight - 2);
        g.setForeground(Color.GREEN);
        g.draw(numberInProcessFillRectangle);
        g.fill(numberInProcessFillRectangle);
        g.setForeground(Color.BLACK);
        g.drawString(String.valueOf(this.numberInProcess), inProcessRectX + 2, inProcessRectY + rectHeight - 5);
        if (this.drawSimulationControls()) {
            g.drawString(String.valueOf(capacity), inProcessRectX + 1, inProcessRectY - 3);
        }
        if (this.moreCapacityButton == null) {
            this.moreCapacityButton = this.createMoreCapacityButton((UiContainer)this.getCanvas());
        }
        if (this.lessCapacityButton == null) {
            this.lessCapacityButton = this.createLessCapacityButton((UiContainer)this.getCanvas());
        }
        if (this.drawSimulationControls()) {
            this.moreCapacityButton.setVisible(true);
            this.lessCapacityButton.setVisible(true);
            Rectangle more = new Rectangle(numberInProcessRectangle.getX() + numberInProcessRectangle.getWidth() + 2, numberInProcessRectangle.getY() + (numberInProcessRectangle.getHeight() - iconHeight * 2) / 2, this.moreCapacityButton.getIcon().getIconWidth(), this.moreCapacityButton.getIcon().getIconHeight());
            this.moreCapacityButton.setBounds(more);
            Rectangle less = new Rectangle(numberInProcessRectangle.getX() + numberInProcessRectangle.getWidth() + 2, this.moreCapacityButton.getLocation().getY() + iconHeight + 2, this.lessCapacityButton.getIcon().getIconWidth(), this.lessCapacityButton.getIcon().getIconHeight());
            this.lessCapacityButton.setBounds(less);
        } else {
            this.moreCapacityButton.setVisible(false);
            this.lessCapacityButton.setVisible(false);
        }
        int queueRectX = inProcessRectX - rectWidth - 2;
        if (this.queueSize > 0) {
            if (this.queueSize > this.maxQueue) {
                this.maxQueue = this.queueSize;
            }
            capacity = this.maxQueue;
            int queuePerc = this.queueSize * 100 / capacity;
            Rectangle queueRectangle = new Rectangle(queueRectX, inProcessRectY, rectWidth, rectHeight);
            g.draw(queueRectangle);
            fillHeight = queuePerc * rectHeight / 100;
            Rectangle fillRect = new Rectangle(queueRectX + 1, inProcessRectY + 1 + rectHeight - fillHeight, rectWidth - 2, fillHeight - 2);
            Color color = this.queueSize <= this.getSimulationInfo().getQueueWarningLevel() ? Color.YELLOW : Color.RED;
            g.setForeground(color);
            g.draw(fillRect);
            g.fill(fillRect);
            g.setForeground(Color.BLACK);
            g.drawString(String.valueOf(this.queueSize), queueRectX + 2, inProcessRectY + rectHeight - 5);
            g.drawString(String.valueOf(capacity), queueRectX + 1, inProcessRectY - 3);
        }
        g.setFont(f);
        this.drawRunTimeResourcePanel();
    }

    private Point getLocation() {
        return this.controller.getDrawableObject().getLocation();
    }

    private Rectangle getScaledBounds(@NotNull DiagramContext context) {
        return context.scale(this.controller.getDrawableObject().getBounds());
    }

    private PaintCanvas getCanvas() {
        return this.getDomain().getCanvas();
    }

    private ProcessDomain getDomain() {
        return this.controller.getDomain();
    }

    private FlowNode getFlowNode() {
        return this.controller.getModelObject();
    }

    private void removeFromSimulation(UiComponent component) {
        if (component != null) {
            component.setVisible(false);
        }
    }

    private Process getContent() {
        return this.controller.getModelObject().getProcess();
    }

    private Button createLessCapacityButton(UiContainer parent) {
        Image image = Image.create((Msg)UIMsg.TREE_MINUS);
        Button button = new Button(parent, image);
        parent.add((UiComponent)button);
        parent.revalidate();
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimulationFlowNodeImpl simulationActivityImpl = ActivitySimulationDelegated.this.getSimulationInfo();
                if (simulationActivityImpl != null && simulationActivityImpl.getCapacity() > 1) {
                    simulationActivityImpl.setCapacity(simulationActivityImpl.getCapacity() - 1);
                }
            }
        });
        return button;
    }

    private Button createMoreCapacityButton(UiContainer parent) {
        Image image = Image.create((Msg)UIMsg.TREE_PLUS);
        Button button = new Button(parent, image);
        parent.add((UiComponent)button);
        parent.revalidate();
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SimulationFlowNodeImpl simulationActivityImpl = ActivitySimulationDelegated.this.getSimulationInfo();
                if (simulationActivityImpl != null && simulationActivityImpl.getCapacity() < 10000) {
                    simulationActivityImpl.setCapacity(simulationActivityImpl.getCapacity() + 1);
                }
            }
        });
        return button;
    }

    private Subprocess getParentScope() {
        return this.controller.getModelObject().getSubprocess();
    }

    private ActivityInfo getRuntimeInfo() {
        ProcessInfo processRuntimeInfo = this.getSimulation().getProcessRuntimeInfo(this.getContent().getId());
        return (ActivityInfo)processRuntimeInfo.getActivity(this.controller.getModelObject().getId());
    }

    private Simulation getSimulation() {
        return StudioSimulationUtils.getRunningSimulation((Process)this.getContent());
    }

    private ModelSimulation getSimulationModel() {
        Simulation runningSimulation = StudioSimulationUtils.getRunningSimulation((Process)this.getContent());
        if (runningSimulation != null) {
            return runningSimulation.getProcessModel(this.getContent());
        }
        return null;
    }

    private void drawRunTimeResourcePanel() {
        if (ModelUtils.isAnyInteractive((FlowNode)this.getFlowNode())) {
            // empty if block
        }
    }

    private boolean drawSimulationBar() {
        return this.getParentScope() == null && !ModelUtils.isBoundaryEvent((FlowNode)this.getFlowNode());
    }

    private boolean drawSimulationControls() {
        if (this.getSimulationInfo().getUseOrgResources() || !ModelUtils.isAnyInteractive((FlowNode)this.getFlowNode())) {
            return false;
        }
        if (ModelUtils.isSubprocess((FlowNode)this.getFlowNode())) {
            return !this.getSimulationInfo().getInnerSimulation();
        }
        return this.getParentScope() == null;
    }
}

