/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.serviceproperties;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.FabricService;
import oracle.bpm.designer.StudioWorkbench;
import oracle.bpm.designer.expression.ExpressionPanel;
import oracle.bpm.designer.expression.ExpressionPanelFactory;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Str;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.processes.serviceproperties.ServiceProperty;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiFactory;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ServicePropertyDialog
extends OkCancelDialog {
    private ExpressionPanel expressionPanel;
    private ComboBox<String> nameComboBox;
    private ServiceProperty property;
    private ServicePropertySet servicePropertySet;
    private Sequence<ServiceProperty> usedProperties;

    public ServicePropertyDialog(@NotNull UiWindow parent, ServiceProperty property, @NotNull Sequence<ServiceProperty> usedProperties, @NotNull ServicePropertySet servicePropertySet) {
        super(parent, property == null ? ProjectUiMsg.CREATE((Msg)DesignerMsg.SERVICE_PROPERTY) : ProjectUiMsg.EDIT((Msg)DesignerMsg.SERVICE_PROPERTY));
        this.property = property;
        this.usedProperties = usedProperties;
        this.servicePropertySet = servicePropertySet;
        this.init();
    }

    public ServiceProperty getServiceProperty() {
        return this.property;
    }

    public void ok() {
        Msg errorMessage = this.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        String name = this.nameComboBox.getText();
        Expression expression = this.expressionPanel.getExpression();
        if (this.property == null) {
            this.property = this.servicePropertySet.createServiceProperty(name, expression);
        } else {
            this.property.setName(name);
            this.property.setExpression(expression);
        }
        this.close();
    }

    private void init() {
        UiContainer contentPane = this.getContentPane();
        contentPane.setLayout((Layout)new MigLayout("ins 10, gap 5, fill"));
        contentPane.add((UiComponent)Label.createWithNoColon((UiContainer)this, (Msg)DesignerMsg.SERVICE_PROPERTY_HINT), (Object)"wrap");
        Panel namePanel = new Panel(contentPane);
        namePanel.setLayout((Layout)new MigLayout("ins 0, gap 5, fillx"));
        namePanel.add((UiComponent)Label.create((UiContainer)namePanel, (Msg)DesignerMsg.NAME));
        this.nameComboBox = UiFactory.createComboBox((UiContainer)namePanel, (boolean)true);
        namePanel.add(this.nameComboBox);
        contentPane.add((UiComponent)namePanel, (Object)"wrap");
        this.expressionPanel = ExpressionPanelFactory.createDefaultMultiLinePanel(contentPane, this.createExpressionContext());
        contentPane.add(this.expressionPanel.getUiComponent(), (Object)"grow");
        StudioWorkbench workbench = AbstractStudioWorkbench.getInstance();
        FabricService service = workbench.getFabricService();
        if (service != null) {
            for (String serviceProperty : service.getServiceProperties()) {
                this.nameComboBox.addItem((Object)serviceProperty);
            }
        }
        if (this.property != null) {
            this.nameComboBox.setText(this.property.getName());
            this.expressionPanel.setExpression(this.property.getExpression());
        }
        this.setSize(450, 300);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private ExpressionContext createExpressionContext() {
        boolean isInput = this.servicePropertySet.isInputServicePropertySet();
        return new ExpressionContext(this.servicePropertySet.getContext(), ServiceProperty.ResultType.get(), !isInput);
    }

    private Msg validateInput() {
        String name = this.nameComboBox.getText().trim();
        if (Str.isEmpty(name)) {
            return DesignerMsg.SERVICE_PROPERTY_NAME_IS_NULL;
        }
        if ((this.property == null || !name.equals(this.property.getName())) && this.servicePropertyExists(this.usedProperties, name)) {
            return DesignerMsg.SERVICE_PROPERTY_ALREADY_DEFINED(name);
        }
        Expression expression = this.expressionPanel.getExpression();
        if (expression == null || !ExpressionHelper.isExpressionValid((Expression)expression, (ExpressionContext)this.createExpressionContext())) {
            return DesignerMsg.INVALID_EXPRESSION;
        }
        return null;
    }

    private boolean servicePropertyExists(@NotNull Sequence<ServiceProperty> serviceProperties, @NotNull String name) {
        for (ServiceProperty serviceProperty : serviceProperties) {
            if (!serviceProperty.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

