/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.serviceproperties;

import oracle.bpm.collections.lists.MsgList;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.Expression;
import oracle.bpm.project.compile.ExpressionContext;
import oracle.bpm.project.compile.process.ExpressionHelper;
import oracle.bpm.project.model.processes.serviceproperties.ServiceProperty;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.ui.table.ProviderTableModel;
import org.jetbrains.annotations.NotNull;

public class ServicePropertiesTableModel
extends ProviderTableModel<ServiceProperty> {
    private ServicePropertySet servicePropertySet;
    private static final MsgList titles = MsgList.create(DesignerMsg.NAME, DesignerMsg.EXPRESSION);

    public ServicePropertiesTableModel(@NotNull ServicePropertySet servicePropertySet) {
        super(titles);
        this.servicePropertySet = servicePropertySet;
        for (ServiceProperty serviceProperty : servicePropertySet.getServiceProperties()) {
            ServiceProperty servicePropertyCopy = servicePropertySet.createServiceProperty(serviceProperty.getName(), serviceProperty.getExpression());
            this.addRow(servicePropertyCopy);
        }
    }

    public ServicePropertySet getServicePropertySet() {
        return this.servicePropertySet;
    }

    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Object getValueAt(int row, int column) {
        ServiceProperty property = (ServiceProperty)this.getRow(row);
        switch (column) {
            case 0: {
                return property.getName();
            }
            case 1: {
                return property.getExpression() != null ? ExpressionHelper.getText((Expression)property.getExpression(), (ExpressionContext)this.createExpressionContext()) : "";
            }
        }
        return "";
    }

    public boolean isExpressionValid(int row) {
        ServiceProperty property = (ServiceProperty)this.getRow(row);
        return ExpressionHelper.isExpressionValid((Expression)property.getExpression(), (ExpressionContext)this.createExpressionContext());
    }

    public boolean isModelValid() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            if (this.isRowValid(row)) continue;
            return false;
        }
        return true;
    }

    public boolean isRowValid(int row) {
        return this.isExpressionValid(row);
    }

    private ExpressionContext createExpressionContext() {
        boolean isInput = this.servicePropertySet.isInputServicePropertySet();
        return new ExpressionContext(this.servicePropertySet.getContext(), ServiceProperty.ResultType.get(), !isInput);
    }
}

