/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.serviceproperties;

import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.serviceproperties.ServicePropertiesTableModel;
import oracle.bpm.designer.serviceproperties.ServicePropertyDialog;
import oracle.bpm.draw.Color;
import oracle.bpm.project.model.processes.serviceproperties.ServiceProperty;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.ColorProvider;
import oracle.bpm.ui.TableColorProvider;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.table.BaseTablePanel;
import oracle.bpm.ui.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ServicePropertiesTable
extends BaseTablePanel {
    private ServicePropertiesTable(@NotNull UiContainer parent, @NotNull ServicePropertiesTableModel model) {
        super(parent, Msg.QUOTE(""), DesignerMsg.SERVICE_PROPERTIES, (TableModel)model, BaseTablePanel.Style.TOOLBAR_TOP);
        this.setWithColons(true);
        this.init();
    }

    public static ServicePropertiesTable create(@NotNull UiContainer parent, @NotNull ServicePropertySet servicePropertySet) {
        ServicePropertiesTableModel model = new ServicePropertiesTableModel(servicePropertySet);
        return new ServicePropertiesTable(parent, model);
    }

    public Sequence<ServiceProperty> getServiceProperties() {
        return CollectionUtils.asSequence(this.getModel().getData());
    }

    protected boolean showEditAction() {
        return true;
    }

    protected void addAction() {
        Sequence<ServiceProperty> usedProperties = CollectionUtils.asSequence(this.getModel().getData());
        ServicePropertyDialog dialog = new ServicePropertyDialog(this.getOwnerWindow(), null, usedProperties, this.getModel().getServicePropertySet());
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            ServiceProperty property = dialog.getServiceProperty();
            this.getModel().addRow(property);
        }
    }

    protected void editAction() {
        Sequence<ServiceProperty> usedProperties = CollectionUtils.asSequence(this.getModel().getData());
        ServiceProperty property = (ServiceProperty)this.getModel().getRow(this.getTable().getSelectedRow());
        ServicePropertyDialog dialog = new ServicePropertyDialog(this.getOwnerWindow(), property, usedProperties, this.getModel().getServicePropertySet());
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            this.getModel().fireTableDataChanged();
        }
    }

    protected ServicePropertiesTableModel getModel() {
        return (ServicePropertiesTableModel)super.getModel();
    }

    private void init() {
        this.getTable().getColumn(1).setColorProvider((ColorProvider)new TableColorProvider.Default(){

            public Color getForeground(Object element) {
                return !ServicePropertiesTable.this.getModel().isExpressionValid(this.getRow()) ? Color.RED : null;
            }
        });
    }
}

