/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.serviceproperties;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.serviceproperties.ServicePropertiesTable;
import oracle.bpm.designer.serviceproperties.ServicePropertiesTableModel;
import oracle.bpm.project.model.processes.serviceproperties.InputServicePropertiesEnabled;
import oracle.bpm.project.model.processes.serviceproperties.OutputServicePropertiesEnabled;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import oracle.bpm.project.model.processes.serviceproperties.ServiceProperty;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertySet;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ServicePropertiesPanel
extends Panel {
    private ServicePropertySet inputServicePropertySet;
    private ServicePropertiesTable inputsTable;
    private ServicePropertySet outputServicePropertySet;
    private ServicePropertiesTable outputsTable;

    public ServicePropertiesPanel(@NotNull UiContainer parent, ServicePropertiesEnabled servicePropertiesEnabled) {
        super(parent);
        this.inputServicePropertySet = servicePropertiesEnabled.isInputServicePropertiesEnabled() ? ((InputServicePropertiesEnabled)servicePropertiesEnabled.asAnyNode(InputServicePropertiesEnabled.class)).getInputServicePropertySet() : null;
        this.outputServicePropertySet = servicePropertiesEnabled.isOutputServicePropertiesEnabled() ? ((OutputServicePropertiesEnabled)servicePropertiesEnabled.asAnyNode(OutputServicePropertiesEnabled.class)).getOutputServicePropertySet() : null;
        this.init();
    }

    public void applyChanges() {
        if (this.inputServicePropertySet != null) {
            this.inputServicePropertySet.clearServiceProperties();
            for (ServiceProperty serviceProperty : this.inputsTable.getServiceProperties()) {
                this.inputServicePropertySet.addServiceProperty(serviceProperty);
            }
        }
        if (this.outputServicePropertySet != null) {
            this.outputServicePropertySet.clearServiceProperties();
            for (ServiceProperty serviceProperty : this.outputsTable.getServiceProperties()) {
                this.outputServicePropertySet.addServiceProperty(serviceProperty);
            }
        }
    }

    public Msg validateInput() {
        ServicePropertiesTableModel tableModel;
        if (this.inputsTable != null && !(tableModel = this.inputsTable.getModel()).isModelValid()) {
            return DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(DesignerMsg.SERVICE_PROPERTY);
        }
        if (this.outputsTable != null && !(tableModel = this.outputsTable.getModel()).isModelValid()) {
            return DesignerMsg.DYNAMIC_ONE_OR_MORE_INVALID(DesignerMsg.SERVICE_PROPERTY);
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        if (this.inputsTable != null) {
            this.inputsTable.setEnabled(enabled);
        }
        if (this.outputsTable != null) {
            this.outputsTable.setEnabled(enabled);
        }
    }

    private void init() {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        UiContainer container = this.inputServicePropertySet != null && this.outputServicePropertySet != null ? this.buildTabbedPane((UiContainer)this) : this.buildPanel((UiContainer)this);
        this.add((UiComponent)container, "grow");
        if (this.inputServicePropertySet != null) {
            this.inputsTable = ServicePropertiesTable.create(container, this.inputServicePropertySet);
            this.addTable(container, this.inputsTable, DesignerMsg.INPUT);
        }
        if (this.outputServicePropertySet != null) {
            this.outputsTable = ServicePropertiesTable.create(container, this.outputServicePropertySet);
            this.addTable(container, this.outputsTable, DesignerMsg.OUTPUT);
        }
    }

    private void addTable(@NotNull UiContainer container, @NotNull ServicePropertiesTable table, @NotNull Msg title) {
        if (container instanceof TabbedPane) {
            TabbedPane tabbedPane = (TabbedPane)container;
            tabbedPane.addTab(title, (UiComponent)table);
        } else {
            container.add((UiComponent)table, (Object)"grow");
        }
    }

    private UiContainer buildTabbedPane(@NotNull UiContainer parent) {
        return new TabbedPane(parent);
    }

    private UiContainer buildPanel(@NotNull UiContainer parent) {
        Panel result = new Panel(parent);
        result.setLayout((Layout)new MigLayout("ins 0, gap 0, fill"));
        return result;
    }
}

