/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.serviceproperties;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.serviceproperties.ServicePropertiesPanel;
import oracle.bpm.project.model.processes.serviceproperties.ServicePropertiesEnabled;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public class ServicePropertiesDialog
extends OkCancelDialog {
    private ServicePropertiesEnabled servicePropertiesEnabled;
    private ServicePropertiesPanel servicePropertiesPanel;

    public ServicePropertiesDialog(@NotNull UiWindow parent, @NotNull ServicePropertiesEnabled servicePropertiesEnabled) {
        super(parent, DesignerMsg.SERVICE_PROPERTIES);
        this.servicePropertiesEnabled = servicePropertiesEnabled;
        this.init();
    }

    public void ok() {
        Msg errorMessage = this.servicePropertiesPanel.validateInput();
        if (errorMessage != null) {
            MessageDialog.showError((Msg)errorMessage);
            return;
        }
        if (this.servicePropertiesPanel != null) {
            this.servicePropertiesPanel.applyChanges();
        }
        this.close();
    }

    private void init() {
        UiContainer panel = this.getContentPane();
        panel.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        this.servicePropertiesPanel = new ServicePropertiesPanel(panel, this.servicePropertiesEnabled);
        panel.add((UiComponent)this.servicePropertiesPanel, (Object)"grow");
        this.setSize(500, 300);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

