/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.selectorpanel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.selectorpanel.AbstractSelectorPanel;
import oracle.bpm.designer.selectorpanel.SelectorComponent;
import oracle.bpm.designer.selectorpanel.SelectorListener;
import oracle.bpm.designer.selectorpanel.VetoableSelectorChangeEvent;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.event.ItemEvent;
import oracle.bpm.ui.event.ItemListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public abstract class RadioButtonSelectorPanel<S>
extends AbstractSelectorPanel<S> {
    RadioButtonSelector<S> radioButtonSelector;

    public RadioButtonSelectorPanel(@NotNull UiContainer parent, Msg title) {
        this(parent, title, 0);
    }

    public RadioButtonSelectorPanel(@NotNull UiContainer parent, Msg title, int insets) {
        super(parent, title, null, insets);
    }

    @Override
    protected SelectorComponent<S> createOptionsComponent(@NotNull UiContainer container) {
        if (this.radioButtonSelector == null) {
            this.radioButtonSelector = new RadioButtonSelector(container);
        }
        return this.radioButtonSelector;
    }

    private static class RadioButtonSelector<T>
    extends Panel
    implements SelectorComponent<T> {
        private T currentSelection;
        private boolean isEnabled = true;
        private ArrayList<SelectorListener<T>> listeners = new ArrayList();
        private ButtonGroup<RadioButton<T>> selectionGroup = new ButtonGroup();
        private Map<T, RadioButton<T>> selectionRadios = new HashMap<T, RadioButton<T>>();

        protected RadioButtonSelector(@NotNull UiContainer parent) {
            super(parent);
            this.init();
        }

        @Override
        public void addSelectorListener(@NotNull SelectorListener<T> listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeSelectorListener(@NotNull SelectorListener<T> listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void addOption(@NotNull T item) {
            String label = item instanceof I18nProvider ? ((I18nProvider)item).getString(Locale.getDefault()) : item.toString();
            RadioButton radioButton = new RadioButton((UiContainer)this, label);
            radioButton.setItem(item);
            this.selectionGroup.add((AbstractButton)radioButton);
            this.selectionRadios.put(item, radioButton);
            this.add((UiComponent)radioButton, "gapright 5");
            radioButton.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    Object newItem = ((RadioButton)RadioButtonSelector.this.selectionGroup.getSelection()).getItem();
                    if (RadioButtonSelector.this.currentSelection != newItem) {
                        if (!RadioButtonSelector.this.fireSelectionChanging(newItem)) {
                            RadioButtonSelector.this.setSelectedOption(RadioButtonSelector.this.currentSelection);
                        } else {
                            RadioButtonSelector.this.currentSelection = newItem;
                            RadioButtonSelector.this.fireSelectionChanged();
                        }
                    }
                }
            });
            radioButton.setEnabled(this.isEnabled);
        }

        @Override
        public void setSelectedOption(@NotNull T selectedOption) {
            RadioButton<T> radio = this.selectionRadios.get(selectedOption);
            if (radio != null) {
                this.selectionGroup.setSelected(radio, true);
            }
        }

        @Override
        public Sequence<T> getOptions() {
            return CollectionUtils.asSequence(this.selectionRadios.keySet());
        }

        @Override
        public T getSelectedOption() {
            return this.currentSelection;
        }

        @Override
        public UiComponent getUiComponent() {
            return this;
        }

        @Override
        public boolean isValidSelection() {
            return true;
        }

        @Override
        public void setSelectorEnabled(boolean enabled) {
            for (RadioButton<T> radio : this.selectionRadios.values()) {
                radio.setEnabled(enabled);
            }
            this.isEnabled = enabled;
        }

        @Override
        public void setSelectorVisible(boolean visible) {
            this.setVisible(visible);
        }

        private void init() {
            this.setLayout((Layout)new MigLayout("ins 0, gap 0, hidemode 3"));
        }

        private boolean fireSelectionChanging(T newValue) {
            boolean result = true;
            VetoableSelectorChangeEvent<T> event = new VetoableSelectorChangeEvent<T>(this, newValue);
            for (SelectorListener<T> listener : this.listeners) {
                result &= listener.selectionChanging(event);
            }
            return result;
        }

        private void fireSelectionChanged() {
            for (SelectorListener<T> listener : this.listeners) {
                listener.selectionChanged();
            }
        }
    }
}

