/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.selectorpanel;

import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.selectorpanel.SelectorComponent;
import oracle.bpm.designer.selectorpanel.SelectorListener;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.Border;
import oracle.bpm.ui.border.TitledBorder;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSelectorPanel<S>
extends Panel {
    private Panel innerPanel;
    private Msg label;
    private SelectorComponent<S> selectorComponent;

    public AbstractSelectorPanel(@NotNull UiContainer parent, Msg title, Msg selectorLabel, int insets) {
        super(parent);
        this.label = selectorLabel;
        this.init(title, insets);
    }

    public void requestFocus() {
        this.selectorComponent.requestFocus();
    }

    public void addSelectorListener(@NotNull SelectorListener<S> listener) {
        this.selectorComponent.addSelectorListener(listener);
    }

    public void removeSelectorListener(@NotNull SelectorListener<S> listener) {
        this.selectorComponent.removeSelectorListener(listener);
    }

    public void setSelectedOption(S selectedOption) {
        this.selectorComponent.setSelectedOption(selectedOption);
    }

    public S getSelectedOption() {
        return this.selectorComponent.getSelectedOption();
    }

    public boolean isValidSelection() {
        return this.selectorComponent.isValidSelection();
    }

    public void setSelectorEnabled(boolean enabled) {
        this.selectorComponent.setSelectorEnabled(enabled);
    }

    public void setSelectorVisible(boolean visible) {
        this.selectorComponent.setSelectorVisible(visible);
    }

    public Panel getInnerPanel() {
        return this.innerPanel;
    }

    public void addOption(@NotNull S option) {
        this.selectorComponent.addOption(option);
        this.revalidate();
    }

    public Sequence<S> getOptions() {
        return this.selectorComponent.getOptions();
    }

    protected abstract Panel createInnerPanel(@NotNull UiContainer var1, @NotNull S var2);

    protected abstract SelectorComponent<S> createOptionsComponent(@NotNull UiContainer var1);

    protected SelectorComponent<S> getOptionsComponent() {
        return this.selectorComponent;
    }

    protected Msg getLabel() {
        return this.label;
    }

    protected boolean canAddEmptyInnerPanel() {
        return false;
    }

    protected void applySelectionChanges() {
    }

    protected void selectionModified() {
        this.clearContent();
        if (this.getSelectedOption() != null && this.isValidSelection()) {
            this.applySelectionChanges();
            this.innerPanel = this.createInnerPanel((UiContainer)this, this.getSelectedOption());
            if (this.innerPanel != null && (this.canAddEmptyInnerPanel() || !this.innerPanel.getChildren().isEmpty())) {
                this.add((UiComponent)this.innerPanel, "gapy 5, grow");
            }
        }
        this.revalidate();
    }

    private void init(Msg title, int insets) {
        if (title != null) {
            this.setBorder((Border)new TitledBorder(title));
        }
        String layoutConstraints = "fill, hidemode 3, gap 0, ins " + insets;
        this.setLayout((Layout)new MigLayout(layoutConstraints));
        this.selectorComponent = this.createOptionsComponent((UiContainer)this);
        this.add(this.selectorComponent.getUiComponent(), "growx, wrap");
        this.selectorComponent.addSelectorListener(new SelectorListener.SelectionListenerAdapter<S>(){

            @Override
            public void selectionChanged() {
                AbstractSelectorPanel.this.selectionModified();
            }
        });
    }

    private void clearContent() {
        if (this.innerPanel != null) {
            this.innerPanel.getParent().remove((UiComponent)this.innerPanel);
        }
    }
}

