/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search.impl;

import java.util.ArrayList;
import oracle.bpm.designer.IconFactory;
import oracle.bpm.designer.search.Match;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.ui.Image;

public abstract class TypeDescriptionMatch
implements Match {
    private TypeDescription type;

    public TypeDescriptionMatch(TypeDescription typeDescription) {
        this.type = typeDescription;
    }

    public ProjectObject getSource() {
        FuegoProject project = FuegoProject.getFrom((TypeRef)this.type);
        return CatalogObjectImpl.create((Project)project, (TypeRef)(this.type.isMember() ? this.type.getParent() : this.type));
    }

    @Override
    public Image getIcon() {
        return IconFactory.getIconFor(this.type);
    }

    @Override
    public Object[] getSourcePath() {
        TypeDescription td = this.type;
        ArrayList<TypeDescription> path = new ArrayList<TypeDescription>();
        boolean doContinue = false;
        do {
            path.add(0, td);
            td = td.getParent();
            doContinue = td != null && !td.equals(TypeUtils.getDefaultCatalog().getRoot());
        } while (doContinue = doContinue && !td.isModule());
        return path.toArray();
    }
}

