/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search.impl;

import oracle.bpm.designer.context.ProjectObjectUI;
import oracle.bpm.designer.context.QuerySource;
import oracle.bpm.designer.context.QuerySourceAdapter;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.search.Match;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.ui.Image;

public class ProcessMatchFactory {
    public static Image getIconFor(QuerySource source) {
        if (source == null) {
            return null;
        }
        return ProjectObjectUI.getIconForObject(source.getProjectObjectType());
    }

    public static String getTextFor(QuerySource qs) {
        String text = qs.toString();
        if (qs.getProjectObjectType() == ProjectObjectType.LANE) {
            LaneImpl laneImpl = (LaneImpl)qs;
            text = laneImpl.getDefaultLabel();
        }
        return text;
    }

    public static Match createActivityDescriptionMatch(FlowNode node) {
        return new ActivityDescriptionMatch(node);
    }

    public static Match createActivityLabelMatch(FlowNode node) {
        return new ActivityLabelMatch(node);
    }

    public static Match createRoleDescriptionMatch(LaneImpl info) {
        return new RoleDescriptionMatch(info);
    }

    public static Match createRoleLabelMatch(LaneImpl info) {
        return new RoleLabelMatch(info);
    }

    public static Match createTransitionDescriptionMatch(SequenceFlow obj) {
        return new TransitionDescriptionMatch(obj);
    }

    public static Match createTransitionLabelMatch(SequenceFlow obj) {
        return new TransitionLabelMatch(obj);
    }

    private static class TransitionLabelMatch
    extends QuerySourceMatchAdapter {
        public TransitionLabelMatch(SequenceFlow transition) {
            super(QuerySourceAdapter.getQuerySource((ProjectObject)transition));
        }

        @Override
        public String getText() {
            return DesignerMsg.INPUT_LABEL.toString();
        }
    }

    private static class TransitionDescriptionMatch
    extends QuerySourceMatchAdapter {
        public TransitionDescriptionMatch(SequenceFlow transition) {
            super(QuerySourceAdapter.getQuerySource((ProjectObject)transition));
        }

        @Override
        public String getText() {
            return DesignerMsg.DESCRIPTION.toString();
        }
    }

    private static class RoleLabelMatch
    extends QuerySourceMatchAdapter {
        public RoleLabelMatch(LaneImpl info) {
            super(QuerySourceAdapter.getQuerySource((ProjectObject)info));
        }

        @Override
        public String getText() {
            return DesignerMsg.INPUT_LABEL.toString();
        }
    }

    private static class RoleDescriptionMatch
    extends QuerySourceMatchAdapter {
        public RoleDescriptionMatch(LaneImpl info) {
            super(QuerySourceAdapter.getQuerySource((ProjectObject)info));
        }

        @Override
        public String getText() {
            return DesignerMsg.DESCRIPTION.toString();
        }
    }

    private static class QuerySourceMatchAdapter
    implements Match<ProjectObject> {
        private QuerySource<ProjectObject> qs;

        public QuerySourceMatchAdapter(QuerySource<ProjectObject> qs) {
            this.qs = qs;
        }

        @Override
        public Image getIcon() {
            return this.qs.getIcon();
        }

        @Override
        public ProjectObject getSource() {
            return this.qs.getObject();
        }

        @Override
        public Object[] getSourcePath() {
            ProjectObject object = this.getSource();
            return new Object[]{object};
        }

        @Override
        public String getSourceText() {
            return this.qs.toString();
        }

        @Override
        public String getText() {
            return this.qs.toString();
        }

        @Override
        public void edit(Exception exception) {
            this.qs.editQuery(exception);
        }

        @Override
        public void select(Exception exception) {
            this.qs.selectQuery(exception);
        }
    }

    private static class ActivityLabelMatch
    extends QuerySourceMatchAdapter {
        public ActivityLabelMatch(FlowNode node) {
            super(QuerySourceAdapter.getQuerySource((ProjectObject)node));
        }

        @Override
        public String getText() {
            return DesignerMsg.NAME.toString();
        }

        @Override
        public void edit(Exception exception) {
            super.edit(exception);
        }
    }

    private static class ActivityDescriptionMatch
    extends QuerySourceMatchAdapter {
        public ActivityDescriptionMatch(FlowNode node) {
            super(QuerySourceAdapter.getQuerySource((ProjectObject)node));
        }

        @Override
        public String getText() {
            return DesignerMsg.DESCRIPTION.toString();
        }
    }
}

