/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search.impl;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.search.impl.TypeDescriptionMatch;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.TypeDescription;

public class MethodSrcMatch
extends TypeDescriptionMatch {
    private String codeText;
    private int column;
    private int line;
    private MethodTypeDescription method;

    public MethodSrcMatch(MethodTypeDescription method, String codeText, int line, int column) {
        super(method);
        this.method = method;
        this.codeText = codeText;
        this.line = line;
        this.column = column;
    }

    @Override
    public String getSourceText() {
        TypeDescription parent = this.method.getParent();
        return (parent != null ? parent.getName() + "." : "") + this.method.getName();
    }

    @Override
    public String getText() {
        return DesignerMsg.CODE.getString() + " (" + this.line + "," + this.column + ") " + this.codeText;
    }

    @Override
    public void edit(Exception exception) {
    }

    @Override
    public void select(Exception exception) {
    }
}

