/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search.impl;

import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.search.impl.TypeDescriptionMatch;
import oracle.bpm.lang.MethodTypeDescription;

public class MethodDocMatch
extends TypeDescriptionMatch {
    private int column;
    private int line;
    private MethodTypeDescription member;
    private String text;

    public MethodDocMatch(MethodTypeDescription mtd, String text, int line, int column, int offset, int endColumn) {
        super(mtd);
        this.member = mtd;
        this.text = text;
        this.line = line;
        this.column = column;
    }

    @Override
    public String getSourceText() {
        return this.member.getText();
    }

    @Override
    public String getText() {
        return DesignerMsg.DOCUMENTATION.getString() + " (" + this.line + "," + this.column + ") " + this.text;
    }

    @Override
    public void edit(Exception exception) {
        OpenCloseMemberAction.openMember(this.member, this.line);
    }

    @Override
    public void select(Exception exception) {
    }
}

