/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.collections.iterator.IterableAdaptor;
import oracle.bpm.designer.search.AbstractSearchPath;
import oracle.bpm.designer.search.Finder;
import oracle.bpm.designer.search.SearchPathInterface;

class SearchPath
extends AbstractSearchPath {
    private File file;
    private FileFilter filter;

    public SearchPath(File file, FileFilter filter, boolean recursive, String type) {
        super(recursive, type);
        this.file = file;
        this.filter = filter;
    }

    @Override
    public Iterable<Finder.Readable> getContents() {
        return new IterableAdaptor<File, Finder.Readable>(this.listFiles()){

            @Override
            public Finder.Readable adapt(final File file) {
                return new Finder.Readable(){

                    @Override
                    public InputStream getNewInputStream() throws FileNotFoundException {
                        return new FileInputStream(file);
                    }

                    @Override
                    public String getName() {
                        return file.getName();
                    }

                    @Override
                    public String getPath() {
                        return file.getPath();
                    }
                };
            }
        };
    }

    @Override
    public Collection getDirectories() {
        return CollectionFactory.createCollectionWith(this.file.listFiles(Finder.dirFilter));
    }

    public FileFilter getFileFilter() {
        return this.filter;
    }

    @Override
    public SearchPathInterface createChild(Object directory) {
        return new SearchPath((File)directory, this.getFileFilter(), this.isRecursive(), this.getType());
    }

    public String toString() {
        return "Path " + this.file.getName();
    }

    private List<File> listFiles() {
        if (this.file.isFile()) {
            return Collections.singletonList(this.file);
        }
        return Arrays.asList(this.filter == null ? this.file.listFiles() : this.file.listFiles(this.filter));
    }
}

