/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search;

import java.util.List;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.search.SearchPanelCallback;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.msg.UIMsg;

public class SearchPanel
extends BorderPanel {
    private Panel buttonsPanel;
    private final SearchPanelCallback callback;
    private boolean canSearchAll;
    private CheckBox matchCaseCheckBox;
    private CheckBox regexpCheckBox;
    private CheckBox searchAllCheckBox;
    private Button searchButton;
    private SearchComboBox searchComboBox;

    public SearchPanel(UiContainer parent, List<String> lastWords, boolean canSearchAll, SearchPanelCallback callback) {
        super(parent);
        this.canSearchAll = canSearchAll;
        this.callback = callback;
        this.setLayout((Layout)new BorderLayout());
        this.add((UiComponent)this.createPropertiesPanel((UiContainer)this), "Center");
        this.add((UiComponent)this.createButtons((UiContainer)this), "South");
        this.loadLastWords(lastWords);
        this.searchComboBox.requestFocus();
    }

    public Button getSearchButton() {
        return this.searchButton;
    }

    public Panel createPropertiesPanel(UiContainer parent) {
        Panel container = new Panel(parent);
        FormLayout layout = new FormLayout("2dlu, pref, 8dlu, 100dlu:grow", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref");
        CellConstraints cc = layout.createCellConstraints();
        this.matchCaseCheckBox = CheckBox.create((UiContainer)container, (Msg)DesignerMsg.MATCHCASE);
        this.regexpCheckBox = CheckBox.create((UiContainer)container, (Msg)DesignerMsg.REGULAR_EXPRESSION);
        this.searchAllCheckBox = CheckBox.create((UiContainer)container, (Msg)DesignerMsg.INCLUDE_ALL_PROJECT);
        if (!this.canSearchAll) {
            this.searchAllCheckBox.setSelected(true);
            this.searchAllCheckBox.setEnabled(false);
        }
        this.searchComboBox = new SearchComboBox((UiContainer)container);
        Label label = Label.create((UiContainer)container, (Msg)DesignerMsg.SEARCH_ITEMS);
        container.setLayout((Layout)layout);
        container.add((UiComponent)label, (Object)cc.xy(2, 1));
        container.add((UiComponent)this.searchComboBox, (Object)cc.xy(4, 1));
        container.add((UiComponent)this.matchCaseCheckBox, (Object)cc.xyw(2, 3, 3));
        container.add((UiComponent)this.regexpCheckBox, (Object)cc.xyw(2, 5, 3));
        container.add((UiComponent)this.searchAllCheckBox, (Object)cc.xyw(2, 7, 3));
        return container;
    }

    public Panel createButtons(UiContainer parent) {
        this.buttonsPanel = new Panel(parent);
        this.buttonsPanel.setLayout((Layout)new FlowLayout());
        this.searchButton = new Button((UiContainer)this.buttonsPanel, new BaseAction(DesignerMsg.SEARCH){

            public void run() {
                if (SearchPanel.this.callback != null) {
                    SearchPanel.this.callback.doQuery();
                }
            }
        });
        Button clearButton = new Button((UiContainer)this.buttonsPanel, new BaseAction(DesignerMsg.CLEAR_SEARCH){

            public void run() {
                SearchPanel.this.getSearchComboBox().setSelectedItem("");
            }
        });
        Button closeButton = new Button((UiContainer)this.buttonsPanel, new BaseAction(UIMsg.CLOSE){

            public void run() {
                SearchPanel.this.getParent().getOwnerWindow().setVisible(false);
            }
        });
        this.buttonsPanel.add((UiComponent)this.searchButton);
        this.buttonsPanel.add((UiComponent)clearButton);
        this.buttonsPanel.add((UiComponent)closeButton);
        return this.buttonsPanel;
    }

    public Panel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public boolean isCaseSensitive() {
        return this.matchCaseCheckBox.isSelected();
    }

    public boolean isRegExp() {
        return this.regexpCheckBox.isSelected();
    }

    public boolean isSearchAll() {
        return this.searchAllCheckBox.isSelected();
    }

    public String getSearchText() {
        String item = (String)this.searchComboBox.getSelectedItem();
        return item != null ? item : this.searchComboBox.getText();
    }

    private SearchComboBox getSearchComboBox() {
        return this.searchComboBox;
    }

    private void loadLastWords(List<String> words) {
        if (!words.isEmpty()) {
            SearchComboBox searchComboBox = this.getSearchComboBox();
            searchComboBox.removeAllItems();
            for (String word : words) {
                searchComboBox.addItem(word);
            }
            if (!words.isEmpty()) {
                searchComboBox.setSelectedItem(words.get(0));
            }
        }
    }

    public static class SearchComboBox
    extends ComboBox<String> {
        public SearchComboBox(UiContainer parent) {
            super(parent, true);
            this.setName("studio-search");
            this.setMaximumRowCount(10);
            this.putClientProperty("ComboBox.lightweightKeyboardNavigation", "Lightweight");
        }
    }
}

