/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.search.FindSupport;
import oracle.bpm.designer.search.Match;
import oracle.bpm.designer.search.impl.ProcessMatchFactory;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.project.LaneImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.util.ProgressMonitor;

public class ProcessFindSupport
extends FindSupport {
    public static final String PROCESS_EXTENSION = ".xpdl";
    public static final String SCREENFLOW_EXTENSION = ".xsdl";

    @Override
    public String getType() {
        return "process";
    }

    public List<Match> deepSearch(List targets, Matcher match, ProgressMonitor monitor) throws Exception {
        this.matcher = match;
        this.phase(monitor, DesignerMsg.PROCESS_FILENAME);
        ArrayList<Match> result = new ArrayList<Match>();
        ProjectRepository repository = RepositoryService.getInstance().getActiveRepository();
        Collection openedProjects = repository.getOpenedProjects();
        for (Project project : openedProjects) {
            Collection models = project.getProcesses();
            for (Process model : models) {
                this.searchActivities(model, result);
                this.searchRoles(model, result);
                this.searchTransitions(model, result);
            }
        }
        return result;
    }

    @Override
    protected Match createMethodNameMatch(MethodTypeDescription method) {
        return null;
    }

    @Override
    protected Match createMethodSrcMatch(MethodTypeDescription method, String codeText, int line, int column, int offset, int endColumn) {
        return null;
    }

    private void searchActivities(Process content, List<Match> matches) {
        Sequence nodeList = content.getFlowNodes();
        for (FlowNode node : nodeList) {
            String description;
            this.matcher.reset(node.getDefaultLabel());
            if (this.matcher.find()) {
                matches.add(ProcessMatchFactory.createActivityLabelMatch(node));
            }
            if ((description = node.getDescriptionMap().getString()) == null || "".equals(description.trim())) continue;
            this.matcher.reset(description);
            if (!this.matcher.find()) continue;
            matches.add(ProcessMatchFactory.createActivityDescriptionMatch(node));
        }
    }

    private void searchRoles(Process content, List<Match> matches) {
        for (Lane lane : content.getLanes()) {
            String description;
            LaneImpl obj = (LaneImpl)lane;
            if (obj.isAutomatic()) continue;
            this.matcher.reset(obj.getDefaultLabel());
            if (this.matcher.find()) {
                matches.add(ProcessMatchFactory.createRoleLabelMatch(obj));
            }
            if ((description = obj.getDescriptionMap().getString()) == null || "".equals(description.trim())) continue;
            this.matcher.reset(description);
            if (!this.matcher.find()) continue;
            matches.add(ProcessMatchFactory.createRoleDescriptionMatch(obj));
        }
    }

    private void searchTransitions(Process content, List<Match> matches) {
        for (SequenceFlow transition : content.getSequenceFlows()) {
            String description;
            String label = transition.getDefaultLabel();
            if (label == null) continue;
            System.out.println("ProcessFindSupport.searchTransitions() " + label);
            this.matcher.reset(label);
            if (this.matcher.find()) {
                matches.add(ProcessMatchFactory.createTransitionLabelMatch(transition));
            }
            if ((description = transition.getDescriptionMap().getString()) == null || "".equals(description.trim())) continue;
            this.matcher.reset(description);
            if (!this.matcher.find()) continue;
            matches.add(ProcessMatchFactory.createTransitionDescriptionMatch(transition));
        }
    }
}

