/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.designer.search.FindSupport;
import oracle.bpm.designer.search.Match;
import oracle.bpm.designer.search.ProcessFindSupport;
import oracle.bpm.designer.search.SearchPath;
import oracle.bpm.designer.search.SearchPathInterface;
import oracle.bpm.project.io.FileSystemTokens;
import oracle.bpm.project.io.fs.FileProjectWriter;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.util.ProgressMonitor;

public class Finder {
    static FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };
    private static ProcessFindSupport processFindSupport = new ProcessFindSupport();
    public static final String PROCESS = "process";
    public static final String CATALOG = "catalog";

    public static List<Match> find(Collection<? extends ProjectObject> projectObjects, String pattern, ProgressMonitor monitor, boolean caseSensitive, boolean isRegExp) throws Exception {
        Set<FindSupport> findSupports = Finder.getFindSupports(projectObjects);
        SearchPathInterface[] searchPaths = Finder.getSearchPaths(projectObjects);
        if (findSupports == null || searchPaths == null) {
            return new ArrayList<Match>();
        }
        int progress = 0;
        int increment = 100 / (findSupports.isEmpty() ? 1 : findSupports.size() * 2);
        if (!isRegExp) {
            pattern = "\\Q" + pattern + "\\E";
        }
        Pattern regexpPattern = Pattern.compile(pattern, caseSensitive ? 0 : 2);
        HashMap candidatesByType = new HashMap();
        for (SearchPathInterface searchPath : searchPaths) {
            ArrayList<Readable> readableList = (ArrayList<Readable>)candidatesByType.get(searchPath.getType());
            if (readableList == null) {
                readableList = new ArrayList<Readable>();
                candidatesByType.put(searchPath.getType(), readableList);
            }
            Collection<Readable> result = Finder.quickSearch(searchPath, regexpPattern, monitor);
            readableList.addAll(result);
        }
        Matcher matcher = regexpPattern.matcher("");
        ArrayList<Match> occurrences = new ArrayList<Match>();
        for (FindSupport findSupport : findSupports) {
            if (monitor != null) {
                monitor.progress(progress);
                progress += increment;
            }
            List candidates = (List)candidatesByType.get(findSupport.getType());
            List<Match> matches = findSupport.deepSearch(candidates, matcher, monitor);
            occurrences.addAll(matches);
        }
        return occurrences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean grep(InputStream stream, Charset charset, Pattern pattern) throws IOException {
        block8: {
            Matcher matcher = pattern.matcher("");
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            LineReader r = new LineReader(reader);
            boolean eof = false;
            block4: while (true) {
                if (!eof) {
                    StringBuffer sb = new StringBuffer(200);
                    int eolStrLength = r.readLine(sb);
                    int lineLength = sb.length();
                    int start = 0;
                    eof = eolStrLength == -1;
                    String line = sb.toString();
                    while (true) {
                        if (start >= lineLength) continue block4;
                        matcher.reset(line);
                        if (matcher.find(start)) {
                            boolean bl = true;
                            return bl;
                        }
                        start = lineLength;
                    }
                }
                break block8;
                break;
            }
            finally {
                ((Reader)reader).close();
            }
        }
        return false;
    }

    protected static void search(List<Readable> occurrences, SearchPathInterface directory, Pattern pattern, ProgressMonitor monitor) throws IOException {
        for (Readable r : directory.getContents()) {
            try {
                Charset xmlCharset = Finder.getXmlCharset(r.getNewInputStream());
                InputStream i = r.getNewInputStream();
                if (xmlCharset == null || !Finder.grep(i, xmlCharset, pattern)) continue;
                occurrences.add(r);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Readable dir : directory.listDirectories()) {
            SearchPathInterface path = directory.createChild(dir);
            Finder.search(occurrences, path, pattern, monitor);
        }
    }

    private static FindSupport getCatalogFindSupport() {
        return null;
    }

    private static String getEncoding(String xmlDecl) {
        String enc = xmlDecl.substring(xmlDecl.indexOf("encoding") + 8);
        StringBuffer code = new StringBuffer();
        int i = 0;
        while (enc.charAt(i) == ' ') {
            ++i;
        }
        if (enc.charAt(i++) != '=') {
            return null;
        }
        while (enc.charAt(i) == ' ') {
            ++i;
        }
        if (enc.charAt(i++) != '\"') {
            return null;
        }
        while (enc.charAt(i) != '\"') {
            code.append(enc.charAt(i++));
        }
        return code.toString();
    }

    private static Set<FindSupport> getFindSupports(Collection<? extends ProjectObject> node) {
        HashSet<FindSupport> all = new HashSet<FindSupport>();
        for (ProjectObject projectObject : node) {
            Finder.addFindSupports(projectObject, all);
        }
        return all;
    }

    private static void addFindSupports(ProjectObject node, Set<FindSupport> supports) {
        if (node != null) {
            if (node instanceof Project) {
                supports.add(Finder.getCatalogFindSupport());
                supports.add(Finder.getProcessFindSupport());
            }
            if (node instanceof Process) {
                supports.add(Finder.getProcessFindSupport());
            }
        }
    }

    private static FindSupport getProcessFindSupport() {
        if (processFindSupport == null) {
            processFindSupport = new ProcessFindSupport();
        }
        return processFindSupport;
    }

    private static SearchPathInterface[] getSearchPaths(Collection<? extends ProjectObject> node) throws TypeCatalogException {
        ArrayList<SearchPathInterface> all = new ArrayList<SearchPathInterface>();
        for (ProjectObject projectObject : node) {
            List<SearchPathInterface> temp = Finder.getSearchPaths(projectObject);
            all.removeAll(temp);
            all.addAll(temp);
        }
        return all.toArray(new SearchPathInterface[all.size()]);
    }

    private static List<SearchPathInterface> getSearchPaths(ProjectObject projectObject) throws TypeCatalogException {
        ArrayList<SearchPathInterface> list = new ArrayList<SearchPathInterface>();
        if (projectObject instanceof Project && ((Project)projectObject).isOpen()) {
            Project project = (Project)projectObject;
            MutableComponentCatalog catalog = (MutableComponentCatalog)project.getComponentCatalog();
            list.add(new SearchPath(catalog.getDefaultStorageBundle().getBasePath(), FileSystemTokens.componentFilter, true, CATALOG));
            FileProjectWriter projectWriter = (FileProjectWriter)project.getWriter();
            list.add(new SearchPath(projectWriter.getProjectFileSystem().getLocalFileSystem().getProcessesFolder(), FileSystemTokens.processFilter, true, PROCESS));
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Charset getXmlCharset(InputStream stream) throws IOException {
        BufferedReader reader = null;
        try {
            String enc;
            InputStreamReader streamReader = new InputStreamReader(stream);
            reader = new BufferedReader(streamReader);
            String line = reader.readLine();
            if (line.startsWith("<?xml") && (enc = Finder.getEncoding(line)) != null && Charset.isSupported(enc)) {
                Charset charset = Charset.forName(enc);
                return charset;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return null;
    }

    private static Collection<Readable> quickSearch(SearchPathInterface searchPath, Pattern regexpPattern, ProgressMonitor monitor) throws IOException {
        ArrayList<Readable> occurrences = new ArrayList<Readable>();
        Finder.search(occurrences, searchPath, regexpPattern, monitor);
        System.gc();
        return occurrences;
    }

    private static class LineReader {
        protected boolean fPushback;
        protected int fPushbackChar;
        private Reader reader;
        protected static final int fgLF = 10;
        protected static final int fgCR = 13;

        public LineReader(Reader reader) {
            this.reader = reader;
        }

        protected int readLine(StringBuffer sb) throws IOException {
            int ch;
            if (this.fPushback) {
                ch = this.fPushbackChar;
                this.fPushback = false;
            } else {
                ch = this.reader.read();
            }
            while (ch >= 0) {
                if (ch == 10) {
                    return 1;
                }
                if (ch == 13) {
                    ch = this.reader.read();
                    if (ch == 10) {
                        return 2;
                    }
                    this.fPushbackChar = ch;
                    this.fPushback = true;
                    return 1;
                }
                sb.append((char)ch);
                ch = this.reader.read();
            }
            return -1;
        }
    }

    public static interface Readable {
        public String getName();

        public InputStream getNewInputStream() throws Exception;

        public String getPath();
    }
}

