/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.ExtToolTipManager;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MenuItem;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.tree.AbstractTreeTableModel;
import oracle.bpm.ui.treetable.TreeTable;
import oracle.bpm.ui.treetable.TreeTableModel;

public abstract class AbstractTreeTable
extends TreeTable {
    protected MenuItem gotoItem;
    protected PopupMenu popup;
    private FindModel findModel;

    public AbstractTreeTable(UiContainer parent, FindModel findModel) {
        super(parent, (TreeTableModel)findModel);
        this.findModel = findModel;
        ExtToolTipManager extToolTipManager = ExtToolTipManager.sharedInstance();
        extToolTipManager.registerComponent((UiComponent)this);
        NodeTreeProvider provider = new NodeTreeProvider();
        this.getColumn(0).setLabelProvider((LabelProvider)provider);
        this.setRootVisible(false);
        this.setShowGrid(false);
    }

    public abstract void showPopup(Point var1);

    public void clear() {
        this.getFindModel().clearAll();
    }

    protected FindModel getFindModel() {
        return this.findModel;
    }

    protected void copyCurrentNode() {
        Node current = (Node)this.getSelectionPath().getLastPathComponent();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(current.toString()), null);
    }

    private static class NodeTreeProvider
    extends LabelProvider.Default<Node> {
        private NodeTreeProvider() {
        }

        public Image getIcon(Node node) {
            boolean isRootChild;
            Image icon = null;
            boolean bl = isRootChild = node.getParentCount() == 1;
            if (!isRootChild) {
                icon = node.getIcon();
            }
            return icon;
        }

        public String getText(Node node) {
            return String.valueOf(node);
        }
    }

    static class FindModel
    extends AbstractTreeTableModel {
        private static final String[] columns = new String[]{"Description"};
        private static final Class[] classes_sd = new Class[]{String.class};

        public FindModel() {
            super((Object)new Node("<root>"));
        }

        public boolean isCellEditable(Object node, int column) {
            return true;
        }

        public Object getChild(Object parent, int index) {
            return ((Node)parent).getChildAt(index);
        }

        public int getChildCount(Object parent) {
            return ((Node)parent).getChildCount();
        }

        public Object[] getChildren(Object parentElement) {
            int nCount = this.getChildCount(parentElement);
            Object[] children = new Object[nCount];
            for (int i = 0; i < nCount; ++i) {
                children[i] = this.getChild(parentElement, i);
            }
            return children;
        }

        public Class getColumnClass(int column) {
            return classes_sd[column];
        }

        public int getColumnCount() {
            return columns.length;
        }

        public String getColumnName(int column) {
            return columns[column];
        }

        public Object getParent(Object node) {
            return ((Node)node).getParent();
        }

        public Node[] getPathFor(Node nodeToFind) {
            Node property = this.findNode((Node)this.getRoot(), nodeToFind);
            if (property == null) {
                return new Node[0];
            }
            LinkedList<Node> properties = new LinkedList<Node>();
            properties.add(property);
            for (Node parent = property.getParent(); parent != null; parent = parent.getParent()) {
                properties.addFirst(parent);
            }
            return properties.toArray(new Node[properties.size()]);
        }

        public Node[] getPathToRoot(Node aNode) {
            return this.getPathToRoot(aNode, 0);
        }

        public Object getValueAt(Object node, int column) {
            return node.toString();
        }

        public void clearAll() {
            ((Node)this.getRoot()).clear();
            this.reload();
        }

        public void reload() {
            this.reload((Node)this.getRoot());
        }

        public void reload(Node node) {
            if (node != null) {
                Object[] path = this.getPathToRoot(node);
                this.fireTreeStructureChanged((Object)this, path, null, null);
            }
        }

        protected Node[] getPathToRoot(Node aNode, int depth) {
            Node[] retNodes;
            if (aNode != null) {
                retNodes = aNode == this.getRoot() ? new Node[depth] : this.getPathToRoot(aNode.getParent(), ++depth);
                retNodes[retNodes.length - depth] = aNode;
            } else {
                if (depth == 0) {
                    return null;
                }
                retNodes = new Node[depth];
            }
            return retNodes;
        }

        private Node findNode(Node current, Node nodeToFind) {
            if (current == nodeToFind) {
                return current;
            }
            List childList = current.getChilds();
            int count = childList != null ? childList.size() : 0;
            for (int i = 0; i < count; ++i) {
                Node found = this.findNode(current.getChildAt(i), nodeToFind);
                if (found == null) continue;
                return found;
            }
            return null;
        }
    }

    public static class Node {
        private List<Node> childs;
        private Object content;
        private Image icon;
        private Node parent;
        private Map properties = new HashMap();
        private boolean summaryNode;

        public Node(Object content) {
            this.content = content;
        }

        public Node getChildAt(int index) {
            return this.childs == null ? null : this.childs.get(index);
        }

        public int getChildCount() {
            return this.childs == null ? 0 : this.childs.size();
        }

        public List getChilds() {
            return this.childs;
        }

        public Object getClientProperty(Object key) {
            return this.properties.get(key);
        }

        public void setIcon(Image icon) {
            this.icon = icon;
        }

        public Image getIcon() {
            return this.icon;
        }

        public int getIndexOfChild(Node child) {
            return this.childs == null ? -1 : this.childs.indexOf(child);
        }

        public void setParent(Node node) {
            this.parent = node;
        }

        public Node getParent() {
            return this.parent;
        }

        public int getParentCount() {
            int i = 0;
            for (Node parent = this.getParent(); parent != null; parent = parent.getParent()) {
                ++i;
            }
            return i;
        }

        public void setSummaryNode(boolean summaryNode) {
            this.summaryNode = summaryNode;
        }

        public void addChild(Node child) {
            this.addChild(child, -1);
        }

        public void clear() {
            if (this.childs != null) {
                this.childs = new ArrayList<Node>();
            }
        }

        public int indexOfChildContent(Object o) {
            if (this.childs != null && o != null) {
                Node[] list = this.childs.toArray(new Node[this.childs.size()]);
                for (int i = 0; i < list.length; ++i) {
                    if (!o.equals(list[i].content)) continue;
                    return i;
                }
            }
            return -1;
        }

        public void insertChild(int index, Node child) {
            assert (index >= 0) : "Illegal index for child";
            this.addChild(child, index);
        }

        public void putClientProperty(Object key, Object value) {
            this.properties.put(key, value);
        }

        public String toString() {
            String text = this.getText();
            if (!this.isSummaryNode()) {
                text = text + " (" + this.getLeafCount() + ")";
            }
            return text;
        }

        protected String getText() {
            return this.content == null ? "no name!" : this.content.toString();
        }

        private int getLeafCount() {
            int leafs = 0;
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (this.getChildAt(i).getChildCount() == 0) {
                    ++leafs;
                    continue;
                }
                leafs += this.getChildAt(i).getLeafCount();
            }
            return leafs;
        }

        private boolean isSummaryNode() {
            return this.summaryNode;
        }

        private void addChild(Node child, int index) {
            assert (this != child) : "Child and 'this' are the same reference!";
            assert (index <= 0 || index < this.getChilds().size()) : "Illegal index for child";
            child.setParent(this);
            if (this.childs == null) {
                this.childs = new ArrayList<Node>();
            }
            if (index < 0) {
                this.childs.add(child);
            } else {
                this.childs.add(index, child);
            }
        }
    }
}

