/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.search;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import oracle.bpm.designer.context.ProjectObjectUI;
import oracle.bpm.designer.context.QuerySource;
import oracle.bpm.draw.Font;
import oracle.bpm.geom.Point;
import oracle.bpm.ui.ExtToolTipManager;
import oracle.bpm.ui.FontProvider;
import oracle.bpm.ui.FontStyle;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.KeyStroke;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.MouseEventUtilities;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseAdapter;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.tree.AbstractTreeTableModel;
import oracle.bpm.ui.tree.TreePath;
import oracle.bpm.ui.treetable.TreeTable;
import oracle.bpm.ui.treetable.TreeTableModel;

public abstract class AbstractQueryTreeTable
extends TreeTable {
    private QueryModel queryModel;

    public AbstractQueryTreeTable(UiContainer parent, QueryModel queryModel) {
        super(parent, (TreeTableModel)queryModel);
        this.setQueryModel(queryModel);
        ExtToolTipManager extToolTipManager = ExtToolTipManager.sharedInstance();
        extToolTipManager.registerComponent((UiComponent)this);
        MessageFontLabelProvider provider = new MessageFontLabelProvider(this.getFont());
        this.setDefaultLabelProvider(String.class, (LabelProvider)provider);
        this.setDefaultFontProvider(String.class, provider);
        this.setRootVisible(false);
        this.setShowGrid(false);
        this.addListener();
    }

    public abstract void showPopup(Point var1);

    public void clear() {
        this.getQueryModel().clearAll();
    }

    protected Image getIconFor(QuerySource source) {
        Image icon = source.getIcon();
        return icon == null ? ProjectObjectUI.getIconForObject(source.getProjectObjectType()) : icon;
    }

    protected QueryModel getQueryModel() {
        return this.queryModel;
    }

    protected void copyCurrentNode() {
        Node current = (Node)this.getSelectionPath().getLastPathComponent();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(current.toString()), null);
    }

    private void setQueryModel(QueryModel queryModel) {
        this.queryModel = queryModel;
    }

    private void addListener() {
        BaseAction copyAction = new BaseAction(UIMsg.COPY){

            public void run() {
                AbstractQueryTreeTable.this.copyCurrentNode();
            }
        };
        KeyStroke copyKey = KeyStroke.getKeyStroke((String)"control C");
        this.getInputMap(1).put(copyKey.asSwing(), "copy-to-clipboard");
        this.getActionMap().put("copy-to-clipboard", (Action)copyAction);
        this.getInputMap(1).put(KeyStroke.getKeyStroke((String)"ENTER").asSwing(), "Tree.editQuery");
        this.getActionMap().put("Tree.editQuery", (Action)new BaseAction(){

            public void run() {
                TreePath selectionPath = AbstractQueryTreeTable.this.getSelectionPath();
                if (selectionPath == null) {
                    return;
                }
                Node current = (Node)selectionPath.getLastPathComponent();
                QuerySource source = current.getSource();
                if (source == null) {
                    return;
                }
                source.editQuery(current.getException());
                if (AbstractQueryTreeTable.this.isCollapsed(selectionPath)) {
                    AbstractQueryTreeTable.this.expandPath(selectionPath);
                } else {
                    AbstractQueryTreeTable.this.collapsePath(selectionPath);
                }
                AbstractQueryTreeTable.this.setSelectionPath(selectionPath);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke((int)37, (int)0).asSwing(), "Tree.collapse");
        this.getActionMap().put("Tree.collapse", (Action)new BaseAction(){

            public void run() {
                TreePath selectionPath = AbstractQueryTreeTable.this.getSelectionPath();
                if (selectionPath == null) {
                    return;
                }
                Node current = (Node)selectionPath.getLastPathComponent();
                if (current == null) {
                    return;
                }
                if (current.getChildCount() > 0) {
                    AbstractQueryTreeTable.this.collapsePath(selectionPath);
                }
                AbstractQueryTreeTable.this.setSelectionPath(selectionPath);
            }
        });
        this.getInputMap(1).put(KeyStroke.getKeyStroke((int)39, (int)0).asSwing(), "Tree.expand");
        this.getActionMap().put("Tree.expand", (Action)new BaseAction(){

            public void run() {
                TreePath selectionPath = AbstractQueryTreeTable.this.getSelectionPath();
                if (selectionPath == null) {
                    return;
                }
                Node current = (Node)selectionPath.getLastPathComponent();
                if (current == null) {
                    return;
                }
                if (current.getChildCount() > 0) {
                    AbstractQueryTreeTable.this.expandPath(selectionPath);
                }
                AbstractQueryTreeTable.this.setSelectionPath(selectionPath);
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            private void processMouseEvent(MouseEvent e) {
                if (MouseEventUtilities.isPopupTrigger((MouseEvent)e)) {
                    final Point point = e.getPoint();
                    UiUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AbstractQueryTreeTable.this.showPopup(point);
                        }
                    });
                } else {
                    if (!e.isButton1() || e.getClickCount() != 2 || !e.isMouseClicked()) {
                        return;
                    }
                    TreePath selectionPath = AbstractQueryTreeTable.this.getSelectionPath();
                    if (selectionPath == null) {
                        return;
                    }
                    final Node current = (Node)selectionPath.getLastPathComponent();
                    final QuerySource source = current.getSource();
                    if (source != null) {
                        UiUtilities.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                source.editQuery(current.getException());
                            }
                        });
                    }
                }
            }

            public void mousePressed(MouseEvent e) {
                this.processMouseEvent(e);
            }

            public void mouseClicked(MouseEvent e) {
                this.processMouseEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.processMouseEvent(e);
            }
        };
        this.addMouseListener((MouseListener)mouseAdapter);
    }

    private static class MessageFontLabelProvider
    extends LabelProvider.Default<Node>
    implements FontProvider<Node> {
        private Font font;

        MessageFontLabelProvider(Font font) {
            this.font = font;
        }

        public Image getIcon(Node node) {
            boolean isRootChild = node.getParentCount() == 1;
            return isRootChild ? null : node.getIcon();
        }

        public String getText(Node node) {
            String message = node.toString();
            message = message == null ? "" : message;
            message = message.replace('\n', ' ');
            message = message.replaceAll("  ", " ");
            return message;
        }

        public Font getFont(Node node) {
            boolean isRootChild = node.getParentCount() == 1;
            return isRootChild ? this.font.applyStyle(FontStyle.BOLD) : this.font;
        }
    }

    protected static class QueryModel
    extends AbstractTreeTableModel
    implements PropertyChangeListener {
        private static final String[] COLUMNS = new String[]{"Description"};
        private static final Class[] CLASSES = new Class[]{String.class};

        public QueryModel() {
            super((Object)new Node());
            ((Node)this.getRoot()).setListener(this);
        }

        public QueryModel(Node root) {
            super((Object)root);
            root.setListener(this);
        }

        public boolean isCellEditable(Object node, int column) {
            return true;
        }

        public Object getChild(Object parent, int index) {
            Node node = (Node)parent;
            return node.getChildAt(index);
        }

        public int getChildCount(Object parent) {
            Node node = (Node)parent;
            return node.getChildCount();
        }

        public Class getColumnClass(int column) {
            return CLASSES[column];
        }

        public int getColumnCount() {
            return COLUMNS.length;
        }

        public String getColumnName(int column) {
            return COLUMNS[column];
        }

        public Object getParent(Object node) {
            return ((Node)node).getParent();
        }

        public Node[] getPathFor(Node nodeToFind) {
            Node property = this.findNode((Node)this.root, nodeToFind);
            if (property == null) {
                return new Node[0];
            }
            LinkedList<Node> properties = new LinkedList<Node>();
            properties.add(property);
            for (Node parent = property.getParent(); parent != null; parent = parent.getParent()) {
                properties.addFirst(parent);
            }
            return properties.toArray(new Node[properties.size()]);
        }

        public Node[] getPathToRoot(Node aNode) {
            return this.getPathToRoot(aNode, 0);
        }

        public Object getValueAt(Object node, int column) {
            Node current = (Node)node;
            return current.toString();
        }

        public void clearAll() {
            Node node = (Node)this.getRoot();
            node.clear();
            this.reload();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.reload();
        }

        public void reload() {
            this.reload((Node)this.root);
        }

        public void reload(Node node) {
            if (node != null) {
                this.fireTreeStructureChanged(this, this.getPathToRoot(node), null, null);
            }
        }

        protected Node[] getPathToRoot(Node aNode, int depth) {
            Node[] retNodes;
            if (aNode != null) {
                retNodes = aNode != this.root ? this.getPathToRoot(aNode.getParent(), depth) : new Node[++depth];
                retNodes[retNodes.length - depth] = aNode;
            } else {
                if (depth == 0) {
                    return null;
                }
                retNodes = new Node[depth];
            }
            return retNodes;
        }

        private Node findNode(Node current, Node nodeToFind) {
            if (current == nodeToFind) {
                return current;
            }
            List<Node> childList = current.getChildren();
            int count = childList != null ? childList.size() : 0;
            for (int i = 0; i < count; ++i) {
                Node found = this.findNode(current.getChildAt(i), nodeToFind);
                if (found == null) continue;
                return found;
            }
            return null;
        }
    }

    protected static class Node {
        private List<Node> children;
        private Exception exception;
        private Image icon;
        private PropertyChangeListener listener;
        private String name;
        private Node parent;
        private Map<Object, Object> properties = new HashMap<Object, Object>();
        private QuerySource source;

        public Node() {
        }

        public Node(String name) {
            this.name = name;
        }

        public Node(QuerySource source) {
            this.source = source;
        }

        public Node(QuerySource source, Exception exception) {
            this.source = source;
            this.exception = exception;
        }

        public Node getChildAt(int index) {
            return this.children == null ? null : this.children.get(index);
        }

        public int getChildCount() {
            return this.children == null ? 0 : this.children.size();
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public Object getClientProperty(Object key) {
            return this.properties.get(key);
        }

        public int getContainerIndex(String childContainerName) {
            if (this.children == null) {
                return -1;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                Node node = this.children.get(i);
                String name = node.name;
                if (name == null || !name.equals(childContainerName)) continue;
                return i;
            }
            return -1;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setIcon(Image icon) {
            this.icon = icon;
        }

        public Image getIcon() {
            return this.icon;
        }

        public int getIndexOfChild(Object child) {
            return this.children == null ? -1 : this.children.indexOf(child);
        }

        public void setListener(PropertyChangeListener listener) {
            this.listener = listener;
        }

        public void setParent(Node node) {
            this.parent = node;
        }

        public Node getParent() {
            return this.parent;
        }

        public int getParentCount() {
            Node parent = this.getParent();
            int i = 0;
            while (parent != null) {
                parent = parent.getParent();
                ++i;
            }
            return i;
        }

        public void setSource(QuerySource source) {
            this.source = source;
        }

        public QuerySource getSource() {
            return this.source;
        }

        public int getSourceIndex(QuerySource childSource) {
            if (this.children == null) {
                return -1;
            }
            for (int i = 0; i < this.children.size(); ++i) {
                Node node = this.children.get(i);
                QuerySource source = node.getSource();
                if (source == null || !source.equals(childSource)) continue;
                return i;
            }
            return -1;
        }

        public void addChild(Node child) {
            child.putClientProperty("state", "initial");
            child.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            }
            this.children.add(child);
            if (this.listener != null) {
                this.listener.propertyChange(new PropertyChangeEvent(this, "child-added", null, null));
            }
        }

        public void clear() {
            if (this.children != null) {
                this.children = new ArrayList<Node>();
            }
        }

        public void insertChild(int index, Node child) {
            child.putClientProperty("state", "initial");
            child.setParent(this);
            if (this.children == null) {
                this.children = new ArrayList<Node>();
            }
            assert (index >= 0 && index < this.children.size()) : "Illegal index for child";
            this.children.add(index, child);
            if (this.listener != null) {
                this.listener.propertyChange(new PropertyChangeEvent(this, "child-added", null, null));
            }
        }

        public void putClientProperty(Object key, Object value) {
            this.properties.put(key, value);
        }

        public String toString() {
            if (this.source != null) {
                return this.source.toString();
            }
            if (this.name != null) {
                return this.name;
            }
            return "";
        }
    }
}

